/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;

public class HadoopSegmentMetadataPushJobRunner
implements IngestionJobRunner,
Serializable {
    private SegmentGenerationJobSpec _spec;

    public HadoopSegmentMetadataPushJobRunner() {
    }

    public HadoopSegmentMetadataPushJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
    }

    public void run() {
        String[] files;
        URI outputDirURI;
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
        try {
            outputDirURI = new URI(this._spec.getOutputDirURI());
            if (outputDirURI.getScheme() == null) {
                outputDirURI = new File(this._spec.getOutputDirURI()).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("outputDirURI is not valid - '" + this._spec.getOutputDirURI() + "'");
        }
        PinotFS outputDirFS = PinotFSFactory.create((String)outputDirURI.getScheme());
        try {
            files = outputDirFS.listFiles(outputDirURI, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list all files under outputDirURI - '" + outputDirURI + "'");
        }
        ArrayList<String> segmentsToPush = new ArrayList<String>();
        for (String file : files) {
            if (!file.endsWith(".tar.gz")) continue;
            segmentsToPush.add(file);
        }
        int pushParallelism = this._spec.getPushJobSpec().getPushParallelism();
        if (pushParallelism < 1) {
            pushParallelism = segmentsToPush.size();
        }
        try {
            Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputDirURI, (PushJobSpec)this._spec.getPushJobSpec(), (String[])segmentsToPush.toArray(new String[0]));
            SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)this._spec, (PinotFS)PinotFSFactory.create((String)outputDirURI.getScheme()), (Map)segmentUriToTarPathMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

