/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.hadoop;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.plugin.ingestion.batch.common.SegmentGenerationTaskRunner;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationTaskSpec;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class HadoopSegmentCreationMapper
extends Mapper<LongWritable, Text, LongWritable, Text> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HadoopSegmentCreationMapper.class);
    protected static final String PROGRESS_REPORTER_THREAD_NAME = "pinot-hadoop-progress-reporter";
    protected static final long PROGRESS_REPORTER_JOIN_WAIT_TIME_MS = 5000L;
    protected Configuration _jobConf;
    protected SegmentGenerationJobSpec _spec;
    private File _localTempDir;

    public void setup(Mapper.Context context) throws IOException {
        this._jobConf = context.getConfiguration();
        Yaml yaml = new Yaml();
        String segmentGenerationJobSpecStr = this._jobConf.get("segmentGenerationJobSpec");
        this._spec = yaml.loadAs(segmentGenerationJobSpecStr, SegmentGenerationJobSpec.class);
        LOGGER.info("Segment generation job spec : {}", (Object)segmentGenerationJobSpecStr);
        this._localTempDir = new File(FileUtils.getTempDirectory(), "pinot-" + UUID.randomUUID());
        File localPluginsTarFile = new File("pinot-plugins.tar.gz");
        if (localPluginsTarFile.exists()) {
            File pluginsDirFile = Files.createTempDirectory("pinot-plugins-dir", new FileAttribute[0]).toFile();
            try {
                TarGzCompressionUtils.untar((File)localPluginsTarFile, (File)pluginsDirFile);
            }
            catch (Exception e) {
                LOGGER.error("Failed to untar local Pinot plugins tarball file [{}]", (Object)localPluginsTarFile, (Object)e);
                throw new RuntimeException(e);
            }
            LOGGER.info("Trying to set System Property: {}={}", (Object)"plugins.dir", (Object)pluginsDirFile.getAbsolutePath());
            System.setProperty("plugins.dir", pluginsDirFile.getAbsolutePath());
            String pluginsIncludes = this._jobConf.get("plugins.include");
            if (pluginsIncludes != null) {
                LOGGER.info("Trying to set System Property: {}={}", (Object)"plugins.include", (Object)pluginsIncludes);
                System.setProperty("plugins.include", pluginsIncludes);
            }
            LOGGER.info("Pinot plugins System Properties are set at [{}], plugins includes [{}]", (Object)System.getProperty("plugins.dir"), (Object)System.getProperty("plugins.include"));
        } else {
            LOGGER.warn("Cannot find local Pinot plugins directory at [{}]", (Object)localPluginsTarFile.getAbsolutePath());
        }
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) {
        try {
            String segmentName;
            URI outputDirURI;
            String[] splits = StringUtils.split((String)value.toString(), (char)' ');
            Preconditions.checkState(splits.length == 2, "Illegal input value: {}", (Object)value);
            String path = splits[0];
            int idx = Integer.valueOf(splits[1]);
            LOGGER.info("Generating segment with input file: {}, sequence id: {}", (Object)path, (Object)idx);
            URI inputDirURI = new URI(this._spec.getInputDirURI());
            if (inputDirURI.getScheme() == null) {
                inputDirURI = new File(this._spec.getInputDirURI()).toURI();
            }
            if ((outputDirURI = new URI(this._spec.getOutputDirURI())).getScheme() == null) {
                outputDirURI = new File(this._spec.getOutputDirURI()).toURI();
            }
            PinotFS outputDirFS = PinotFSFactory.create((String)outputDirURI.getScheme());
            URI inputFileURI = URI.create(path);
            if (inputFileURI.getScheme() == null) {
                inputFileURI = new URI(inputDirURI.getScheme(), inputFileURI.getSchemeSpecificPart(), inputFileURI.getFragment());
            }
            File localInputTempDir = new File(this._localTempDir, "input");
            FileUtils.forceMkdir((File)localInputTempDir);
            File localOutputTempDir = new File(this._localTempDir, "output");
            FileUtils.forceMkdir((File)localOutputTempDir);
            File localInputDataFile = new File(localInputTempDir, SegmentGenerationUtils.getFileName((URI)inputFileURI));
            PinotFSFactory.create((String)inputFileURI.getScheme()).copyToLocalFile(inputFileURI, localInputDataFile);
            SegmentGenerationTaskSpec taskSpec = new SegmentGenerationTaskSpec();
            taskSpec.setInputFilePath(localInputDataFile.getAbsolutePath());
            taskSpec.setOutputDirectoryPath(localOutputTempDir.getAbsolutePath());
            taskSpec.setRecordReaderSpec(this._spec.getRecordReaderSpec());
            taskSpec.setSchema(SegmentGenerationUtils.getSchema((String)this._spec.getTableSpec().getSchemaURI(), (String)this._spec.getAuthToken()));
            taskSpec.setTableConfig(SegmentGenerationUtils.getTableConfig((String)this._spec.getTableSpec().getTableConfigURI(), (String)this._spec.getAuthToken()));
            taskSpec.setSequenceId(idx);
            taskSpec.setSegmentNameGeneratorSpec(this._spec.getSegmentNameGeneratorSpec());
            taskSpec.setFailOnEmptySegment(this._spec.isFailOnEmptySegment());
            taskSpec.setCustomProperty("input.data.file.uri", inputFileURI.toString());
            Thread progressReporterThread = new Thread(this.getProgressReporter(context));
            progressReporterThread.setName(PROGRESS_REPORTER_THREAD_NAME);
            progressReporterThread.start();
            try {
                SegmentGenerationTaskRunner taskRunner = new SegmentGenerationTaskRunner(taskSpec);
                segmentName = taskRunner.run();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while creating segment with input file: {}, sequence id: {}", path, idx, e);
                throw new RuntimeException(e);
            }
            finally {
                progressReporterThread.interrupt();
                progressReporterThread.join(5000L);
                if (progressReporterThread.isAlive()) {
                    LOGGER.error("Failed to interrupt progress reporter thread: {}", (Object)progressReporterThread);
                }
            }
            File localSegmentDir = new File(localOutputTempDir, segmentName);
            String segmentTarFileName = URLEncoder.encode(segmentName + ".tar.gz", "UTF-8");
            File localSegmentTarFile = new File(localOutputTempDir, segmentTarFileName);
            LOGGER.info("Tarring segment from: {} to: {}", (Object)localSegmentDir, (Object)localSegmentTarFile);
            TarGzCompressionUtils.createTarGzFile((File)localSegmentDir, (File)localSegmentTarFile);
            long uncompressedSegmentSize = FileUtils.sizeOf((File)localSegmentDir);
            long compressedSegmentSize = FileUtils.sizeOf((File)localSegmentTarFile);
            LOGGER.info("Size for segment: {}, uncompressed: {}, compressed: {}", segmentName, DataSizeUtils.fromBytes((long)uncompressedSegmentSize), DataSizeUtils.fromBytes((long)compressedSegmentSize));
            URI outputSegmentTarURI = SegmentGenerationUtils.getRelativeOutputPath((URI)inputDirURI, (URI)inputFileURI, (URI)outputDirURI).resolve(segmentTarFileName);
            LOGGER.info("Copying segment tar file from [{}] to [{}]", (Object)localSegmentTarFile, (Object)outputSegmentTarURI);
            outputDirFS.copyFromLocalFile(localSegmentTarFile, outputSegmentTarURI);
            FileUtils.deleteQuietly((File)localSegmentDir);
            FileUtils.deleteQuietly((File)localSegmentTarFile);
            FileUtils.deleteQuietly((File)localInputDataFile);
            context.write((Object)new LongWritable((long)idx), (Object)new Text(segmentTarFileName));
            LOGGER.info("Finish generating segment: {} with input file: {}, sequence id: {}", segmentName, inputFileURI, idx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)this._localTempDir);
        }
    }

    protected Runnable getProgressReporter(Mapper.Context context) {
        return new ProgressReporter(context);
    }

    public void cleanup(Mapper.Context context) {
        LOGGER.info("Deleting local temporary directory: {}", (Object)this._localTempDir);
        FileUtils.deleteQuietly((File)this._localTempDir);
    }

    private static class ProgressReporter
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProgressReporter.class);
        private static final long PROGRESS_REPORTER_INTERVAL_MS = 60000L;
        private final Mapper.Context _context;

        ProgressReporter(Mapper.Context context) {
            this._context = context;
        }

        @Override
        public void run() {
            LOGGER.info("Starting progress reporter thread: {}", (Object)Thread.currentThread());
            try {
                while (true) {
                    Thread.sleep(60000L);
                    LOGGER.info("============== Reporting progress ==============");
                    this._context.progress();
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Progress reporter thread: {} interrupted", (Object)Thread.currentThread());
                return;
            }
        }
    }
}

