/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.metrics.MetricsContext;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.DataTreeBean;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderBean;
import org.apache.zookeeper.server.quorum.LeaderRequestProcessor;
import org.apache.zookeeper.server.quorum.LeaderSessionTracker;
import org.apache.zookeeper.server.quorum.LearnerHandlerBean;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;

public class LeaderZooKeeperServer
extends QuorumZooKeeperServer {
    private ContainerManager containerManager;
    CommitProcessor commitProcessor;
    PrepRequestProcessor prepRequestProcessor;

    public LeaderZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, self.clientPortListenBacklog, zkDb, self);
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor(finalProcessor, this.getLeader());
        this.commitProcessor = new CommitProcessor(toBeAppliedProcessor, Long.toString(this.getServerId()), false, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        ProposalRequestProcessor proposalProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        proposalProcessor.initialize();
        this.prepRequestProcessor = new PrepRequestProcessor(this, proposalProcessor);
        this.prepRequestProcessor.start();
        this.firstProcessor = new LeaderRequestProcessor(this, this.prepRequestProcessor);
        this.setupContainerManager();
    }

    private synchronized void setupContainerManager() {
        this.containerManager = new ContainerManager(this.getZKDatabase(), this.prepRequestProcessor, Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)), Integer.getInteger("znode.container.maxPerMinute", 10000), Long.getLong("znode.container.maxNeverUsedIntervalMs", 0L));
    }

    @Override
    public synchronized void startup() {
        super.startup();
        if (this.containerManager != null) {
            this.containerManager.start();
        }
    }

    @Override
    protected void registerMetrics() {
        super.registerMetrics();
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.registerGauge("learners", () -> this.getLeader().getLearners().size());
        rootContext.registerGauge("synced_followers", () -> this.getLeader().getForwardingFollowers().size());
        rootContext.registerGauge("synced_non_voting_followers", () -> this.getLeader().getNonVotingFollowers().size());
        rootContext.registerGauge("synced_observers", this.self::getSynced_observers_metric);
        rootContext.registerGauge("pending_syncs", () -> this.getLeader().getNumPendingSyncs());
        rootContext.registerGauge("leader_uptime", () -> this.getLeader().getUptime());
        rootContext.registerGauge("last_proposal_size", () -> this.getLeader().getProposalStats().getLastBufferSize());
        rootContext.registerGauge("max_proposal_size", () -> this.getLeader().getProposalStats().getMaxBufferSize());
        rootContext.registerGauge("min_proposal_size", () -> this.getLeader().getProposalStats().getMinBufferSize());
    }

    @Override
    protected void unregisterMetrics() {
        super.unregisterMetrics();
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.unregisterGauge("learners");
        rootContext.unregisterGauge("synced_followers");
        rootContext.unregisterGauge("synced_non_voting_followers");
        rootContext.unregisterGauge("synced_observers");
        rootContext.unregisterGauge("pending_syncs");
        rootContext.unregisterGauge("leader_uptime");
        rootContext.unregisterGauge("last_proposal_size");
        rootContext.unregisterGauge("max_proposal_size");
        rootContext.unregisterGauge("min_proposal_size");
    }

    @Override
    public synchronized void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.stop();
        }
        super.shutdown();
    }

    @Override
    public int getGlobalOutstandingLimit() {
        int divisor = this.self.getQuorumSize() > 2 ? this.self.getQuorumSize() - 1 : 1;
        int globalOutstandingLimit = super.getGlobalOutstandingLimit() / divisor;
        return globalOutstandingLimit;
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LeaderSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    public boolean touch(long sess, int to) {
        return this.sessionTracker.touchSession(sess, to);
    }

    public boolean checkIfValidGlobalSession(long sess, int to) {
        if (this.self.areLocalSessionsEnabled() && !this.upgradeableSessionTracker.isGlobalSession(sess)) {
            return false;
        }
        return this.sessionTracker.touchSession(sess, to);
    }

    public void submitLearnerRequest(Request request) {
        this.prepRequestProcessor.processRequest(request);
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(LeaderBean leaderBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = leaderBean;
            MBeanRegistry.getInstance().register(leaderBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    boolean registerJMX(LearnerHandlerBean handlerBean) {
        try {
            MBeanRegistry.getInstance().register(handlerBean, this.jmxServerBean);
            return true;
        }
        catch (JMException e) {
            LOG.warn("Could not register connection", e);
            return false;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Leader leader) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "leader";
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        super.revalidateSession(cnxn, sessionId, sessionTimeout);
        try {
            this.setOwner(sessionId, ServerCnxn.me);
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
    }
}

