/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.snapshot;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Optional;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.SnapshotPath;

public final class Snapshots {
    private static final String SUFFIX = ".checkpoint";
    private static final String PARTIAL_SUFFIX = String.format("%s.part", ".checkpoint");
    private static final NumberFormat OFFSET_FORMATTER = NumberFormat.getInstance();
    private static final NumberFormat EPOCH_FORMATTER = NumberFormat.getInstance();
    private static final int OFFSET_WIDTH = 20;
    private static final int EPOCH_WIDTH = 10;

    static Path snapshotDir(Path logDir) {
        return logDir;
    }

    static Path snapshotPath(Path logDir, OffsetAndEpoch snapshotId) {
        return Snapshots.snapshotDir(logDir).resolve(Snapshots.filenameFromSnapshotId(snapshotId) + SUFFIX);
    }

    static String filenameFromSnapshotId(OffsetAndEpoch snapshotId) {
        return String.format("%s-%s", OFFSET_FORMATTER.format(snapshotId.offset), EPOCH_FORMATTER.format(snapshotId.epoch));
    }

    static Path moveRename(Path source, OffsetAndEpoch snapshotId) {
        return source.resolveSibling(Snapshots.filenameFromSnapshotId(snapshotId) + SUFFIX);
    }

    public static Path createTempFile(Path logDir, OffsetAndEpoch snapshotId) throws IOException {
        Path dir = Snapshots.snapshotDir(logDir);
        Files.createDirectories(dir, new FileAttribute[0]);
        String prefix = String.format("%s-", Snapshots.filenameFromSnapshotId(snapshotId));
        return Files.createTempFile(dir, prefix, PARTIAL_SUFFIX, new FileAttribute[0]);
    }

    public static Optional<SnapshotPath> parse(Path path) {
        boolean partial;
        Path filename = path.getFileName();
        if (filename == null) {
            return Optional.empty();
        }
        String name = filename.toString();
        if (name.endsWith(PARTIAL_SUFFIX)) {
            partial = true;
        } else if (name.endsWith(SUFFIX)) {
            partial = false;
        } else {
            return Optional.empty();
        }
        long endOffset = Long.parseLong(name.substring(0, 20));
        int epoch = Integer.parseInt(name.substring(21, 31));
        return Optional.of(new SnapshotPath(path, new OffsetAndEpoch(endOffset, epoch), partial));
    }

    static {
        OFFSET_FORMATTER.setMinimumIntegerDigits(20);
        OFFSET_FORMATTER.setGroupingUsed(false);
        EPOCH_FORMATTER.setMinimumIntegerDigits(10);
        EPOCH_FORMATTER.setGroupingUsed(false);
    }
}

