/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.snapshot;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.shaded.org.apache.kafka.common.memory.MemoryPool;
import org.apache.pinot.shaded.org.apache.kafka.common.record.CompressionType;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.RecordSerde;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotWriter;

public final class SnapshotWriter<T>
implements Closeable {
    private final RawSnapshotWriter snapshot;
    private final BatchAccumulator<T> accumulator;
    private final Time time;

    public SnapshotWriter(RawSnapshotWriter snapshot, int maxBatchSize, MemoryPool memoryPool, Time time, CompressionType compressionType, RecordSerde<T> serde) {
        this.snapshot = snapshot;
        this.time = time;
        this.accumulator = new BatchAccumulator<T>(snapshot.snapshotId().epoch, 0L, Integer.MAX_VALUE, maxBatchSize, memoryPool, time, compressionType, serde);
    }

    public OffsetAndEpoch snapshotId() {
        return this.snapshot.snapshotId();
    }

    public boolean isFrozen() {
        return this.snapshot.isFrozen();
    }

    public void append(List<T> records) throws IOException {
        if (this.snapshot.isFrozen()) {
            String message = String.format("Append not supported. Snapshot is already frozen: id = '%s'.", this.snapshot.snapshotId());
            throw new IllegalStateException(message);
        }
        this.accumulator.append(this.snapshot.snapshotId().epoch, records);
        if (this.accumulator.needsDrain(this.time.milliseconds())) {
            this.appendBatches(this.accumulator.drain());
        }
    }

    public void freeze() throws IOException {
        this.appendBatches(this.accumulator.drain());
        this.snapshot.freeze();
        this.accumulator.close();
    }

    @Override
    public void close() throws IOException {
        this.snapshot.close();
        this.accumulator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendBatches(List<BatchAccumulator.CompletedBatch<T>> batches) throws IOException {
        try {
            for (BatchAccumulator.CompletedBatch<BatchAccumulator.CompletedBatch> completedBatch : batches) {
                this.snapshot.append(completedBatch.data);
            }
        }
        finally {
            batches.forEach(BatchAccumulator.CompletedBatch::release);
        }
    }
}

