/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.snapshot;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.ReplicatedLog;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.Snapshots;

public final class FileRawSnapshotWriter
implements RawSnapshotWriter {
    private final Path tempSnapshotPath;
    private final FileChannel channel;
    private final OffsetAndEpoch snapshotId;
    private final Optional<ReplicatedLog> replicatedLog;
    private boolean frozen = false;

    private FileRawSnapshotWriter(Path tempSnapshotPath, FileChannel channel, OffsetAndEpoch snapshotId, Optional<ReplicatedLog> replicatedLog) {
        this.tempSnapshotPath = tempSnapshotPath;
        this.channel = channel;
        this.snapshotId = snapshotId;
        this.replicatedLog = replicatedLog;
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    @Override
    public long sizeInBytes() throws IOException {
        return this.channel.size();
    }

    @Override
    public void append(UnalignedMemoryRecords records) throws IOException {
        if (this.frozen) {
            throw new IllegalStateException(String.format("Append is not supported. Snapshot is already frozen: id = %s; temp path = %s", this.snapshotId, this.tempSnapshotPath));
        }
        Utils.writeFully(this.channel, records.buffer());
    }

    @Override
    public void append(MemoryRecords records) throws IOException {
        if (this.frozen) {
            throw new IllegalStateException(String.format("Append is not supported. Snapshot is already frozen: id = %s; temp path = %s", this.snapshotId, this.tempSnapshotPath));
        }
        Utils.writeFully(this.channel, records.buffer());
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void freeze() throws IOException {
        if (this.frozen) {
            throw new IllegalStateException(String.format("Freeze is not supported. Snapshot is already frozen: id = %s; temp path = %s", this.snapshotId, this.tempSnapshotPath));
        }
        this.channel.close();
        this.frozen = true;
        if (!this.tempSnapshotPath.toFile().setReadOnly()) {
            throw new IOException(String.format("Unable to set file (%s) as read-only", this.tempSnapshotPath));
        }
        Path destination = Snapshots.moveRename(this.tempSnapshotPath, this.snapshotId);
        Utils.atomicMoveWithFallback(this.tempSnapshotPath, destination);
        this.replicatedLog.ifPresent(log -> log.onSnapshotFrozen(this.snapshotId));
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            Files.deleteIfExists(this.tempSnapshotPath);
        }
    }

    public static FileRawSnapshotWriter create(Path logDir, OffsetAndEpoch snapshotId, Optional<ReplicatedLog> replicatedLog) throws IOException {
        Path path = Snapshots.createTempFile(logDir, snapshotId);
        return new FileRawSnapshotWriter(path, FileChannel.open(path, Utils.mkSet(StandardOpenOption.WRITE, StandardOpenOption.APPEND), new FileAttribute[0]), snapshotId, replicatedLog);
    }
}

