/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft.internals;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.OptionalLong;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.DataInputStreamReadable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.pinot.shaded.org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.pinot.shaded.org.apache.kafka.common.record.FileRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.pinot.shaded.org.apache.kafka.common.record.Records;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.BufferSupplier;
import org.apache.pinot.shaded.org.apache.kafka.raft.BatchReader;
import org.apache.pinot.shaded.org.apache.kafka.raft.RecordSerde;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.CloseListener;

public class RecordsBatchReader<T>
implements BatchReader<T> {
    private final long baseOffset;
    private final Records records;
    private final RecordSerde<T> serde;
    private final BufferSupplier bufferSupplier;
    private final CloseListener<BatchReader<T>> closeListener;
    private Iterator<MutableRecordBatch> batchIterator;
    private long lastReturnedOffset;
    private BatchReader.Batch<T> nextBatch;
    private boolean isClosed = false;
    private ByteBuffer allocatedBuffer = null;

    public RecordsBatchReader(long baseOffset, Records records, RecordSerde<T> serde, BufferSupplier bufferSupplier, CloseListener<BatchReader<T>> closeListener) {
        this.baseOffset = baseOffset;
        this.records = records;
        this.serde = serde;
        this.bufferSupplier = bufferSupplier;
        this.closeListener = closeListener;
        this.lastReturnedOffset = baseOffset;
    }

    private void materializeIterator() throws IOException {
        if (this.records instanceof MemoryRecords) {
            this.batchIterator = ((MemoryRecords)this.records).batchIterator();
        } else if (this.records instanceof FileRecords) {
            this.allocatedBuffer = this.bufferSupplier.get(this.records.sizeInBytes());
            ((FileRecords)this.records).readInto(this.allocatedBuffer, 0);
            MemoryRecords memRecords = MemoryRecords.readableRecords(this.allocatedBuffer);
            this.batchIterator = memRecords.batchIterator();
        } else {
            throw new IllegalStateException("Unexpected Records type " + this.records.getClass());
        }
    }

    private void findNextDataBatch() {
        if (this.batchIterator == null) {
            try {
                this.materializeIterator();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read records into memory", e);
            }
        }
        while (this.batchIterator.hasNext()) {
            MutableRecordBatch nextBatch = this.batchIterator.next();
            if (!(nextBatch instanceof DefaultRecordBatch)) {
                throw new IllegalStateException();
            }
            DefaultRecordBatch batch = (DefaultRecordBatch)nextBatch;
            if (!batch.isControlBatch()) {
                this.nextBatch = this.readBatch(batch);
                return;
            }
            this.lastReturnedOffset = batch.lastOffset();
        }
    }

    private BatchReader.Batch<T> readBatch(DefaultRecordBatch batch) {
        Integer numRecords = batch.countOrNull();
        if (numRecords == null) {
            throw new IllegalStateException();
        }
        ArrayList<T> records = new ArrayList<T>(numRecords);
        try (DataInputStreamReadable input = new DataInputStreamReadable(batch.recordInputStream(this.bufferSupplier));){
            for (int i = 0; i < numRecords; ++i) {
                T record = this.readRecord(input);
                records.add(record);
            }
            BatchReader.Batch batch2 = new BatchReader.Batch(batch.baseOffset(), batch.partitionLeaderEpoch(), records);
            return batch2;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        this.findNextDataBatch();
        return this.nextBatch != null;
    }

    @Override
    public BatchReader.Batch<T> next() {
        if (this.nextBatch != null) {
            BatchReader.Batch<T> res = this.nextBatch;
            this.nextBatch = null;
            this.lastReturnedOffset = res.lastOffset();
            return res;
        }
        this.findNextDataBatch();
        if (this.nextBatch == null) {
            throw new NoSuchElementException();
        }
        return this.next();
    }

    @Override
    public long baseOffset() {
        return this.baseOffset;
    }

    @Override
    public OptionalLong lastOffset() {
        if (this.isClosed) {
            return OptionalLong.of(this.lastReturnedOffset);
        }
        return OptionalLong.empty();
    }

    @Override
    public void close() {
        this.isClosed = true;
        if (this.allocatedBuffer != null) {
            this.bufferSupplier.release(this.allocatedBuffer);
        }
        this.closeListener.onClose(this);
    }

    public T readRecord(Readable input) {
        input.readVarint();
        input.readByte();
        long timestampDelta = input.readVarlong();
        if (timestampDelta != 0L) {
            throw new IllegalArgumentException();
        }
        input.readVarint();
        int keySize = input.readVarint();
        if (keySize != -1) {
            throw new IllegalArgumentException("Unexpected key size " + keySize);
        }
        int valueSize = input.readVarint();
        if (valueSize < 0) {
            throw new IllegalArgumentException();
        }
        T record = this.serde.read(input, valueSize);
        int numHeaders = input.readVarint();
        if (numHeaders != 0) {
            throw new IllegalArgumentException();
        }
        return record;
    }
}

