/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.record.Records;
import org.apache.pinot.shaded.org.apache.kafka.raft.Isolation;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogAppendInfo;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogFetchInfo;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotWriter;

public interface ReplicatedLog
extends Closeable {
    public LogAppendInfo appendAsLeader(Records var1, int var2);

    public LogAppendInfo appendAsFollower(Records var1);

    public LogFetchInfo read(long var1, Isolation var3);

    public int lastFetchedEpoch();

    default public ValidOffsetAndEpoch validateOffsetAndEpoch(long offset, int epoch) {
        if (this.startOffset() == 0L && offset == 0L) {
            return ValidOffsetAndEpoch.valid(new OffsetAndEpoch(0L, 0));
        }
        if (this.oldestSnapshotId().isPresent() && (offset < this.startOffset() || offset == this.startOffset() && epoch != this.oldestSnapshotId().get().epoch || epoch < this.oldestSnapshotId().get().epoch)) {
            OffsetAndEpoch latestSnapshotId = this.latestSnapshotId().orElseThrow(() -> new IllegalStateException(String.format("Log start offset (%s) is greater than zero but latest snapshot was not found", this.startOffset())));
            return ValidOffsetAndEpoch.snapshot(latestSnapshotId);
        }
        OffsetAndEpoch endOffsetAndEpoch = this.endOffsetForEpoch(epoch);
        if (endOffsetAndEpoch.epoch != epoch || endOffsetAndEpoch.offset < offset) {
            return ValidOffsetAndEpoch.diverging(endOffsetAndEpoch);
        }
        return ValidOffsetAndEpoch.valid(new OffsetAndEpoch(offset, epoch));
    }

    public OffsetAndEpoch endOffsetForEpoch(int var1);

    public LogOffsetMetadata endOffset();

    public LogOffsetMetadata highWatermark();

    public long startOffset();

    public void initializeLeaderEpoch(int var1);

    public void truncateTo(long var1);

    public boolean truncateToLatestSnapshot();

    public void updateHighWatermark(LogOffsetMetadata var1);

    public boolean deleteBeforeSnapshot(OffsetAndEpoch var1);

    public void flush();

    public long lastFlushedOffset();

    public TopicPartition topicPartition();

    default public long truncateToEndOffset(OffsetAndEpoch endOffset) {
        long truncationOffset;
        int leaderEpoch = endOffset.epoch;
        if (leaderEpoch == 0) {
            truncationOffset = Math.min(endOffset.offset, this.endOffset().offset);
        } else {
            OffsetAndEpoch localEndOffset = this.endOffsetForEpoch(leaderEpoch);
            truncationOffset = localEndOffset.epoch == leaderEpoch ? Math.min(localEndOffset.offset, endOffset.offset) : localEndOffset.offset;
        }
        this.truncateTo(truncationOffset);
        return truncationOffset;
    }

    public RawSnapshotWriter createSnapshot(OffsetAndEpoch var1) throws IOException;

    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch var1) throws IOException;

    public Optional<OffsetAndEpoch> latestSnapshotId();

    public Optional<OffsetAndEpoch> oldestSnapshotId();

    public void onSnapshotFrozen(OffsetAndEpoch var1);

    @Override
    default public void close() {
    }
}

