/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public interface BatchReader<T>
extends Iterator<Batch<T>>,
AutoCloseable {
    public long baseOffset();

    public OptionalLong lastOffset();

    @Override
    public void close();

    public static class Batch<T> {
        private final long baseOffset;
        private final int epoch;
        private final List<T> records;

        public Batch(long baseOffset, int epoch, List<T> records) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            this.records = records;
        }

        public long lastOffset() {
            return this.baseOffset + (long)this.records.size() - 1L;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public List<T> records() {
            return this.records;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return "Batch(baseOffset=" + this.baseOffset + ", epoch=" + this.epoch + ", records=" + this.records + ')';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Batch batch = (Batch)o;
            return this.baseOffset == batch.baseOffset && this.epoch == batch.epoch && Objects.equals(this.records, batch.records);
        }

        public int hashCode() {
            return Objects.hash(this.baseOffset, this.epoch, this.records);
        }
    }
}

