/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.metadata.VersionRange;

public class FeatureMap {
    private final Map<String, VersionRange> features;

    public FeatureMap(Map<String, VersionRange> features) {
        this.features = Collections.unmodifiableMap(new HashMap<String, VersionRange>(features));
    }

    public Optional<VersionRange> get(String name) {
        return Optional.ofNullable(this.features.get(name));
    }

    public Map<String, VersionRange> features() {
        return this.features;
    }

    public int hashCode() {
        return this.features.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeatureMap)) {
            return false;
        }
        FeatureMap other = (FeatureMap)o;
        return this.features.equals(other.features);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("{");
        bld.append(this.features.keySet().stream().sorted().map(k -> k + ": " + this.features.get(k)).collect(Collectors.joining(", ")));
        bld.append("}");
        return bld.toString();
    }
}

