/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.pinot.shaded.org.apache.kafka.common.Uuid;
import org.apache.pinot.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.pinot.shaded.org.apache.kafka.common.config.ConfigResource;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ApiException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.NotControllerException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnknownServerException;
import org.apache.pinot.shaded.org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.QuotaRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.TopicRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.pinot.shaded.org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import org.apache.pinot.shaded.org.apache.kafka.controller.ClientQuotaControlManager;
import org.apache.pinot.shaded.org.apache.kafka.controller.ClusterControlManager;
import org.apache.pinot.shaded.org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.pinot.shaded.org.apache.kafka.controller.Controller;
import org.apache.pinot.shaded.org.apache.kafka.controller.ControllerMetrics;
import org.apache.pinot.shaded.org.apache.kafka.controller.ControllerPurgatory;
import org.apache.pinot.shaded.org.apache.kafka.controller.ControllerResult;
import org.apache.pinot.shaded.org.apache.kafka.controller.ControllerResultAndOffset;
import org.apache.pinot.shaded.org.apache.kafka.controller.DeferredEvent;
import org.apache.pinot.shaded.org.apache.kafka.controller.FeatureControlManager;
import org.apache.pinot.shaded.org.apache.kafka.controller.ReplicaPlacementPolicy;
import org.apache.pinot.shaded.org.apache.kafka.controller.ReplicationControlManager;
import org.apache.pinot.shaded.org.apache.kafka.controller.ResultOrError;
import org.apache.pinot.shaded.org.apache.kafka.controller.SimpleReplicaPlacementPolicy;
import org.apache.pinot.shaded.org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.pinot.shaded.org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.pinot.shaded.org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.pinot.shaded.org.apache.kafka.metadata.FeatureMapAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.metadata.VersionRange;
import org.apache.pinot.shaded.org.apache.kafka.metalog.MetaLogLeader;
import org.apache.pinot.shaded.org.apache.kafka.metalog.MetaLogListener;
import org.apache.pinot.shaded.org.apache.kafka.metalog.MetaLogManager;
import org.apache.pinot.shaded.org.apache.kafka.queue.EventQueue;
import org.apache.pinot.shaded.org.apache.kafka.queue.KafkaEventQueue;
import org.apache.pinot.shaded.org.apache.kafka.timeline.SnapshotRegistry;
import org.slf4j.Logger;

public final class QuorumController
implements Controller {
    private static final String ACTIVE_CONTROLLER_EXCEPTION_TEXT_PREFIX = "The active controller appears to be node ";
    static final String MAYBE_FENCE_REPLICAS = "maybeFenceReplicas";
    private final Logger log;
    private final int nodeId;
    private final KafkaEventQueue queue;
    private final Time time;
    private final ControllerMetrics controllerMetrics;
    private final SnapshotRegistry snapshotRegistry;
    private final ControllerPurgatory purgatory;
    private final ConfigurationControlManager configurationControl;
    private final ClientQuotaControlManager clientQuotaControlManager;
    private final ClusterControlManager clusterControl;
    private final FeatureControlManager featureControl;
    private final ReplicationControlManager replicationControl;
    private final MetaLogManager logManager;
    private final QuorumMetaLogListener metaLogListener;
    private volatile long curClaimEpoch;
    private long lastCommittedOffset;
    private long writeOffset;

    private NotControllerException newNotControllerException() {
        int latestController = this.logManager.leader().nodeId();
        if (latestController < 0) {
            return new NotControllerException("No controller appears to be active.");
        }
        return new NotControllerException(ACTIVE_CONTROLLER_EXCEPTION_TEXT_PREFIX + latestController);
    }

    public static int exceptionToApparentController(NotControllerException e) {
        if (e.getMessage().startsWith(ACTIVE_CONTROLLER_EXCEPTION_TEXT_PREFIX)) {
            return Integer.parseInt(e.getMessage().substring(ACTIVE_CONTROLLER_EXCEPTION_TEXT_PREFIX.length()));
        }
        return -1;
    }

    private void handleEventEnd(String name, long startProcessingTimeNs) {
        long endProcessingTime = this.time.nanoseconds();
        long deltaNs = endProcessingTime - startProcessingTimeNs;
        this.log.debug("Processed {} in {} us", (Object)name, (Object)TimeUnit.MICROSECONDS.convert(deltaNs, TimeUnit.NANOSECONDS));
        this.controllerMetrics.updateEventQueueProcessingTime(TimeUnit.NANOSECONDS.toMillis(deltaNs));
    }

    private Throwable handleEventException(String name, Optional<Long> startProcessingTimeNs, Throwable exception) {
        if (!startProcessingTimeNs.isPresent()) {
            this.log.info("unable to start processing {} because of {}.", (Object)name, (Object)exception.getClass().getSimpleName());
            if (exception instanceof ApiException) {
                return exception;
            }
            return new UnknownServerException(exception);
        }
        long endProcessingTime = this.time.nanoseconds();
        long deltaNs = endProcessingTime - startProcessingTimeNs.get();
        long deltaUs = TimeUnit.MICROSECONDS.convert(deltaNs, TimeUnit.NANOSECONDS);
        if (exception instanceof ApiException) {
            this.log.info("{}: failed with {} in {} us", name, exception.getClass().getSimpleName(), deltaUs);
            return exception;
        }
        this.log.warn("{}: failed with unknown server exception {} at epoch {} in {} us.  Reverting to last committed offset {}.", this, exception.getClass().getSimpleName(), this.curClaimEpoch, deltaUs, this.lastCommittedOffset, exception);
        this.renounce();
        return new UnknownServerException(exception);
    }

    private void appendControlEvent(String name, Runnable handler) {
        ControlEvent event = new ControlEvent(name, handler);
        this.queue.append(event);
    }

    ReplicationControlManager replicationControl() {
        return this.replicationControl;
    }

    <T> CompletableFuture<T> appendReadEvent(String name, Supplier<T> handler) {
        ControllerReadEvent<T> event = new ControllerReadEvent<T>(name, handler);
        this.queue.append(event);
        return event.future();
    }

    private <T> CompletableFuture<T> appendWriteEvent(String name, long timeoutMs, ControllerWriteOperation<T> op) {
        ControllerWriteEvent<T> event = new ControllerWriteEvent<T>(name, op);
        this.queue.appendWithDeadline(this.time.nanoseconds() + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS), event);
        return event.future();
    }

    private <T> CompletableFuture<T> appendWriteEvent(String name, ControllerWriteOperation<T> op) {
        ControllerWriteEvent<T> event = new ControllerWriteEvent<T>(name, op);
        this.queue.append(event);
        return event.future();
    }

    private void renounce() {
        this.curClaimEpoch = -1L;
        this.controllerMetrics.setActive(false);
        this.purgatory.failAll(this.newNotControllerException());
        this.snapshotRegistry.revertToSnapshot(this.lastCommittedOffset);
        this.snapshotRegistry.deleteSnapshotsUpTo(this.lastCommittedOffset);
        this.writeOffset = -1L;
        this.clusterControl.deactivate();
        this.cancelMaybeFenceReplicas();
    }

    private <T> void scheduleDeferredWriteEvent(String name, long deadlineNs, ControllerWriteOperation<T> op) {
        ControllerWriteEvent<T> event = new ControllerWriteEvent<T>(name, op);
        this.queue.scheduleDeferred(name, new EventQueue.EarliestDeadlineFunction(deadlineNs), event);
        ((ControllerWriteEvent)event).future.exceptionally(e -> {
            if (e instanceof UnknownServerException && e.getCause() != null && e.getCause() instanceof RejectedExecutionException) {
                this.log.error("Cancelling deferred write event {} because the event queue is now closed.", (Object)name);
                return null;
            }
            if (e instanceof NotControllerException) {
                this.log.debug("Cancelling deferred write event {} because this controller is no longer active.", (Object)name);
                return null;
            }
            this.log.error("Unexpected exception while executing deferred write event {}. Rescheduling for a minute from now.", (Object)name, e);
            this.scheduleDeferredWriteEvent(name, deadlineNs + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES), op);
            return null;
        });
    }

    private void rescheduleMaybeFenceStaleBrokers() {
        long nextCheckTimeNs = this.clusterControl.heartbeatManager().nextCheckTimeNs();
        if (nextCheckTimeNs == Long.MAX_VALUE) {
            this.cancelMaybeFenceReplicas();
            return;
        }
        this.scheduleDeferredWriteEvent(MAYBE_FENCE_REPLICAS, nextCheckTimeNs, () -> {
            ControllerResult<Void> result = this.replicationControl.maybeFenceStaleBrokers();
            this.rescheduleMaybeFenceStaleBrokers();
            return result;
        });
    }

    private void cancelMaybeFenceReplicas() {
        this.queue.cancelDeferred(MAYBE_FENCE_REPLICAS);
    }

    private void replay(ApiMessage message, long offset) {
        try {
            MetadataRecordType type = MetadataRecordType.fromId(message.apiKey());
            switch (type) {
                case REGISTER_BROKER_RECORD: {
                    this.clusterControl.replay((RegisterBrokerRecord)message);
                    break;
                }
                case UNREGISTER_BROKER_RECORD: {
                    this.clusterControl.replay((UnregisterBrokerRecord)message);
                    break;
                }
                case TOPIC_RECORD: {
                    this.replicationControl.replay((TopicRecord)message);
                    break;
                }
                case PARTITION_RECORD: {
                    this.replicationControl.replay((PartitionRecord)message);
                    break;
                }
                case CONFIG_RECORD: {
                    this.configurationControl.replay((ConfigRecord)message);
                    break;
                }
                case PARTITION_CHANGE_RECORD: {
                    this.replicationControl.replay((PartitionChangeRecord)message);
                    break;
                }
                case FENCE_BROKER_RECORD: {
                    this.clusterControl.replay((FenceBrokerRecord)message);
                    break;
                }
                case UNFENCE_BROKER_RECORD: {
                    this.clusterControl.replay((UnfenceBrokerRecord)message);
                    break;
                }
                case REMOVE_TOPIC_RECORD: {
                    this.replicationControl.replay((RemoveTopicRecord)message);
                    break;
                }
                case FEATURE_LEVEL_RECORD: {
                    this.featureControl.replay((FeatureLevelRecord)message, offset);
                    break;
                }
                case QUOTA_RECORD: {
                    this.clientQuotaControlManager.replay((QuotaRecord)message);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled record type " + (Object)((Object)type));
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error replaying record {}", (Object)message.toString(), (Object)e);
        }
    }

    private QuorumController(LogContext logContext, int nodeId, KafkaEventQueue queue, Time time, Map<ConfigResource.Type, ConfigDef> configDefs, MetaLogManager logManager, Map<String, VersionRange> supportedFeatures, short defaultReplicationFactor, int defaultNumPartitions, ReplicaPlacementPolicy replicaPlacementPolicy, long sessionTimeoutNs, ControllerMetrics controllerMetrics) throws Exception {
        this.log = logContext.logger(QuorumController.class);
        this.nodeId = nodeId;
        this.queue = queue;
        this.time = time;
        this.controllerMetrics = controllerMetrics;
        this.snapshotRegistry = new SnapshotRegistry(logContext);
        this.snapshotRegistry.createSnapshot(-1L);
        this.purgatory = new ControllerPurgatory();
        this.configurationControl = new ConfigurationControlManager(logContext, this.snapshotRegistry, configDefs);
        this.clientQuotaControlManager = new ClientQuotaControlManager(this.snapshotRegistry);
        this.clusterControl = new ClusterControlManager(logContext, time, this.snapshotRegistry, sessionTimeoutNs, replicaPlacementPolicy);
        this.featureControl = new FeatureControlManager(supportedFeatures, this.snapshotRegistry);
        this.replicationControl = new ReplicationControlManager(this.snapshotRegistry, logContext, defaultReplicationFactor, defaultNumPartitions, this.configurationControl, this.clusterControl);
        this.logManager = logManager;
        this.metaLogListener = new QuorumMetaLogListener();
        this.curClaimEpoch = -1L;
        this.lastCommittedOffset = -1L;
        this.writeOffset = -1L;
        this.logManager.register(this.metaLogListener);
    }

    @Override
    public CompletableFuture<AlterIsrResponseData> alterIsr(AlterIsrRequestData request) {
        if (request.topics().isEmpty()) {
            return CompletableFuture.completedFuture(new AlterIsrResponseData());
        }
        return this.appendWriteEvent("alterIsr", () -> this.replicationControl.alterIsr(request));
    }

    @Override
    public CompletableFuture<CreateTopicsResponseData> createTopics(CreateTopicsRequestData request) {
        if (request.topics().isEmpty()) {
            return CompletableFuture.completedFuture(new CreateTopicsResponseData());
        }
        return this.appendWriteEvent("createTopics", () -> this.replicationControl.createTopics(request));
    }

    @Override
    public CompletableFuture<Void> unregisterBroker(int brokerId) {
        return this.appendWriteEvent("unregisterBroker", () -> this.replicationControl.unregisterBroker(brokerId));
    }

    @Override
    public CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(Collection<String> names) {
        if (names.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendReadEvent("findTopicIds", () -> this.replicationControl.findTopicIds(this.lastCommittedOffset, names));
    }

    @Override
    public CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(Collection<Uuid> ids) {
        if (ids.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendReadEvent("findTopicNames", () -> this.replicationControl.findTopicNames(this.lastCommittedOffset, ids));
    }

    @Override
    public CompletableFuture<Map<Uuid, ApiError>> deleteTopics(Collection<Uuid> ids) {
        if (ids.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("deleteTopics", () -> this.replicationControl.deleteTopics(ids));
    }

    @Override
    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(Map<ConfigResource, Collection<String>> resources) {
        return this.appendReadEvent("describeConfigs", () -> this.configurationControl.describeConfigs(this.lastCommittedOffset, resources));
    }

    @Override
    public CompletableFuture<ElectLeadersResponseData> electLeaders(ElectLeadersRequestData request) {
        return this.appendWriteEvent("electLeaders", request.timeoutMs(), () -> this.replicationControl.electLeaders(request));
    }

    @Override
    public CompletableFuture<FeatureMapAndEpoch> finalizedFeatures() {
        return this.appendReadEvent("getFinalizedFeatures", () -> this.featureControl.finalizedFeatures(this.lastCommittedOffset));
    }

    @Override
    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean validateOnly) {
        return this.appendWriteEvent("incrementalAlterConfigs", () -> {
            ControllerResult<Map<ConfigResource, ApiError>> result = this.configurationControl.incrementalAlterConfigs(configChanges);
            if (validateOnly) {
                return result.withoutRecords();
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> newConfigs, boolean validateOnly) {
        if (newConfigs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("legacyAlterConfigs", () -> {
            ControllerResult<Map<ConfigResource, ApiError>> result = this.configurationControl.legacyAlterConfigs(newConfigs);
            if (validateOnly) {
                return result.withoutRecords();
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(final BrokerHeartbeatRequestData request) {
        return this.appendWriteEvent("processBrokerHeartbeat", new ControllerWriteOperation<BrokerHeartbeatReply>(){
            private final int brokerId;
            private boolean inControlledShutdown;
            {
                this.brokerId = request.brokerId();
                this.inControlledShutdown = false;
            }

            @Override
            public ControllerResult<BrokerHeartbeatReply> generateRecordsAndResult() {
                ControllerResult<BrokerHeartbeatReply> result = QuorumController.this.replicationControl.processBrokerHeartbeat(request, QuorumController.this.lastCommittedOffset);
                this.inControlledShutdown = result.response().inControlledShutdown();
                QuorumController.this.rescheduleMaybeFenceStaleBrokers();
                return result;
            }

            @Override
            public void processBatchEndOffset(long offset) {
                if (this.inControlledShutdown) {
                    QuorumController.this.clusterControl.heartbeatManager().updateControlledShutdownOffset(this.brokerId, offset);
                }
            }
        });
    }

    @Override
    public CompletableFuture<BrokerRegistrationReply> registerBroker(BrokerRegistrationRequestData request) {
        return this.appendWriteEvent("registerBroker", () -> {
            ControllerResult<BrokerRegistrationReply> result = this.clusterControl.registerBroker(request, this.writeOffset + 1L, this.featureControl.finalizedFeatures(Long.MAX_VALUE));
            this.rescheduleMaybeFenceStaleBrokers();
            return result;
        });
    }

    @Override
    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> quotaAlterations, boolean validateOnly) {
        if (quotaAlterations.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("alterClientQuotas", () -> {
            ControllerResult<Map<ClientQuotaEntity, ApiError>> result = this.clientQuotaControlManager.alterClientQuotas(quotaAlterations);
            if (validateOnly) {
                return result.withoutRecords();
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> waitForReadyBrokers(int minBrokers) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.appendControlEvent("waitForReadyBrokers", () -> this.clusterControl.addReadyBrokersFuture(future, minBrokers));
        return future;
    }

    @Override
    public void beginShutdown() {
        this.queue.beginShutdown("QuorumController#beginShutdown");
    }

    public int nodeId() {
        return this.nodeId;
    }

    @Override
    public long curClaimEpoch() {
        return this.curClaimEpoch;
    }

    @Override
    public void close() throws InterruptedException {
        this.queue.close();
    }

    class QuorumMetaLogListener
    implements MetaLogListener {
        QuorumMetaLogListener() {
        }

        @Override
        public void handleCommits(long offset, List<ApiMessage> messages) {
            QuorumController.this.appendControlEvent("handleCommits[" + offset + "]", () -> {
                if (QuorumController.this.curClaimEpoch == -1L) {
                    if (QuorumController.this.log.isDebugEnabled()) {
                        if (QuorumController.this.log.isTraceEnabled()) {
                            QuorumController.this.log.trace("Replaying commits from the active node up to offset {}: {}.", (Object)offset, (Object)messages.stream().map(m -> m.toString()).collect(Collectors.joining(", ")));
                        } else {
                            QuorumController.this.log.debug("Replaying commits from the active node up to offset {}.", (Object)offset);
                        }
                    }
                    for (ApiMessage message : messages) {
                        QuorumController.this.replay(message, offset);
                    }
                } else {
                    QuorumController.this.log.debug("Completing purgatory items up to offset {}.", (Object)offset);
                    QuorumController.this.purgatory.completeUpTo(offset);
                    QuorumController.this.snapshotRegistry.deleteSnapshotsUpTo(offset);
                }
                QuorumController.this.lastCommittedOffset = offset;
            });
        }

        @Override
        public void handleNewLeader(MetaLogLeader newLeader) {
            if (newLeader.nodeId() == QuorumController.this.nodeId) {
                long newEpoch = newLeader.epoch();
                QuorumController.this.appendControlEvent("handleClaim[" + newEpoch + "]", () -> {
                    long curEpoch = QuorumController.this.curClaimEpoch;
                    if (curEpoch != -1L) {
                        throw new RuntimeException("Tried to claim controller epoch " + newEpoch + ", but we never renounced controller epoch " + curEpoch);
                    }
                    QuorumController.this.log.info("Becoming active at controller epoch {}.", (Object)newEpoch);
                    QuorumController.this.curClaimEpoch = newEpoch;
                    QuorumController.this.controllerMetrics.setActive(true);
                    QuorumController.this.writeOffset = QuorumController.this.lastCommittedOffset;
                    QuorumController.this.clusterControl.activate();
                });
            }
        }

        @Override
        public void handleRenounce(long oldEpoch) {
            QuorumController.this.appendControlEvent("handleRenounce[" + oldEpoch + "]", () -> {
                if (QuorumController.this.curClaimEpoch == oldEpoch) {
                    QuorumController.this.log.info("Renouncing the leadership at oldEpoch {} due to a metadata log event. Reverting to last committed offset {}.", (Object)QuorumController.this.curClaimEpoch, (Object)QuorumController.this.lastCommittedOffset);
                    QuorumController.this.renounce();
                }
            });
        }

        @Override
        public void beginShutdown() {
            QuorumController.this.queue.beginShutdown("MetaLogManager.Listener");
        }
    }

    class ControllerWriteEvent<T>
    implements EventQueue.Event,
    DeferredEvent {
        private final String name;
        private final CompletableFuture<T> future;
        private final ControllerWriteOperation<T> op;
        private final long eventCreatedTimeNs;
        private Optional<Long> startProcessingTimeNs;
        private ControllerResultAndOffset<T> resultAndOffset;

        ControllerWriteEvent(String name, ControllerWriteOperation<T> op) {
            this.eventCreatedTimeNs = QuorumController.this.time.nanoseconds();
            this.startProcessingTimeNs = Optional.empty();
            this.name = name;
            this.future = new CompletableFuture();
            this.op = op;
            this.resultAndOffset = null;
        }

        CompletableFuture<T> future() {
            return this.future;
        }

        @Override
        public void run() throws Exception {
            long now = QuorumController.this.time.nanoseconds();
            QuorumController.this.controllerMetrics.updateEventQueueTime(TimeUnit.NANOSECONDS.toMillis(now - this.eventCreatedTimeNs));
            long controllerEpoch = QuorumController.this.curClaimEpoch;
            if (controllerEpoch == -1L) {
                throw QuorumController.this.newNotControllerException();
            }
            this.startProcessingTimeNs = Optional.of(now);
            ControllerResult<T> result = this.op.generateRecordsAndResult();
            if (result.records().isEmpty()) {
                this.op.processBatchEndOffset(QuorumController.this.writeOffset);
                Optional<Long> maybeOffset = QuorumController.this.purgatory.highestPendingOffset();
                if (!maybeOffset.isPresent()) {
                    this.resultAndOffset = ControllerResultAndOffset.of(-1L, result);
                    QuorumController.this.log.debug("Completing read-only operation {} immediately because the purgatory is empty.", (Object)this);
                    this.complete(null);
                    return;
                }
                this.resultAndOffset = ControllerResultAndOffset.of(maybeOffset.get(), result);
                QuorumController.this.log.debug("Read-only operation {} will be completed when the log reaches offset {}", (Object)this, (Object)this.resultAndOffset.offset());
            } else {
                long offset = result.isAtomic() ? QuorumController.this.logManager.scheduleAtomicWrite(controllerEpoch, result.records()) : QuorumController.this.logManager.scheduleWrite(controllerEpoch, result.records());
                this.op.processBatchEndOffset(offset);
                QuorumController.this.writeOffset = offset;
                this.resultAndOffset = ControllerResultAndOffset.of(offset, result);
                for (ApiMessageAndVersion message : result.records()) {
                    QuorumController.this.replay(message.message(), offset);
                }
                QuorumController.this.snapshotRegistry.createSnapshot(offset);
                QuorumController.this.log.debug("Read-write operation {} will be completed when the log reaches offset {}.", (Object)this, (Object)this.resultAndOffset.offset());
            }
            QuorumController.this.purgatory.add(this.resultAndOffset.offset(), this);
        }

        @Override
        public void handleException(Throwable exception) {
            this.complete(exception);
        }

        @Override
        public void complete(Throwable exception) {
            if (exception == null) {
                QuorumController.this.handleEventEnd(this.toString(), this.startProcessingTimeNs.get());
                this.future.complete(this.resultAndOffset.response());
            } else {
                this.future.completeExceptionally(QuorumController.this.handleEventException(this.name, this.startProcessingTimeNs, exception));
            }
        }

        public String toString() {
            return this.name + "(" + System.identityHashCode(this) + ")";
        }
    }

    static interface ControllerWriteOperation<T> {
        public ControllerResult<T> generateRecordsAndResult() throws Exception;

        default public void processBatchEndOffset(long offset) {
        }
    }

    class ControllerReadEvent<T>
    implements EventQueue.Event {
        private final String name;
        private final CompletableFuture<T> future;
        private final Supplier<T> handler;
        private final long eventCreatedTimeNs;
        private Optional<Long> startProcessingTimeNs;

        ControllerReadEvent(String name, Supplier<T> handler) {
            this.eventCreatedTimeNs = QuorumController.this.time.nanoseconds();
            this.startProcessingTimeNs = Optional.empty();
            this.name = name;
            this.future = new CompletableFuture();
            this.handler = handler;
        }

        CompletableFuture<T> future() {
            return this.future;
        }

        @Override
        public void run() throws Exception {
            long now = QuorumController.this.time.nanoseconds();
            QuorumController.this.controllerMetrics.updateEventQueueTime(TimeUnit.NANOSECONDS.toMillis(now - this.eventCreatedTimeNs));
            this.startProcessingTimeNs = Optional.of(now);
            T value = this.handler.get();
            QuorumController.this.handleEventEnd(this.toString(), this.startProcessingTimeNs.get());
            this.future.complete(value);
        }

        @Override
        public void handleException(Throwable exception) {
            this.future.completeExceptionally(QuorumController.this.handleEventException(this.name, this.startProcessingTimeNs, exception));
        }

        public String toString() {
            return this.name + "(" + System.identityHashCode(this) + ")";
        }
    }

    class ControlEvent
    implements EventQueue.Event {
        private final String name;
        private final Runnable handler;
        private final long eventCreatedTimeNs;
        private Optional<Long> startProcessingTimeNs;

        ControlEvent(String name, Runnable handler) {
            this.eventCreatedTimeNs = QuorumController.this.time.nanoseconds();
            this.startProcessingTimeNs = Optional.empty();
            this.name = name;
            this.handler = handler;
        }

        @Override
        public void run() throws Exception {
            long now = QuorumController.this.time.nanoseconds();
            QuorumController.this.controllerMetrics.updateEventQueueTime(TimeUnit.NANOSECONDS.toMillis(now - this.eventCreatedTimeNs));
            this.startProcessingTimeNs = Optional.of(now);
            QuorumController.this.log.debug("Executing {}.", (Object)this);
            this.handler.run();
            QuorumController.this.handleEventEnd(this.toString(), this.startProcessingTimeNs.get());
        }

        @Override
        public void handleException(Throwable exception) {
            QuorumController.this.handleEventException(this.name, this.startProcessingTimeNs, exception);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final int nodeId;
        private Time time = Time.SYSTEM;
        private String threadNamePrefix = null;
        private LogContext logContext = null;
        private Map<ConfigResource.Type, ConfigDef> configDefs = Collections.emptyMap();
        private MetaLogManager logManager = null;
        private Map<String, VersionRange> supportedFeatures = Collections.emptyMap();
        private short defaultReplicationFactor = (short)3;
        private int defaultNumPartitions = 1;
        private ReplicaPlacementPolicy replicaPlacementPolicy = new SimpleReplicaPlacementPolicy(new Random());
        private long sessionTimeoutNs = TimeUnit.NANOSECONDS.convert(18L, TimeUnit.SECONDS);
        private ControllerMetrics controllerMetrics = null;

        public Builder(int nodeId) {
            this.nodeId = nodeId;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public Builder setConfigDefs(Map<ConfigResource.Type, ConfigDef> configDefs) {
            this.configDefs = configDefs;
            return this;
        }

        public Builder setLogManager(MetaLogManager logManager) {
            this.logManager = logManager;
            return this;
        }

        public Builder setSupportedFeatures(Map<String, VersionRange> supportedFeatures) {
            this.supportedFeatures = supportedFeatures;
            return this;
        }

        public Builder setDefaultReplicationFactor(short defaultReplicationFactor) {
            this.defaultReplicationFactor = defaultReplicationFactor;
            return this;
        }

        public Builder setDefaultNumPartitions(int defaultNumPartitions) {
            this.defaultNumPartitions = defaultNumPartitions;
            return this;
        }

        public Builder setReplicaPlacementPolicy(ReplicaPlacementPolicy replicaPlacementPolicy) {
            this.replicaPlacementPolicy = replicaPlacementPolicy;
            return this;
        }

        public Builder setSessionTimeoutNs(long sessionTimeoutNs) {
            this.sessionTimeoutNs = sessionTimeoutNs;
            return this;
        }

        public Builder setMetrics(ControllerMetrics controllerMetrics) {
            this.controllerMetrics = controllerMetrics;
            return this;
        }

        public QuorumController build() throws Exception {
            if (this.logManager == null) {
                throw new RuntimeException("You must set a metadata log manager.");
            }
            if (this.threadNamePrefix == null) {
                this.threadNamePrefix = String.format("Node%d_", this.nodeId);
            }
            if (this.logContext == null) {
                this.logContext = new LogContext(String.format("[Controller %d] ", this.nodeId));
            }
            if (this.controllerMetrics == null) {
                this.controllerMetrics = (ControllerMetrics)Class.forName("org.apache.pinot.shaded.org.apache.kafka.controller.MockControllerMetrics").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            KafkaEventQueue queue = null;
            try {
                queue = new KafkaEventQueue(this.time, this.logContext, this.threadNamePrefix);
                return new QuorumController(this.logContext, this.nodeId, queue, this.time, this.configDefs, this.logManager, this.supportedFeatures, this.defaultReplicationFactor, this.defaultNumPartitions, this.replicaPlacementPolicy, this.sessionTimeoutNs, this.controllerMetrics);
            }
            catch (Exception e) {
                Utils.closeQuietly(queue, "event queue");
                throw e;
            }
        }
    }
}

