/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;

public class ResponseHeader
implements AbstractRequestResponse {
    private final ResponseHeaderData data;
    private final short headerVersion;

    public ResponseHeader(int correlationId, short headerVersion) {
        this(new ResponseHeaderData().setCorrelationId(correlationId), headerVersion);
    }

    public ResponseHeader(ResponseHeaderData data, short headerVersion) {
        this.data = data;
        this.headerVersion = headerVersion;
    }

    public int size(ObjectSerializationCache serializationCache) {
        return this.data().size(serializationCache, this.headerVersion);
    }

    public int correlationId() {
        return this.data.correlationId();
    }

    public short headerVersion() {
        return this.headerVersion;
    }

    @Override
    public ResponseHeaderData data() {
        return this.data;
    }

    public void write(ByteBuffer buffer, ObjectSerializationCache serializationCache) {
        this.data.write(new ByteBufferAccessor(buffer), serializationCache, this.headerVersion);
    }

    public String toString() {
        return "ResponseHeader(correlationId=" + this.data.correlationId() + ", headerVersion=" + this.headerVersion + ")";
    }

    public static ResponseHeader parse(ByteBuffer buffer, short headerVersion) {
        return new ResponseHeader(new ResponseHeaderData(new ByteBufferAccessor(buffer), headerVersion), headerVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseHeader that = (ResponseHeader)o;
        return this.headerVersion == that.headerVersion && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.headerVersion);
    }
}

