/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.shaded.org.apache.kafka.common.Uuid;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ByteUtils;

public class TopicRecord
implements ApiMessage {
    String name;
    Uuid topicId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("topic_id", Type.UUID, "The unique ID of this topic."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public TopicRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public TopicRecord() {
        this.name = "";
        this.topicId = Uuid.ZERO_UUID;
    }

    @Override
    public short apiKey() {
        return 2;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field name was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field name had invalid length " + length);
        }
        this.name = _readable.readString(length);
        this.topicId = _readable.readUuid();
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue(this.name);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUuid(this.topicId);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'name' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.name, _stringBytes);
        _size.addBytes(_stringBytes.length + 2);
        _size.addBytes(16);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TopicRecord)) {
            return false;
        }
        TopicRecord other = (TopicRecord)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!this.topicId.equals(other.topicId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + this.topicId.hashCode();
        return hashCode;
    }

    @Override
    public TopicRecord duplicate() {
        TopicRecord _duplicate = new TopicRecord();
        _duplicate.name = this.name;
        _duplicate.topicId = this.topicId;
        return _duplicate;
    }

    public String toString() {
        return "TopicRecord(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", topicId=" + this.topicId.toString() + ")";
    }

    public String name() {
        return this.name;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public TopicRecord setName(String v) {
        this.name = v;
        return this;
    }

    public TopicRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }
}

