/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.clients.consumer.internals;

import org.apache.pinot.shaded.org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public final class Heartbeat {
    private final int maxPollIntervalMs;
    private final GroupRebalanceConfig rebalanceConfig;
    private final Time time;
    private final Timer heartbeatTimer;
    private final Timer sessionTimer;
    private final Timer pollTimer;
    private final Logger log;
    private volatile long lastHeartbeatSend = 0L;
    private volatile boolean heartbeatInFlight = false;

    public Heartbeat(GroupRebalanceConfig config, Time time) {
        if (config.heartbeatIntervalMs >= config.sessionTimeoutMs) {
            throw new IllegalArgumentException("Heartbeat must be set lower than the session timeout");
        }
        this.rebalanceConfig = config;
        this.time = time;
        this.heartbeatTimer = time.timer(config.heartbeatIntervalMs);
        this.sessionTimer = time.timer(config.sessionTimeoutMs);
        this.maxPollIntervalMs = config.rebalanceTimeoutMs;
        this.pollTimer = time.timer(this.maxPollIntervalMs);
        LogContext logContext = new LogContext("[Heartbeat groupID=" + config.groupId + "] ");
        this.log = logContext.logger(this.getClass());
    }

    private void update(long now) {
        this.heartbeatTimer.update(now);
        this.sessionTimer.update(now);
        this.pollTimer.update(now);
    }

    public void poll(long now) {
        this.update(now);
        this.pollTimer.reset(this.maxPollIntervalMs);
    }

    boolean hasInflight() {
        return this.heartbeatInFlight;
    }

    void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
        this.heartbeatInFlight = true;
        this.update(now);
        this.heartbeatTimer.reset(this.rebalanceConfig.heartbeatIntervalMs);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending heartbeat request with {}ms remaining on timer", (Object)this.heartbeatTimer.remainingMs());
        }
    }

    void failHeartbeat() {
        this.update(this.time.milliseconds());
        this.heartbeatInFlight = false;
        this.heartbeatTimer.reset(this.rebalanceConfig.retryBackoffMs);
        this.log.trace("Heartbeat failed, reset the timer to {}ms remaining", (Object)this.heartbeatTimer.remainingMs());
    }

    void receiveHeartbeat() {
        this.update(this.time.milliseconds());
        this.heartbeatInFlight = false;
        this.sessionTimer.reset(this.rebalanceConfig.sessionTimeoutMs);
    }

    boolean shouldHeartbeat(long now) {
        this.update(now);
        return this.heartbeatTimer.isExpired();
    }

    long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    long timeToNextHeartbeat(long now) {
        this.update(now);
        return this.heartbeatTimer.remainingMs();
    }

    boolean sessionTimeoutExpired(long now) {
        this.update(now);
        return this.sessionTimer.isExpired();
    }

    void resetTimeouts() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.rebalanceConfig.sessionTimeoutMs);
        this.pollTimer.reset(this.maxPollIntervalMs);
        this.heartbeatTimer.reset(this.rebalanceConfig.heartbeatIntervalMs);
    }

    void resetSessionTimeout() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.rebalanceConfig.sessionTimeoutMs);
    }

    boolean pollTimeoutExpired(long now) {
        this.update(now);
        return this.pollTimer.isExpired();
    }

    long lastPollTime() {
        return this.pollTimer.currentTimeMs();
    }
}

