/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.shaded.org.apache.kafka.common.ConsumerGroupState;

public class ConsumerGroupListing {
    private final String groupId;
    private final boolean isSimpleConsumerGroup;
    private final Optional<ConsumerGroupState> state;

    public ConsumerGroupListing(String groupId, boolean isSimpleConsumerGroup) {
        this(groupId, isSimpleConsumerGroup, Optional.empty());
    }

    public ConsumerGroupListing(String groupId, boolean isSimpleConsumerGroup, Optional<ConsumerGroupState> state) {
        this.groupId = groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.state = Objects.requireNonNull(state);
    }

    public String groupId() {
        return this.groupId;
    }

    public boolean isSimpleConsumerGroup() {
        return this.isSimpleConsumerGroup;
    }

    public Optional<ConsumerGroupState> state() {
        return this.state;
    }

    public String toString() {
        return "(groupId='" + this.groupId + '\'' + ", isSimpleConsumerGroup=" + this.isSimpleConsumerGroup + ", state=" + this.state + ')';
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.isSimpleConsumerGroup, this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumerGroupListing other = (ConsumerGroupListing)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.isSimpleConsumerGroup != other.isSimpleConsumerGroup) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }
}

