/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.pinot.plugin.stream.kafka.KafkaStreamConfigProperties;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConfigProperties;
import org.apache.pinot.spi.utils.EqualityUtils;

public class KafkaStreamLevelStreamConfig {
    private static final String DEFAULT_AUTO_COMMIT_ENABLE = "false";
    private static final Map<String, String> DEFAULT_PROPS = new HashMap<String, String>(){
        {
            this.put("auto.commit.enable", KafkaStreamLevelStreamConfig.DEFAULT_AUTO_COMMIT_ENABLE);
        }
    };
    private String _kafkaTopicName;
    private String _groupId;
    private String _bootstrapServers;
    private Map<String, String> _kafkaConsumerProperties;

    public KafkaStreamLevelStreamConfig(StreamConfig streamConfig, String tableName, String groupId) {
        Map streamConfigMap = streamConfig.getStreamConfigsMap();
        this._kafkaTopicName = streamConfig.getTopicName();
        String hlcBootstrapBrokerUrlKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.hlc.bootstrap.server");
        this._bootstrapServers = (String)streamConfigMap.get(hlcBootstrapBrokerUrlKey);
        Preconditions.checkNotNull((Object)this._bootstrapServers, (Object)("Must specify bootstrap broker connect string " + hlcBootstrapBrokerUrlKey + " in high level kafka consumer"));
        this._groupId = groupId;
        this._kafkaConsumerProperties = new HashMap<String, String>();
        String kafkaConsumerPropertyPrefix = KafkaStreamConfigProperties.constructStreamProperty("kafka.consumer.prop");
        for (String key : streamConfigMap.keySet()) {
            if (!key.startsWith(kafkaConsumerPropertyPrefix)) continue;
            this._kafkaConsumerProperties.put(StreamConfigProperties.getPropertySuffix((String)key, (String)kafkaConsumerPropertyPrefix), (String)streamConfigMap.get(key));
        }
    }

    public String getKafkaTopicName() {
        return this._kafkaTopicName;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public Properties getKafkaConsumerProperties() {
        Properties props = new Properties();
        for (String key : DEFAULT_PROPS.keySet()) {
            props.put(key, DEFAULT_PROPS.get(key));
        }
        for (String key : this._kafkaConsumerProperties.keySet()) {
            props.put(key, this._kafkaConsumerProperties.get(key));
        }
        props.put("group.id", this._groupId);
        props.put("bootstrap.servers", this._bootstrapServers);
        return props;
    }

    public String toString() {
        return "KafkaStreamLevelStreamConfig{_kafkaTopicName='" + this._kafkaTopicName + "', _groupId='" + this._groupId + "', _bootstrapServers='" + this._bootstrapServers + "', _kafkaConsumerProperties=" + this._kafkaConsumerProperties + "}";
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference((Object)this, (Object)o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)o)) {
            return false;
        }
        KafkaStreamLevelStreamConfig that = (KafkaStreamLevelStreamConfig)o;
        return EqualityUtils.isEqual((Object)this._kafkaTopicName, (Object)that._kafkaTopicName) && EqualityUtils.isEqual((Object)this._groupId, (Object)that._groupId) && EqualityUtils.isEqual((Object)this._bootstrapServers, (Object)that._bootstrapServers) && EqualityUtils.isEqual(this._kafkaConsumerProperties, that._kafkaConsumerProperties);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._kafkaTopicName);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._groupId);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._bootstrapServers);
        result = EqualityUtils.hashCodeOf((int)result, this._kafkaConsumerProperties);
        return result;
    }

    public String getBootstrapServers() {
        return this._bootstrapServers;
    }
}

