/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.pinot.plugin.stream.kafka20.KafkaStreamLevelStreamConfig;
import org.apache.pinot.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamLevelConsumerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaStreamLevelConsumerManager.class);
    private static final Long IN_USE = -1L;
    private static final long CONSUMER_SHUTDOWN_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final Map<ImmutableTriple<String, String, String>, KafkaConsumer> CONSUMER_FOR_CONFIG_KEY = new HashMap<ImmutableTriple<String, String, String>, KafkaConsumer>();
    private static final IdentityHashMap<KafkaConsumer, Long> CONSUMER_RELEASE_TIME = new IdentityHashMap();

    private KafkaStreamLevelConsumerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaConsumer acquireKafkaConsumerForConfig(KafkaStreamLevelStreamConfig kafkaStreamLevelStreamConfig) {
        ImmutableTriple configKey = new ImmutableTriple((Object)kafkaStreamLevelStreamConfig.getKafkaTopicName(), (Object)kafkaStreamLevelStreamConfig.getGroupId(), (Object)kafkaStreamLevelStreamConfig.getBootstrapServers());
        Class<KafkaStreamLevelConsumerManager> clazz = KafkaStreamLevelConsumerManager.class;
        synchronized (KafkaStreamLevelConsumerManager.class) {
            if (CONSUMER_FOR_CONFIG_KEY.containsKey(configKey)) {
                KafkaConsumer kafkaConsumer = CONSUMER_FOR_CONFIG_KEY.get(configKey);
                if (CONSUMER_RELEASE_TIME.get(kafkaConsumer).equals(IN_USE)) {
                    throw new RuntimeException("Consumer " + kafkaConsumer + " already in use!");
                }
                LOGGER.info("Reusing kafka consumer with id {}", (Object)kafkaConsumer);
                CONSUMER_RELEASE_TIME.put(kafkaConsumer, IN_USE);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return kafkaConsumer;
            }
            LOGGER.info("Creating new kafka consumer and iterator for topic {}", (Object)kafkaStreamLevelStreamConfig.getKafkaTopicName());
            Properties consumerProp = new Properties();
            consumerProp.putAll((Map<?, ?>)kafkaStreamLevelStreamConfig.getKafkaConsumerProperties());
            consumerProp.put("bootstrap.servers", kafkaStreamLevelStreamConfig.getBootstrapServers());
            consumerProp.put("key.deserializer", StringDeserializer.class.getName());
            consumerProp.put("value.deserializer", BytesDeserializer.class.getName());
            if (consumerProp.containsKey("auto.offset.reset") && consumerProp.getProperty("auto.offset.reset").equals("smallest")) {
                consumerProp.put("auto.offset.reset", "earliest");
            }
            KafkaConsumer consumer = new KafkaConsumer(consumerProp);
            consumer.subscribe(Collections.singletonList(kafkaStreamLevelStreamConfig.getKafkaTopicName()));
            CONSUMER_FOR_CONFIG_KEY.put((ImmutableTriple<String, String, String>)configKey, consumer);
            CONSUMER_RELEASE_TIME.put(consumer, IN_USE);
            LOGGER.info("Created consumer with id {} for topic {}", (Object)consumer, (Object)kafkaStreamLevelStreamConfig.getKafkaTopicName());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseKafkaConsumer(final KafkaConsumer kafkaConsumer) {
        Class<KafkaStreamLevelConsumerManager> clazz = KafkaStreamLevelConsumerManager.class;
        synchronized (KafkaStreamLevelConsumerManager.class) {
            final long releaseTime = System.currentTimeMillis() + CONSUMER_SHUTDOWN_DELAY_MILLIS;
            CONSUMER_RELEASE_TIME.put(kafkaConsumer, releaseTime);
            LOGGER.info("Marking consumer with id {} for release at {}", (Object)kafkaConsumer, (Object)releaseTime);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Uninterruptibles.sleepUninterruptibly((long)CONSUMER_SHUTDOWN_DELAY_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS);
                        Class<KafkaStreamLevelConsumerManager> clazz = KafkaStreamLevelConsumerManager.class;
                        synchronized (KafkaStreamLevelConsumerManager.class) {
                            LOGGER.info("Executing release check for consumer {} at {}, scheduled at {}", kafkaConsumer, System.currentTimeMillis(), releaseTime);
                            Iterator<Map.Entry<ImmutableTriple<String, String, String>, KafkaConsumer>> configIterator = CONSUMER_FOR_CONFIG_KEY.entrySet().iterator();
                            while (configIterator.hasNext()) {
                                Map.Entry<ImmutableTriple<String, String, String>, KafkaConsumer> entry = configIterator.next();
                                KafkaConsumer kafkaConsumer2 = entry.getValue();
                                Long releaseTime2 = CONSUMER_RELEASE_TIME.get(kafkaConsumer2);
                                if (!releaseTime2.equals(IN_USE) && releaseTime2 < System.currentTimeMillis()) {
                                    LOGGER.info("Releasing consumer {}", (Object)kafkaConsumer2);
                                    try {
                                        kafkaConsumer2.close();
                                    }
                                    catch (Exception e) {
                                        LOGGER.warn("Caught exception while shutting down Kafka consumer with id {}", (Object)kafkaConsumer2, (Object)e);
                                    }
                                    configIterator.remove();
                                    CONSUMER_RELEASE_TIME.remove(kafkaConsumer2);
                                    continue;
                                }
                                LOGGER.info("Not releasing consumer {}, it has been reacquired", (Object)kafkaConsumer2);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception in release of consumer {}", (Object)kafkaConsumer, (Object)e);
                    }
                    {
                        return;
                    }
                }
            }.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConsumers() {
        try {
            Class<KafkaStreamLevelConsumerManager> clazz = KafkaStreamLevelConsumerManager.class;
            synchronized (KafkaStreamLevelConsumerManager.class) {
                LOGGER.info("Trying to shutdown all the kafka consumers");
                Iterator<KafkaConsumer> consumerIterator = CONSUMER_FOR_CONFIG_KEY.values().iterator();
                while (consumerIterator.hasNext()) {
                    KafkaConsumer kafkaConsumer = consumerIterator.next();
                    LOGGER.info("Trying to shutdown consumer {}", (Object)kafkaConsumer);
                    try {
                        kafkaConsumer.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception while shutting down Kafka consumer with id {}", (Object)kafkaConsumer, (Object)e);
                    }
                    consumerIterator.remove();
                }
                CONSUMER_FOR_CONFIG_KEY.clear();
                CONSUMER_RELEASE_TIME.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception during shutting down all kafka consumers", e);
        }
        {
            return;
        }
    }
}

