/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.plugin.stream.kafka20.KafkaStreamLevelConsumerManager;
import org.apache.pinot.plugin.stream.kafka20.KafkaStreamLevelStreamConfig;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Bytes;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamDecoderProvider;
import org.apache.pinot.spi.stream.StreamLevelConsumer;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamLevelConsumer
implements StreamLevelConsumer {
    private final StreamMessageDecoder _messageDecoder;
    private final Logger _instanceLogger;
    private final StreamConfig _streamConfig;
    private final KafkaStreamLevelStreamConfig _kafkaStreamLevelStreamConfig;
    private KafkaConsumer<Bytes, Bytes> _consumer;
    private ConsumerRecords<Bytes, Bytes> _consumerRecords;
    private Iterator<ConsumerRecord<Bytes, Bytes>> _kafkaIterator;
    private Map<Integer, Long> _consumerOffsets = new HashMap<Integer, Long>();
    private long _lastLogTime = 0L;
    private long _lastCount = 0L;
    private long _currentCount = 0L;

    public KafkaStreamLevelConsumer(String clientId, String tableName, StreamConfig streamConfig, Set<String> sourceFields, String groupId) {
        this._streamConfig = streamConfig;
        this._kafkaStreamLevelStreamConfig = new KafkaStreamLevelStreamConfig(streamConfig, tableName, groupId);
        this._messageDecoder = StreamDecoderProvider.create((StreamConfig)streamConfig, sourceFields);
        this._instanceLogger = LoggerFactory.getLogger(KafkaStreamLevelConsumer.class.getName() + "_" + tableName + "_" + streamConfig.getTopicName());
        this._instanceLogger.info("KafkaStreamLevelConsumer: streamConfig : {}", (Object)this._streamConfig);
    }

    public void start() throws Exception {
        this._consumer = KafkaStreamLevelConsumerManager.acquireKafkaConsumerForConfig(this._kafkaStreamLevelStreamConfig);
    }

    private void updateKafkaIterator() {
        this._consumerRecords = this._consumer.poll(Duration.ofMillis(this._streamConfig.getFetchTimeoutMillis()));
        this._kafkaIterator = this._consumerRecords.iterator();
    }

    private void resetOffsets() {
        for (int partition : this._consumerOffsets.keySet()) {
            long offsetToSeek = this._consumerOffsets.get(partition);
            this._consumer.seek(new TopicPartition(this._streamConfig.getTopicName(), partition), offsetToSeek);
        }
    }

    public GenericRow next(GenericRow destination) {
        if (this._kafkaIterator == null || !this._kafkaIterator.hasNext()) {
            this.updateKafkaIterator();
        }
        if (this._kafkaIterator.hasNext()) {
            try {
                ConsumerRecord<Bytes, Bytes> record = this._kafkaIterator.next();
                this.updateOffsets(record.partition(), record.offset());
                destination = this._messageDecoder.decode((Object)record.value().get(), destination);
                ++this._currentCount;
                long now = System.currentTimeMillis();
                if (now - this._lastLogTime > 60000L || this._currentCount - this._lastCount >= 100000L) {
                    if (this._lastCount == 0L) {
                        this._instanceLogger.info("Consumed {} events from kafka stream {}", (Object)this._currentCount, (Object)this._streamConfig.getTopicName());
                    } else {
                        this._instanceLogger.info("Consumed {} events from kafka stream {} (rate:{}/s)", this._currentCount - this._lastCount, this._streamConfig.getTopicName(), Float.valueOf((float)(this._currentCount - this._lastCount) * 1000.0f / (float)(now - this._lastLogTime)));
                    }
                    this._lastCount = this._currentCount;
                    this._lastLogTime = now;
                }
                return destination;
            }
            catch (Exception e) {
                this._instanceLogger.warn("Caught exception while consuming events", e);
                throw e;
            }
        }
        return null;
    }

    private void updateOffsets(int partition, long offset) {
        this._consumerOffsets.put(partition, offset + 1L);
    }

    public void commit() {
        this._consumer.commitSync(this.getOffsetsMap());
        this.resetOffsets();
        this._consumerOffsets.clear();
    }

    private Map<TopicPartition, OffsetAndMetadata> getOffsetsMap() {
        HashMap<TopicPartition, OffsetAndMetadata> offsetsMap = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (Integer partition : this._consumerOffsets.keySet()) {
            offsetsMap.put(new TopicPartition(this._streamConfig.getTopicName(), partition), new OffsetAndMetadata(this._consumerOffsets.get(partition)));
        }
        return offsetsMap;
    }

    public void shutdown() throws Exception {
        if (this._consumer != null) {
            this.resetOffsets();
            KafkaStreamLevelConsumerManager.releaseKafkaConsumer(this._consumer);
            this._consumer = null;
        }
    }
}

