/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.stream.kafka.KafkaStreamConfigProperties;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConfigProperties;
import org.apache.pinot.spi.utils.EqualityUtils;

public class KafkaPartitionLevelStreamConfig {
    private final String _kafkaTopicName;
    private final String _bootstrapHosts;
    private final int _kafkaBufferSize;
    private final int _kafkaSocketTimeout;
    private final int _kafkaFetcherSizeBytes;
    private final int _kafkaFetcherMinBytes;
    private final String _kafkaIsolationLevel;
    private final boolean _populateMetadata;
    private final Map<String, String> _streamConfigMap;

    public KafkaPartitionLevelStreamConfig(StreamConfig streamConfig) {
        this._streamConfigMap = streamConfig.getStreamConfigsMap();
        this._kafkaTopicName = streamConfig.getTopicName();
        String llcBrokerListKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.broker.list");
        String llcBufferKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.buffer.size");
        String llcTimeoutKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.socket.timeout");
        String fetcherSizeKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.fetcher.size");
        String fetcherMinBytesKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.fetcher.minBytes");
        String isolationLevelKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.isolation.level");
        this._bootstrapHosts = this._streamConfigMap.get(llcBrokerListKey);
        this._kafkaBufferSize = this.getIntConfigWithDefault(this._streamConfigMap, llcBufferKey, 512000);
        this._kafkaSocketTimeout = this.getIntConfigWithDefault(this._streamConfigMap, llcTimeoutKey, 10000);
        this._kafkaFetcherSizeBytes = this.getIntConfigWithDefault(this._streamConfigMap, fetcherSizeKey, this._kafkaBufferSize);
        this._kafkaFetcherMinBytes = this.getIntConfigWithDefault(this._streamConfigMap, fetcherMinBytesKey, 100000);
        this._kafkaIsolationLevel = this._streamConfigMap.get(isolationLevelKey);
        if (this._kafkaIsolationLevel != null) {
            Preconditions.checkArgument((this._kafkaIsolationLevel.equals("read_committed") || this._kafkaIsolationLevel.equals("read_uncommitted") ? 1 : 0) != 0, (Object)String.format("Unrecognized Kafka isolation level: %s", this._kafkaIsolationLevel));
        }
        String populateRowMetadataProperty = StreamConfigProperties.constructStreamProperty((String)streamConfig.getType(), (String)"metadata.populate");
        this._populateMetadata = "true".equalsIgnoreCase((String)streamConfig.getStreamConfigsMap().get(populateRowMetadataProperty));
        Preconditions.checkNotNull((Object)this._bootstrapHosts, (Object)("Must specify kafka brokers list " + llcBrokerListKey + " in case of low level kafka consumer"));
    }

    public String getKafkaTopicName() {
        return this._kafkaTopicName;
    }

    public String getBootstrapHosts() {
        return this._bootstrapHosts;
    }

    public int getKafkaBufferSize() {
        return this._kafkaBufferSize;
    }

    public int getKafkaSocketTimeout() {
        return this._kafkaSocketTimeout;
    }

    public int getKafkaFetcherSizeBytes() {
        return this._kafkaFetcherSizeBytes;
    }

    public int getKafkaFetcherMinBytes() {
        return this._kafkaFetcherMinBytes;
    }

    public String getKafkaIsolationLevel() {
        return this._kafkaIsolationLevel;
    }

    public boolean isPopulateMetadata() {
        return this._populateMetadata;
    }

    private int getIntConfigWithDefault(Map<String, String> configMap, String key, int defaultValue) {
        String stringValue = configMap.get(key);
        try {
            if (StringUtils.isNotEmpty((CharSequence)stringValue)) {
                return Integer.parseInt(stringValue);
            }
            return defaultValue;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public String toString() {
        return "KafkaLowLevelStreamConfig{_kafkaTopicName='" + this._kafkaTopicName + "', _bootstrapHosts='" + this._bootstrapHosts + "', _kafkaBufferSize='" + this._kafkaBufferSize + "', _kafkaSocketTimeout='" + this._kafkaSocketTimeout + "', _kafkaFetcherSizeBytes='" + this._kafkaFetcherSizeBytes + "', _kafkaFetcherMinBytes='" + this._kafkaFetcherMinBytes + "', _populateMetadata='" + this._populateMetadata + "'}";
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference((Object)this, (Object)o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)o)) {
            return false;
        }
        KafkaPartitionLevelStreamConfig that = (KafkaPartitionLevelStreamConfig)o;
        return EqualityUtils.isEqual((Object)this._kafkaTopicName, (Object)that._kafkaTopicName) && EqualityUtils.isEqual((Object)this._bootstrapHosts, (Object)that._bootstrapHosts) && EqualityUtils.isEqual((int)this._kafkaBufferSize, (int)that._kafkaBufferSize) && EqualityUtils.isEqual((int)this._kafkaSocketTimeout, (int)that._kafkaSocketTimeout) && EqualityUtils.isEqual((int)this._kafkaFetcherSizeBytes, (int)that._kafkaFetcherSizeBytes) && EqualityUtils.isEqual((int)this._kafkaFetcherMinBytes, (int)that._kafkaFetcherMinBytes) && EqualityUtils.isEqual((Object)this._populateMetadata, (Object)that._populateMetadata);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._kafkaTopicName);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._bootstrapHosts);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._kafkaBufferSize);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._kafkaSocketTimeout);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._kafkaFetcherSizeBytes);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._kafkaFetcherMinBytes);
        result = EqualityUtils.hashCodeOf((int)result, (boolean)this._populateMetadata);
        return result;
    }
}

