/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.plugin.stream.kafka20.KafkaMessageBatch;
import org.apache.pinot.plugin.stream.kafka20.KafkaPartitionLevelConnectionHandler;
import org.apache.pinot.plugin.stream.kafka20.KafkaStreamMessage;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Bytes;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.PartitionLevelConsumer;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamMessage;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionLevelConsumer
extends KafkaPartitionLevelConnectionHandler
implements PartitionLevelConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionLevelConsumer.class);
    private long _lastFetchedOffset = -1L;

    public KafkaPartitionLevelConsumer(String clientId, StreamConfig streamConfig, int partition) {
        super(clientId, streamConfig, partition);
    }

    public MessageBatch<StreamMessage<byte[]>> fetchMessages(StreamPartitionMsgOffset startMsgOffset, StreamPartitionMsgOffset endMsgOffset, int timeoutMillis) {
        long startOffset = ((LongMsgOffset)startMsgOffset).getOffset();
        long endOffset = endMsgOffset == null ? Long.MAX_VALUE : ((LongMsgOffset)endMsgOffset).getOffset();
        return this.fetchMessages(startOffset, endOffset, timeoutMillis);
    }

    public synchronized MessageBatch<StreamMessage<byte[]>> fetchMessages(long startOffset, long endOffset, int timeoutMillis) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Polling partition: {}, startOffset: {}, endOffset: {} timeout: {}ms", this._topicPartition, startOffset, endOffset, timeoutMillis);
        }
        if (this._lastFetchedOffset < 0L || this._lastFetchedOffset != startOffset - 1L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Seeking to offset: {}", (Object)startOffset);
            }
            this._consumer.seek(this._topicPartition, startOffset);
        }
        ConsumerRecords consumerRecords = this._consumer.poll(Duration.ofMillis(timeoutMillis));
        List messageAndOffsets = consumerRecords.records(this._topicPartition);
        ArrayList<StreamMessage<byte[]>> filtered = new ArrayList<StreamMessage<byte[]>>(messageAndOffsets.size());
        long lastOffset = startOffset;
        for (ConsumerRecord messageAndOffset : messageAndOffsets) {
            long offset;
            this._lastFetchedOffset = offset = messageAndOffset.offset();
            if (offset >= startOffset && (endOffset > offset || endOffset < 0L)) {
                Bytes message = (Bytes)messageAndOffset.value();
                if (message != null) {
                    String key = (String)messageAndOffset.key();
                    byte[] keyBytes = key != null ? key.getBytes(StandardCharsets.UTF_8) : null;
                    StreamMessageMetadata rowMetadata = (StreamMessageMetadata)this._kafkaMetadataExtractor.extract(messageAndOffset);
                    filtered.add(new KafkaStreamMessage(keyBytes, message.get(), rowMetadata));
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Tombstone message at offset: {}", (Object)offset);
                }
                lastOffset = offset;
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Ignoring message at offset: {} (outside of offset range [{}, {}))", offset, startOffset, endOffset);
        }
        return new KafkaMessageBatch(messageAndOffsets.size(), lastOffset, filtered);
    }
}

