/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0004\b\u0001\u001dQA\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006[\u0001!\tA\f\u0005\u0007e\u0001\u0001\u000b\u0011B\u001a\t\rY\u0002\u0001\u0015!\u00038\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015A\u0007\u0001\"\u0001j\u00055!\u0016.\\3s)\u0006\u001c8\u000eT5ti*\u0011q\u0002E\u0001\u0006i&lWM\u001d\u0006\u0003#I\tQ!\u001e;jYNT\u0011aE\u0001\u0006W\u000647.Y\n\u0004\u0001Ui\u0002C\u0001\f\u001c\u001b\u00059\"B\u0001\r\u001a\u0003\u0011a\u0017M\\4\u000b\u0003i\tAA[1wC&\u0011Ad\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013AC2p]\u000e,(O]3oi*\u0011!%G\u0001\u0005kRLG.\u0003\u0002%?\t9A)\u001a7bs\u0016$\u0017a\u0003;bg.\u001cu.\u001e8uKJ\u001c\u0001\u0001\u0005\u0002)W5\t\u0011F\u0003\u0002+?\u00051\u0011\r^8nS\u000eL!\u0001L\u0015\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003\u0019a\u0014N\\5u}Q\u0011q&\r\t\u0003a\u0001i\u0011A\u0004\u0005\u0006K\t\u0001\raJ\u0001\u0005e>|G\u000f\u0005\u00021i%\u0011QG\u0004\u0002\u000f)&lWM\u001d+bg.,e\u000e\u001e:z\u0003))\u0007\u0010]5sCRLwN\u001c\t\u0003QaJ!!O\u0015\u0003\u0015\u0005#x.\\5d\u0019>tw-A\u0007tKR,\u0005\u0010]5sCRLwN\u001c\u000b\u0003y\t\u0003\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012qAQ8pY\u0016\fg\u000eC\u0003D\u000b\u0001\u0007A)\u0001\u0007fqBL'/\u0019;j_:l5\u000f\u0005\u0002>\u000b&\u0011aI\u0010\u0002\u0005\u0019>tw-A\u0007hKR,\u0005\u0010]5sCRLwN\\\u000b\u0002\t\u00069am\u001c:fC\u000eDGCA&O!\tiD*\u0003\u0002N}\t!QK\\5u\u0011\u0015yu\u00011\u0001Q\u0003\u00051\u0007\u0003B\u001fR'.K!A\u0015 \u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0019U\u0013\t)fBA\u0005US6,'\u000fV1tW\u0006\u0019\u0011\r\u001a3\u0015\u0005-C\u0006\"B-\t\u0001\u0004\u0019\u0014A\u0004;j[\u0016\u0014H+Y:l\u000b:$(/_\u0001\u0007e\u0016lwN^3\u0015\u0005-c\u0006\"B-\n\u0001\u0004\u0019\u0014!\u00024mkNDGCA&`\u0011\u0015y%\u00021\u0001a!\u0011i\u0014kM&\u0002\u0011\u001d,G\u000fR3mCf$\"\u0001R2\t\u000b\u0011\\\u0001\u0019A3\u0002\tUt\u0017\u000e\u001e\t\u0003=\u0019L!aZ\u0010\u0003\u0011QKW.Z+oSR\f\u0011bY8na\u0006\u0014X\rV8\u0015\u0005)l\u0007CA\u001fl\u0013\tagHA\u0002J]RDQA\u001c\u0007A\u0002u\t\u0011\u0001\u001a\u0015\u0003\u0001A\u0004\"!\u001d:\u000e\u0003AI!a\u001d\t\u0003\u0015QD'/Z1eg\u00064W\r")
public class TimerTaskList
implements Delayed {
    private final AtomicInteger taskCounter;
    private final TimerTaskEntry root;
    private final AtomicLong expiration;

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    public synchronized void foreach(Function1<TimerTask, BoxedUnit> f) {
        TimerTaskEntry entry = this.root.next();
        while (entry != this.root) {
            TimerTaskEntry nextEntry = entry.next();
            if (!entry.cancelled()) {
                f.apply(entry.timerTask());
            }
            entry = nextEntry;
        }
    }

    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            synchronized (this) {
                synchronized (timerTaskEntry) {
                    if (timerTaskEntry.list() == null) {
                        TimerTaskEntry tail = this.root.prev();
                        timerTaskEntry.next_$eq(this.root);
                        timerTaskEntry.prev_$eq(tail);
                        timerTaskEntry.list_$eq(this);
                        tail.next_$eq(timerTaskEntry);
                        this.root.prev_$eq(timerTaskEntry);
                        this.taskCounter.incrementAndGet();
                        done = true;
                    }
                }
            }
        }
    }

    public void remove(TimerTaskEntry timerTaskEntry) {
        synchronized (this) {
            synchronized (timerTaskEntry) {
                if (timerTaskEntry.list() == this) {
                    timerTaskEntry.next().prev_$eq(timerTaskEntry.prev());
                    timerTaskEntry.prev().next_$eq(timerTaskEntry.next());
                    timerTaskEntry.next_$eq(null);
                    timerTaskEntry.prev_$eq(null);
                    timerTaskEntry.list_$eq(null);
                    this.taskCounter.decrementAndGet();
                }
            }
            return;
        }
    }

    public synchronized void flush(Function1<TimerTaskEntry, BoxedUnit> f) {
        TimerTaskEntry head = this.root.next();
        while (head != this.root) {
            this.remove(head);
            f.apply(head);
            head = this.root.next();
        }
        this.expiration.set(-1L);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(package$.MODULE$.max(this.getExpiration() - Time.SYSTEM.hiResClockMs(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        TimerTaskList other = (TimerTaskList)d;
        return Long.compare(this.getExpiration(), other.getExpiration());
    }

    public TimerTaskList(AtomicInteger taskCounter) {
        this.taskCounter = taskCounter;
        this.root = new TimerTaskEntry(null, -1L);
        this.root.next_$eq(this.root);
        this.root.prev_$eq(this.root);
        this.expiration = new AtomicLong(-1L);
    }
}

