/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ConsumerPerformance;
import kafka.utils.ToolsUtils$;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.pinot.shaded.org.apache.kafka.common.Metric;
import org.apache.pinot.shaded.org.apache.kafka.common.MetricName;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.collection.Iterable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;

public final class ConsumerPerformance$
implements LazyLogging {
    public static ConsumerPerformance$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void main(String[] args) {
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting consumer...");
        }
        AtomicLong totalMessagesRead = new AtomicLong(0L);
        AtomicLong totalBytesRead = new AtomicLong(0L);
        Map<MetricName, Metric> metrics = null;
        AtomicLong joinGroupTimeInMs = new AtomicLong(0L);
        if (!config.hideHeader()) {
            this.printHeader(config.showDetailedStats());
        }
        KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config.props());
        long startMs = System.currentTimeMillis();
        this.consume(consumer, new $colon$colon<Nothing$>((Nothing$)((Object)config.topic()), Nil$.MODULE$), config.numMessages(), config.recordFetchTimeoutMs(), config, totalMessagesRead, totalBytesRead, joinGroupTimeInMs, startMs);
        long endMs = System.currentTimeMillis();
        if (config.printMetrics()) {
            metrics = CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.metrics()).asScala();
        }
        consumer.close();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        long fetchTimeInMs = endMs - startMs - joinGroupTimeInMs.get();
        if (!config.showDetailedStats()) {
            double totalMBRead = (double)totalBytesRead.get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %s, %.4f, %.4f, %d, %.4f, %d, %d, %.4f, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong(startMs)), config.dateFormat().format(BoxesRunTime.boxToLong(endMs)), BoxesRunTime.boxToDouble(totalMBRead), BoxesRunTime.boxToDouble(totalMBRead / elapsedSecs), BoxesRunTime.boxToLong(totalMessagesRead.get()), BoxesRunTime.boxToDouble((double)totalMessagesRead.get() / elapsedSecs), BoxesRunTime.boxToLong(joinGroupTimeInMs.get()), BoxesRunTime.boxToLong(fetchTimeInMs), BoxesRunTime.boxToDouble(totalMBRead / ((double)fetchTimeInMs / 1000.0)), BoxesRunTime.boxToDouble((double)totalMessagesRead.get() / ((double)fetchTimeInMs / 1000.0))})));
        }
        if (metrics != null) {
            ToolsUtils$.MODULE$.printMetrics(metrics);
        }
    }

    public void printHeader(boolean showDetailedStats) {
        String newFieldsInHeader = ", rebalance.time.ms, fetch.time.ms, fetch.MB.sec, fetch.nMsg.sec";
        if (!showDetailedStats) {
            Predef$.MODULE$.println(new StringBuilder(82).append("start.time, end.time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append(newFieldsInHeader).toString());
            return;
        }
        Predef$.MODULE$.println(new StringBuilder(76).append("time, threadId, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append(newFieldsInHeader).toString());
    }

    public void consume(KafkaConsumer<byte[], byte[]> consumer, List<String> topics, long count, long timeout, ConsumerPerformance.ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicLong joinTime, long testStartTime) {
        LongRef bytesRead = LongRef.create(0L);
        LongRef messagesRead = LongRef.create(0L);
        LongRef lastBytesRead = LongRef.create(0L);
        LongRef lastMessagesRead = LongRef.create(0L);
        LongRef joinStart = LongRef.create(System.currentTimeMillis());
        LongRef joinTimeMsInSingleRound = LongRef.create(0L);
        consumer.subscribe((Collection<String>)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), new ConsumerRebalanceListener(joinTime, joinStart, joinTimeMsInSingleRound){
            private final AtomicLong joinTime$1;
            private final LongRef joinStart$1;
            private final LongRef joinTimeMsInSingleRound$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                ConsumerRebalanceListener.super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.joinTime$1.addAndGet(System.currentTimeMillis() - this.joinStart$1.elem);
                this.joinTimeMsInSingleRound$1.elem += System.currentTimeMillis() - this.joinStart$1.elem;
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                this.joinStart$1.elem = System.currentTimeMillis();
            }
            {
                this.joinTime$1 = joinTime$1;
                this.joinStart$1 = joinStart$1;
                this.joinTimeMsInSingleRound$1 = joinTimeMsInSingleRound$1;
            }
        });
        LongRef currentTimeMillis = LongRef.create(System.currentTimeMillis());
        LongRef lastReportTime = LongRef.create(currentTimeMillis.elem);
        long lastConsumedTime = currentTimeMillis.elem;
        while (messagesRead.elem < count && currentTimeMillis.elem - lastConsumedTime <= timeout) {
            Iterable records = CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(consumer.poll(Duration.ofMillis(100L))).asScala();
            currentTimeMillis.elem = System.currentTimeMillis();
            if (records.nonEmpty()) {
                lastConsumedTime = currentTimeMillis.elem;
            }
            records.foreach((Function1<ConsumerRecord, Object> & Serializable & scala.Serializable)record -> {
                ConsumerPerformance$.$anonfun$consume$1(messagesRead, bytesRead, currentTimeMillis, lastReportTime, config, lastBytesRead, lastMessagesRead, joinTimeMsInSingleRound, record);
                return BoxedUnit.UNIT;
            });
        }
        if (messagesRead.elem < count) {
            Predef$.MODULE$.println(new StringBuilder(148).append("WARNING: Exiting before consuming the expected number of messages: timeout (").append(timeout).append(" ms) exceeded. ").append("You can use the --timeout option to increase the timeout.").toString());
        }
        totalMessagesRead.set(messagesRead.elem);
        totalBytesRead.set(bytesRead.elem);
    }

    public void printConsumerProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat, long periodicJoinTimeInMs) {
        this.printBasicProgress(id, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, dateFormat);
        this.printExtendedProgress(bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, periodicJoinTimeInMs);
        Predef$.MODULE$.println();
    }

    private void printBasicProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double elapsedMs = endMs - startMs;
        double totalMbRead = (double)bytesRead * 1.0 / (double)0x100000;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        double intervalMbPerSec = 1000.0 * intervalMbRead / elapsedMs;
        double intervalMessagesPerSec = (double)(messagesRead - lastMessagesRead) / elapsedMs * 1000.0;
        Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{dateFormat.format(BoxesRunTime.boxToLong(endMs)), BoxesRunTime.boxToInteger(id), BoxesRunTime.boxToDouble(totalMbRead), BoxesRunTime.boxToDouble(intervalMbPerSec), BoxesRunTime.boxToLong(messagesRead), BoxesRunTime.boxToDouble(intervalMessagesPerSec)})));
    }

    /*
     * WARNING - void declaration
     */
    private void printExtendedProgress(long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, long periodicJoinTimeInMs) {
        void var24_13;
        void var22_12;
        long fetchTimeMs = endMs - startMs - periodicJoinTimeInMs;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        long intervalMessagesRead = messagesRead - lastMessagesRead;
        Tuple2$mcDD$sp tuple2$mcDD$sp = fetchTimeMs <= 0L ? new Tuple2$mcDD$sp(0.0, 0.0) : new Tuple2$mcDD$sp(1000.0 * intervalMbRead / (double)fetchTimeMs, 1000.0 * (double)intervalMessagesRead / (double)fetchTimeMs);
        double intervalMbPerSec = ((Tuple2)tuple2$mcDD$sp)._1$mcD$sp();
        double intervalMessagesPerSec = ((Tuple2)tuple2$mcDD$sp)._2$mcD$sp();
        Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString(", %d, %d, %.4f, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(periodicJoinTimeInMs), BoxesRunTime.boxToLong(fetchTimeMs), BoxesRunTime.boxToDouble((double)var22_12), BoxesRunTime.boxToDouble((double)var24_13)})));
    }

    public static final /* synthetic */ void $anonfun$consume$1(LongRef messagesRead$1, LongRef bytesRead$1, LongRef currentTimeMillis$1, LongRef lastReportTime$1, ConsumerPerformance.ConsumerPerfConfig config$1, LongRef lastBytesRead$1, LongRef lastMessagesRead$1, LongRef joinTimeMsInSingleRound$1, ConsumerRecord record) {
        ++messagesRead$1.elem;
        if (record.key() != null) {
            bytesRead$1.elem += (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])record.key())).size();
        }
        if (record.value() != null) {
            bytesRead$1.elem += (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])record.value())).size();
        }
        if (currentTimeMillis$1.elem - lastReportTime$1.elem >= (long)config$1.reportingInterval()) {
            if (config$1.showDetailedStats()) {
                MODULE$.printConsumerProgress(0, bytesRead$1.elem, lastBytesRead$1.elem, messagesRead$1.elem, lastMessagesRead$1.elem, lastReportTime$1.elem, currentTimeMillis$1.elem, config$1.dateFormat(), joinTimeMsInSingleRound$1.elem);
            }
            joinTimeMsInSingleRound$1.elem = 0L;
            lastReportTime$1.elem = currentTimeMillis$1.elem;
            lastMessagesRead$1.elem = messagesRead$1.elem;
            lastBytesRead$1.elem = bytesRead$1.elem;
        }
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
    }
}

