/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.CheckpointReadBuffer;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\t\u0012\u0001aA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\ta\u0001\u0011\t\u0011)A\u0005Q!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bY\u0003A\u0011A,\t\u000fy\u0003!\u0019!C\u0005?\"1q\r\u0001Q\u0001\n\u0001Dq\u0001\u001b\u0001C\u0002\u0013%q\f\u0003\u0004j\u0001\u0001\u0006I\u0001\u0019\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019\u0011\b\u0001)A\u0005Y\")1\u000f\u0001C\u0001i\"9\u0011q\u0001\u0001\u0005\u0002\u0005%!AD\"iK\u000e\\\u0007o\\5oi\u001aKG.\u001a\u0006\u0003%M\t1b\u00195fG.\u0004x.\u001b8ug*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001!\u0006\u0002\u001ayM\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\tC%D\u0001#\u0015\t\u0019S#A\u0003vi&d7/\u0003\u0002&E\t9Aj\\4hS:<\u0017\u0001\u00024jY\u0016,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n!![8\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0005\r&dW-A\u0003gS2,\u0007%A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005m\u0019\u0014B\u0001\u001b\u001d\u0005\rIe\u000e^\u0001\nM>\u0014X.\u0019;uKJ\u00042a\u000e\u001d;\u001b\u0005\t\u0012BA\u001d\u0012\u0005]\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u00164uN]7biR,'\u000f\u0005\u0002<y1\u0001A!B\u001f\u0001\u0005\u0004q$!\u0001+\u0012\u0005}\u0012\u0005CA\u000eA\u0013\t\tEDA\u0004O_RD\u0017N\\4\u0011\u0005m\u0019\u0015B\u0001#\u001d\u0005\r\te._\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\u0005\u001dCU\"A\n\n\u0005%\u001b\"\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0001\u0004m_\u001e$\u0015N\u001d\t\u0003\u0019Ns!!T)\u0011\u00059cR\"A(\u000b\u0005A;\u0012A\u0002\u001fs_>$h(\u0003\u0002S9\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011F$\u0001\u0004=S:LGO\u0010\u000b\u00071fS6\fX/\u0011\u0007]\u0002!\bC\u0003'\u000f\u0001\u0007\u0001\u0006C\u00032\u000f\u0001\u0007!\u0007C\u00036\u000f\u0001\u0007a\u0007C\u0003F\u000f\u0001\u0007a\tC\u0003K\u000f\u0001\u00071*\u0001\u0003qCRDW#\u00011\u0011\u0005\u0005,W\"\u00012\u000b\u0005\u0019\u001a'B\u00013-\u0003\rq\u0017n\\\u0005\u0003M\n\u0014A\u0001U1uQ\u0006)\u0001/\u0019;iA\u0005AA/Z7q!\u0006$\b.A\u0005uK6\u0004\b+\u0019;iA\u0005!An\\2l+\u0005a\u0007CA7q\u001b\u0005q'BA8-\u0003\u0011a\u0017M\\4\n\u0005Et'AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\u0003xe&$X\r\u0006\u0002vqB\u00111D^\u0005\u0003or\u0011A!\u00168ji\")\u0011P\u0004a\u0001u\u00069QM\u001c;sS\u0016\u001c\b\u0003B>\u0002\u0002ir!\u0001 @\u000f\u00059k\u0018\"A\u000f\n\u0005}d\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\t)A\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tyH$\u0001\u0003sK\u0006$GCAA\u0006!\u0015\ti!a\u0005;\u001b\t\tyAC\u0002\u0002\u0012q\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)\"a\u0004\u0003\u0007M+\u0017\u000f")
public class CheckpointFile<T>
implements Logging {
    private final File file;
    private final int version;
    private final CheckpointFileFormatter<T> formatter;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Iterable<T> entries) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(entries);
            return;
        }
    }

    public Seq<T> read() {
        Object object = this.lock();
        synchronized (object) {
            Seq seq = this.liftedTree2$1();
            return seq;
        }
    }

    public static final /* synthetic */ void $anonfun$write$1(CheckpointFile $this, BufferedWriter writer$1, Object entry) {
        writer$1.write($this.formatter.toLine(entry));
        writer$1.newLine();
    }

    private final /* synthetic */ void liftedTree1$1(Iterable entries$1) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(Integer.toString(this.version));
                writer.newLine();
                writer.write(Integer.toString(entries$1.size()));
                writer.newLine();
                entries$1.foreach((Function1<Object, Object> & Serializable & scala.Serializable)entry -> {
                    CheckpointFile.$anonfun$write$1(this, writer, entry);
                    return BoxedUnit.UNIT;
                });
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback(this.tempPath(), this.path());
            return;
        }
        catch (IOException e) {
            String msg = new StringBuilder(39).append("Error while writing to checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String> & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, e);
        }
    }

    private final /* synthetic */ Seq liftedTree2$1() {
        try {
            Seq<T> seq;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                seq = new CheckpointReadBuffer<T>(this.file().getAbsolutePath(), reader, this.version, this.formatter).read();
            }
            return seq;
        }
        catch (IOException e) {
            String msg = new StringBuilder(36).append("Error while reading checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String> & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, e);
        }
    }

    public CheckpointFile(File file, int version, CheckpointFileFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) {
        this.file = file;
        this.version = version;
        this.formatter = formatter;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        try {
            Files.createFile(file.toPath(), new FileAttribute[0]);
            return;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            return;
        }
    }
}

