/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper$;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Send;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$$eq$colon$eq$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]q!B\f\u0019\u0011\u0003ib!B\u0010\u0019\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003\"B\u0015\u0002\t\u0003Qc\u0001B\u0010\u0019\u0001YC\u0001\"\u0018\u0003\u0003\u0002\u0003\u0006IA\u0018\u0005\tI\u0012\u0011\t\u0011)A\u0005K\"A\u0001\u000f\u0002B\u0001B\u0003%\u0011\u000f\u0003\u0005~\t\t\u0005\t\u0015!\u0003\u007f\u0011\u00199C\u0001\"\u0001\u0002\u000e!9\u0011\u0011\u0004\u0003\u0005\u0002\u0005m\u0001bBA\u001d\t\u0011\u0005\u00111\b\u0005\b\u0003\u001f\"A\u0011AA)\u0011\u001d\t)\u0007\u0002C\u0001\u0003OBq!a\u001c\u0005\t\u0003\t\t\bC\u0004\u0002v\u0011!\t!a\u001e\t\u000f\u0005\u001dE\u0001\"\u0001\u0002\n\"I\u0011Q\u0015\u0003\u0012\u0002\u0013\u0005\u0011q\u0015\u0005\b\u0003{#A\u0011AA`\u0011\u001d\tI\r\u0002C\u0001\u0003\u0017Dq!!5\u0005\t\u0003\t\u0019\u000eC\u0004\u0002X\u0012!\t!!7\t\u000f\t%A\u0001\"\u0001\u0003\f\u0005!\"+Z9vKN$\b*\u00198eY\u0016\u0014\b*\u001a7qKJT!!\u0007\u000e\u0002\rM,'O^3s\u0015\u0005Y\u0012!B6bM.\f7\u0001\u0001\t\u0003=\u0005i\u0011\u0001\u0007\u0002\u0015%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005\u0011rN\u001c'fC\u0012,'o\u001d5ja\u000eC\u0017M\\4f)\u0015Yc\u0006\u000f!U!\t\u0011C&\u0003\u0002.G\t!QK\\5u\u0011\u0015y3\u00011\u00011\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u00022m5\t!G\u0003\u00024i\u0005)qM]8va*\u0011QGG\u0001\fG>|'\u000fZ5oCR|'/\u0003\u00028e\t\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0005\u0006s\r\u0001\rAO\u0001\u000fibt7i\\8sI&t\u0017\r^8s!\tYd(D\u0001=\u0015\tiD'A\u0006ue\u0006t7/Y2uS>t\u0017BA =\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\b\"B!\u0004\u0001\u0004\u0011\u0015AD;qI\u0006$X\r\u001a'fC\u0012,'o\u001d\t\u0004\u0007.seB\u0001#J\u001d\t)\u0005*D\u0001G\u0015\t9E$\u0001\u0004=e>|GOP\u0005\u0002I%\u0011!jI\u0001\ba\u0006\u001c7.Y4f\u0013\taUJ\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tQ5\u0005\u0005\u0002P%6\t\u0001K\u0003\u0002R5\u000591\r\\;ti\u0016\u0014\u0018BA*Q\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003V\u0007\u0001\u0007!)\u0001\tva\u0012\fG/\u001a3G_2dwn^3sgN\u0019A!I,\u0011\u0005a[V\"A-\u000b\u0005iS\u0012!B;uS2\u001c\u0018B\u0001/Z\u0005\u001daunZ4j]\u001e\faB]3rk\u0016\u001cHo\u00115b]:,G\u000e\u0005\u0002`E6\t\u0001M\u0003\u0002b5\u00059a.\u001a;x_J\\\u0017BA2a\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fa!];pi\u0006\u001c\bC\u00014n\u001d\t97N\u0004\u0002iU:\u0011Q)[\u0005\u00027%\u0011\u0011DG\u0005\u0003Yb\tA\"U;pi\u00064\u0015m\u0019;pefL!A\\8\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\ta\u0007$\u0001\u0003uS6,\u0007C\u0001:|\u001b\u0005\u0019(B\u0001.u\u0015\t)h/\u0001\u0004d_6lwN\u001c\u0006\u00037]T!\u0001_=\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0018aA8sO&\u0011Ap\u001d\u0002\u0005)&lW-A\u0005m_\u001e\u0004&/\u001a4jqB\u0019q0a\u0002\u000f\t\u0005\u0005\u00111\u0001\t\u0003\u000b\u000eJ1!!\u0002$\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA\u0012\u0015\u0015\u0005=\u0011\u0011CA\n\u0003+\t9\u0002\u0005\u0002\u001f\t!)Q,\u0003a\u0001=\")A-\u0003a\u0001K\")\u0001/\u0003a\u0001c\")Q0\u0003a\u0001}\u0006Y\u0001.\u00198eY\u0016,%O]8s)\u0015Y\u0013QDA\u0018\u0011\u001d\tyB\u0003a\u0001\u0003C\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002$\u0005%bbA0\u0002&%\u0019\u0011q\u00051\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u00111FA\u0017\u0005\u001d\u0011V-];fgRT1!a\na\u0011\u001d\t\tD\u0003a\u0001\u0003g\t\u0011!\u001a\t\u0004\u0007\u0006U\u0012bAA\u001c\u001b\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0016g\u0016tGMR8so\u0006\u0014H-\u001a3SKN\u0004xN\\:f)\u0015Y\u0013QHA \u0011\u001d\tyb\u0003a\u0001\u0003CAq!!\u0011\f\u0001\u0004\t\u0019%\u0001\u0005sKN\u0004xN\\:f!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%i\u0006A!/Z9vKN$8/\u0003\u0003\u0002N\u0005\u001d#\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003e\u0019XM\u001c3SKN\u0004xN\\:f\u001b\u0006L(-\u001a+ie>$H\u000f\\3\u0015\u000b-\n\u0019&!\u0016\t\u000f\u0005}A\u00021\u0001\u0002\"!9\u0011q\u000b\u0007A\u0002\u0005e\u0013AD2sK\u0006$XMU3ta>t7/\u001a\t\bE\u0005m\u0013qLA\"\u0013\r\tif\t\u0002\n\rVt7\r^5p]F\u00022AIA1\u0013\r\t\u0019g\t\u0002\u0004\u0013:$\u0018AH:f]\u0012,%O]8s%\u0016\u001c\bo\u001c8tK6\u000b\u0017PY3UQJ|G\u000f\u001e7f)\u0015Y\u0013\u0011NA6\u0011\u001d\ty\"\u0004a\u0001\u0003CAq!!\u001c\u000e\u0001\u0004\t\u0019$A\u0003feJ|'/A\u0010nCf\u0014WMU3d_J$\u0017I\u001c3HKR$\u0006N]8ui2,G+[7f\u001bN$B!a\u0018\u0002t!9\u0011q\u0004\bA\u0002\u0005\u0005\u0012\u0001L:f]\u0012\u0014Vm\u001d9p]N,W*Y=cKRC'o\u001c;uY\u0016<\u0016\u000e\u001e5D_:$(o\u001c7mKJ\fVo\u001c;b)\u001dY\u0013\u0011PAB\u0003\u000bCq!a\u001f\u0010\u0001\u0004\ti(A\fd_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uCB\u0019a$a \n\u0007\u0005\u0005\u0005DA\fD_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC\"9\u0011qD\bA\u0002\u0005\u0005\u0002bBA,\u001f\u0001\u0007\u0011\u0011L\u0001\u001bg\u0016tGMU3ta>t7/Z#yK6\u0004H\u000f\u00165s_R$H.\u001a\u000b\bW\u0005-\u0015QRAH\u0011\u001d\ty\u0002\u0005a\u0001\u0003CAq!!\u0011\u0011\u0001\u0004\t\u0019\u0005C\u0005\u0002\u0012B\u0001\n\u00111\u0001\u0002\u0014\u0006QqN\\\"p[BdW\r^3\u0011\u000b\t\n)*!'\n\u0007\u0005]5E\u0001\u0004PaRLwN\u001c\t\u0007E\u0005m\u00131T\u0016\u0011\t\u0005u\u0015\u0011U\u0007\u0003\u0003?S!!\u0019;\n\t\u0005\r\u0016q\u0014\u0002\u0005'\u0016tG-\u0001\u0013tK:$'+Z:q_:\u001cX-\u0012=f[B$H\u000b\u001b:piRdW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tIK\u000b\u0003\u0002\u0014\u0006-6FAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]6%\u0001\u0006b]:|G/\u0019;j_:LA!a/\u00022\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025M,g\u000eZ#se>\u0014xJ]\"m_N,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000f-\n\t-a1\u0002F\"9\u0011q\u0004\nA\u0002\u0005\u0005\u0002bBA7%\u0001\u0007\u00111\u0007\u0005\b\u0003\u000f\u0014\u0002\u0019AA0\u0003)!\bN]8ui2,Wj]\u0001 g\u0016tG-\u0012:s_J\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,G#B\u0016\u0002N\u0006=\u0007bBA\u0010'\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003[\u001a\u0002\u0019AA\u001a\u0003y\u0019XM\u001c3O_>\u0003(+Z:q_:\u001cX-\u0012=f[B$H\u000b\u001b:piRdW\rF\u0002,\u0003+Dq!a\b\u0015\u0001\u0004\t\t#A\bdY>\u001cXmQ8o]\u0016\u001cG/[8o)\u0015Y\u00131\\Ao\u0011\u001d\ty\"\u0006a\u0001\u0003CAq!a8\u0016\u0001\u0004\t\t/A\u0006feJ|'oQ8v]R\u001c\b\u0003CAr\u0003[\f\t0!@\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\fA!\u001e;jY*\u0011\u00111^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0006\u0015(aA'baB!\u00111_A}\u001b\t\t)PC\u0002\u0002xR\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003w\f)P\u0001\u0004FeJ|'o\u001d\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)!!1AAu\u0003\u0011a\u0017M\\4\n\t\t\u001d!\u0011\u0001\u0002\b\u0013:$XmZ3s\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u001dY#Q\u0002B\b\u0005+Aq!a\b\u0017\u0001\u0004\t\t\u0003C\u0004\u0003\u0012Y\u0001\rAa\u0005\u0002\u0017I,7\u000f]8og\u0016|\u0005\u000f\u001e\t\u0006E\u0005U\u00151\t\u0005\b\u0003#3\u0002\u0019AAJ\u0001")
public class RequestHandlerHelper
implements Logging {
    private final RequestChannel requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void onLeadershipChange(GroupCoordinator groupCoordinator, TransactionCoordinator transactionCoordinator, Iterable<Partition> iterable, Iterable<Partition> iterable2) {
        RequestHandlerHelper$.MODULE$.onLeadershipChange(groupCoordinator, transactionCoordinator, iterable, iterable2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        boolean mayThrottle = e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction;
        this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Error when handling request: ").append("clientId=").append(request.header().clientId()).append(", ").append("correlationId=").append(request.header().correlationId()).append(", ").append("api=").append((Object)request.header().apiKey()).append(", ").append("version=").append(request.header().apiVersion()).append(", ").append("body=").append(request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()))).toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
        if (mayThrottle) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response2) {
        int throttleTimeMs = response2.throttleTimeMs();
        this.quotas.request().throttle(request, throttleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
            this.requestChannel.sendResponse(response);
            return BoxedUnit.UNIT;
        });
        this.sendResponse(request, new Some<AbstractResponse>(response2), None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.quotas.request().throttle(request, throttleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
                this.requestChannel.sendResponse(response);
                return BoxedUnit.UNIT;
            });
        }
        this.sendResponse(request, new Some<AbstractResponse>(createResponse.apply(BoxesRunTime.boxToInteger(throttleTimeMs))), None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.quotas.request().throttle(request, throttleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
                this.requestChannel.sendResponse(response);
                return BoxedUnit.UNIT;
            });
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    /*
     * WARNING - void declaration
     */
    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        void var2_2;
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return (int)var2_2;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.quotas.controllerMutation().throttle(request, controllerThrottleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
                    this.requestChannel.sendResponse(response);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.quotas.request().throttle(request, requestThrottleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
                    this.requestChannel.sendResponse(response);
                    return BoxedUnit.UNIT;
                });
            }
        }
        this.sendResponse(request, new Some<AbstractResponse>(createResponse.apply(BoxesRunTime.boxToInteger(maxThrottleTimeMs))), None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendResponse(request, new Some<AbstractResponse>(response), onComplete);
    }

    public void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = ((AbstractRequest)requestBody).getErrorResponse(throttleMs, error);
        if (response == null) {
            this.closeConnection(request, ((AbstractRequest)requestBody).errorCounts(error));
            return;
        }
        this.sendResponse(request, new Some<AbstractResponse>(response), None$.MODULE$);
    }

    public void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendResponse(request, None$.MODULE$, None$.MODULE$);
    }

    public void closeConnection(RequestChannel.Request request, java.util.Map<Errors, Integer> errorCounts) {
        this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)CollectionConverters$.MODULE$.mapAsScalaMapConverter(errorCounts).asScala());
        this.requestChannel.sendResponse(new RequestChannel.CloseConnectionResponse(request));
    }

    public void sendResponse(RequestChannel.Request request, Option<AbstractResponse> responseOpt, Option<Function1<Send, BoxedUnit>> onComplete) {
        RequestChannel.Response response2;
        responseOpt.foreach((Function1<AbstractResponse, Object> & Serializable & scala.Serializable)response -> {
            this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala());
            return BoxedUnit.UNIT;
        });
        if (responseOpt instanceof Some) {
            AbstractResponse response3 = (AbstractResponse)((Some)responseOpt).value();
            response2 = new RequestChannel.SendResponse(request, request.buildResponseSend(response3), request.responseNode(response3), onComplete);
        } else if (None$.MODULE$.equals(responseOpt)) {
            response2 = new RequestChannel.NoOpResponse(request);
        } else {
            throw new MatchError(responseOpt);
        }
        this.requestChannel.sendResponse(response2);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time, String logPrefix) {
        this.requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
    }
}

