/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.pinot.shaded.org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.Records;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.FetchRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.FetchResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.RequestUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionForJava8$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcJ$sp;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u0014(\u00011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\n\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u001aC\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011%9\u0006A!A!\u0002\u0013A6\fC\u0003]\u0001\u0011\u0005Q\fC\u0004g\u0001\t\u0007I\u0011B4\t\r1\u0004\u0001\u0015!\u0003i\u0011\u001di\u0007A1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%IA\u001c\u0005\u0007s\u0002\u0001\u000b\u0011B8\t\u000fi\u0004\u0001\u0019!C\u0005w\"I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\b\u0003G\u0001\u0001\u0015)\u0003}\u0011\u001d\t)\u0003\u0001C)\u0003OAq!a\f\u0001\t#\n\t\u0004C\u0004\u0002<\u0001!\t&!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0015\u0002D!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\t\u0019\u000f\u0001C)\u0003KDq!!<\u0001\t#\ny\u000fC\u0004\u0002v\u0002!\t%a>\t\u0013\tu\u0001A1A\u0005R\t}\u0001\u0002\u0003B\u0014\u0001\u0001\u0006IA!\t\t\u0013\t%\u0002A1A\u0005R\t}\u0001\u0002\u0003B\u0016\u0001\u0001\u0006IA!\t\t\u000f\t5\u0002\u0001\"\u0011\u00030!9!Q\b\u0001\u0005R\t}\u0002b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OBqAa$\u0001\t\u0003\u0011\tJA\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$'B\u0001\u0015*\u0003\u0019\u0019XM\u001d<fe*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00180\u001b\u00059\u0013B\u0001\u0019(\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u00111\u0007\u0010\b\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR!aN\u0016\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mB\u0014\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA!E\u001b\u0005\u0011%BA\"*\u0003\u001d\u0019G.^:uKJL!!\u0012\"\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qhL\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003]%K!AS\u0014\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"AL'\n\u00059;#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003]EK!AU\u0014\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011a&V\u0005\u0003-\u001e\u0012qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u0002!\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\bC\u0001\u0018Z\u0013\tQvE\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug&\u0011qkL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011y{\u0006-\u00192dI\u0016\u0004\"A\f\u0001\t\u000bEB\u0001\u0019\u0001\u001a\t\u000b}B\u0001\u0019\u0001!\t\u000b\u001dC\u0001\u0019\u0001%\t\u000b-C\u0001\u0019\u0001'\t\u000b=C\u0001\u0019\u0001)\t\u000bMC\u0001\u0019\u0001+\t\u000b]C\u0001\u0019\u0001-\u0002\u0013I,\u0007\u000f\\5dC&#W#\u00015\u0011\u0005%TW\"\u0001\u001d\n\u0005-D$aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00115\f\u0007PQ=uKN,\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fA\u0001\\1oO*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u0005\u001dIe\u000e^3hKJ\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005\u0019\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]V\tA\u0010E\u0002j{~L!A \u001d\u0003\r=\u0003H/[8o!\u0011\t\t!!\u0005\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\taaY8n[>t'b\u0001\u0016\u0002\n)!\u00111BA\u0007\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qB\u0001\u0004_J<\u0017\u0002BA\n\u0003\u0007\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR!\u0011\u0011DA\u0010!\rI\u00171D\u0005\u0004\u0003;A$\u0001B+oSRD\u0001\"!\t\u0011\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\n\u0014\u0001F5o!J|wM]3tgB\u000b'\u000f^5uS>t\u0007%A\u0006mCR,7\u000f^#q_\u000eDG\u0003BA\u0015\u0003W\u00012![?i\u0011\u0019\tiC\u0005a\u0001\u007f\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0005\u0003g\tI\u0004E\u0002j\u0003kI1!a\u000e9\u0005\u0011auN\\4\t\r\u000552\u00031\u0001\u0000\u00031awnZ#oI>3gm]3u)\u0011\t\u0019$a\u0010\t\r\u00055B\u00031\u0001\u0000\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u000b\ni%a\u0014\u0011\t%l\u0018q\t\t\u0004]\u0005%\u0013bAA&O\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007BBA\u0017+\u0001\u0007q\u0010\u0003\u0004\u0002RU\u0001\r\u0001[\u0001\u0006KB|7\r[\u0001\u0010M\u0016$8\r\u001b$s_6dU-\u00193feR!\u0011qKA6!\u001d\tI&a\u0018\u0000\u0003Gj!!a\u0017\u000b\u0007\u0005u\u0003(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002\\\t\u0019Q*\u00199\u0011\t\u0005\u0015\u0014qM\u0007\u0002\u0001%\u0019\u0011\u0011N\u0018\u0003\u0013\u0019+Go\u00195ECR\f\u0007bBA7-\u0001\u0007\u0011qN\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0003c\niH\u0004\u0003\u0002t\u0005eTBAA;\u0015\u0011\t9(a\u0001\u0002\u0011I,\u0017/^3tiNLA!a\u001f\u0002v\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011qPAA\u0005\u001d\u0011U/\u001b7eKJTA!a\u001f\u0002v\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"a\"\u0002\u0016\u0006]\u00151\u0014\t\u0005Sv\fI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty)K\u0001\u0004Y><\u0017\u0002BAJ\u0003\u001b\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007BBA\u0017/\u0001\u0007q\u0010C\u0004\u0002\u001a^\u0001\r!a\r\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0003;;\u0002\u0019AAP\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB1\u0011\u0011UA^\u0003\u0003tA!a)\u00028:!\u0011QUA[\u001d\u0011\t9+a-\u000f\t\u0005%\u0016\u0011\u0017\b\u0005\u0003W\u000byKD\u00026\u0003[K!!a\u0004\n\t\u0005-\u0011QB\u0005\u0004U\u0005%\u0011\u0002BA\u0003\u0003\u000fIA!a\u001e\u0002\u0004%!\u0011\u0011XA;\u000351U\r^2i%\u0016\u001c\bo\u001c8tK&!\u0011QXA`\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011\u0011XA;!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0007\taA]3d_J$\u0017\u0002BAf\u0003\u000b\u0014qAU3d_J$7/A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003#\f9\u000eE\u0003\u0002Z\u0005Mw0\u0003\u0003\u0002V\u0006m#aA*fi\"9\u0011\u0011\u001c\rA\u0002\u0005m\u0017AE5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uKN\u0004r!!\u0017\u0002`}\fi\u000eE\u0002/\u0003?L1!!9(\u0005EIe.\u001b;jC24U\r^2i'R\fG/Z\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u00111GAt\u0003SDa!!\f\u001a\u0001\u0004y\bBBAv3\u0001\u0007\u0001.A\u0006mK\u0006$WM]#q_\u000eD\u0017a\u00074fi\u000eDG*\u0019;fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u00024\u0005E\u00181\u001f\u0005\u0007\u0003[Q\u0002\u0019A@\t\r\u0005-(\u00041\u0001i\u0003Q1W\r^2i\u000bB|7\r[#oI>3gm]3ugR!\u0011\u0011 B\t!\u001d\tI&a\u0018\u0000\u0003w\u0004B!!@\u0003\f9!\u0011q B\u0003\u001d\u0011\t)K!\u0001\n\t\t\r\u00111A\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u00119A!\u0003\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0005\u0007\t\u0019!\u0003\u0003\u0003\u000e\t=!AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0006\u0005\u0005\u000f\u0011I\u0001C\u0004\u0003\u0014m\u0001\rA!\u0006\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0004\u0002Z\u0005}sPa\u0006\u0011\t\u0005\u0015$\u0011D\u0005\u0004\u00057y#!C#q_\u000eDG)\u0019;b\u0003}I7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u0005C\u00012!\u001bB\u0012\u0013\r\u0011)\u0003\u000f\u0002\b\u0005>|G.Z1o\u0003\u0001J7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\r\u001a\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fI\u0006i\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$\u0007%\u0001\u0005ueVt7-\u0019;f)\u0019\tIB!\r\u00034!1\u0011Q\u0006\u0011A\u0002}DqA!\u000e!\u0001\u0004\u00119$A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\rq#\u0011H\u0005\u0004\u0005w9#!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!\u0007\u0003B\t\r\u0003BBA\u0017C\u0001\u0007q\u0010C\u0004\u0003F\u0005\u0002\r!a\r\u0002\r=4gm]3u\u0003IqW\r\u001f;SK\u0006$\u0017\u0010U1si&$\u0018n\u001c8\u0015\t\t-#\u0011\f\t\u0005Sv\u0014i\u0005\u0005\u0004j\u0005\u001fz(1K\u0005\u0004\u0005#B$A\u0002+va2,'\u0007E\u0002/\u0005+J1Aa\u0016(\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0011\u001d\u0011YF\ta\u0001\u0005;\nA\u0002]1si&$\u0018n\u001c8NCB\u0004r!!\u0017\u0002`}\u0014\u0019&\u0001\ftK2,7\r\u001e)beRLG/[8o)>4U\r^2i)\u0011\u0011YEa\u0019\t\u000f\tm3\u00051\u0001\u0003^\u00051\"-^5mI\u001a+Go\u00195G_J\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0003j\t\u001d%1\u0012\t\u0007\u0005W\u0012IHa \u000f\t\t5$Q\u000f\b\u0005\u0005_\u0012\u0019HD\u00026\u0005cJ\u0011AK\u0005\u0003Q%J1Aa\u001e(\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012LAAa\u001f\u0003~\t!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NT1Aa\u001e(!\u0011IWP!!\u0011\t\t-$1Q\u0005\u0005\u0005\u000b\u0013iH\u0001\u0007SKBd\u0017nY1GKR\u001c\u0007\u000e\u0003\u0004\u0003\n\u0012\u0002\ra`\u0001\u0003iBDqA!$%\u0001\u0004\u0011\u0019&\u0001\u0006gKR\u001c\u0007n\u0015;bi\u0016\f!BY;jY\u00124U\r^2i)\u0011\u0011IGa%\t\u000f\tmS\u00051\u0001\u0003^\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean isTruncationOnFetchSupported;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef<Object> partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1<Seq, Object> & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel(), None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        Log futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(partitionData.records());
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(futureLog.logEndOffset())})));
        }
        None$ logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LeaderOffsetIncremented$.MODULE$);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions(filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return partitions.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaMgr.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch(epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException(t).code()));
                }
            } else {
                throw new MatchError((Object)null);
            }
            Tuple2<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> tuple22 = tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2<Tuple2, Tuple2, Tuple2> & Serializable & scala.Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less(((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq(None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        Option option;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply(Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            Optional<Integer> lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1<Object, Integer> & Serializable & scala.Serializable)x$3 -> ReplicaAlterLogDirsThread.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt(x$3))))) : Optional.empty();
            requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable & scala.Serializable)() -> e);
            partitionsWithError.$plus$eq(tp);
        }
        if (requestMap.isEmpty()) {
            option = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica(ApiKeys.FETCH.latestVersion(), this.replicaId(), 0, 0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            option = new Some<AbstractFetcherThread.ReplicaFetch>(new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = option;
        return new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(fetchRequestOpt, partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = responsePartitionData.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            java.util.List abortedTransactions = (java.util.List)data.abortedTransactions().map((Function1<List, java.util.List> & Serializable & scala.Serializable)x$1 -> CollectionConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong(data.lastStableOffset().getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
            Tuple2<TopicPartition, FetchResponse.PartitionData<Records>> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new FetchResponse.PartitionData<Records>(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, data.records()));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitionMap$1.get(tp).filter((Function1<PartitionFetchState, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isReadyForFetch())).foreach((Function1<PartitionFetchState, Nothing$> & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl<Some<Tuple2<TopicPartition, PartitionFetchState>>>(nonLocalReturnKey1$1, new Some<Tuple2<TopicPartition, PartitionFetchState>>(new Tuple2<TopicPartition, PartitionFetchState>(tp, (PartitionFetchState)fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq(new Some<TopicPartition>(tp));
            $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$3) {
        return BoxesRunTime.boxToInteger(x$3);
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, brokerTopicStats);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isOffsetForLeaderEpochSupported = true;
        this.isTruncationOnFetchSupported = false;
    }
}

