/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.LogDirFailureChannel;
import kafka.server.PartitionMetadata;
import kafka.server.PartitionMetadataFile$;
import kafka.server.PartitionMetadataFile$PartitionMetadataFileFormatter$;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.common.Uuid;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!B\u0015+\u0011\u0003yc!B\u0019+\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%I\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0019\u000b!\u0019!C\u0005\u000f\"1\u0001+\u0001Q\u0001\n!Cq!U\u0001C\u0002\u0013%!\u000b\u0003\u0004W\u0003\u0001\u0006Ia\u0015\u0005\u0006/\u0006!\t\u0001W\u0004\u0006C\u0006A\tA\u0019\u0004\u0006I\u0006A\t!\u001a\u0005\u0006s-!\tA\u001a\u0005\u0006O.!\t\u0001\u001b\u0004\u0005q\u0006\u0001\u0011\u0010C\u0005\u0002\u00049\u0011\t\u0011)A\u0005S\"Q\u0011Q\u0001\b\u0003\u0002\u0003\u0006I!a\u0002\t\u0013\u00055aB!A!\u0002\u0013\u0019\u0006BB\u001d\u000f\t\u0003\ty\u0001C\u0004\u000209!\t!!\r\u0007\u000bER\u0003!a\r\t\u0015\u0005UBC!b\u0001\n\u0003\t9\u0004C\u0005\u0002:Q\u0011\t\u0011)A\u00053\"Q\u00111\b\u000b\u0003\u0002\u0003\u0006I!!\u0010\t\re\"B\u0011AA\"\u0011%\tY\u0005\u0006b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002^Q\u0001\u000b\u0011BA(\u0011%\ty\u0006\u0006b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002bQ\u0001\u000b\u0011BA(\u0011%\t\u0019\u0007\u0006b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002nQ\u0001\u000b\u0011BA4\u0011!\ty\u0007\u0006b\u0001\n\u0013a\u0004bBA9)\u0001\u0006I!\u0010\u0005\n\u0003g\"\u0002\u0019!C\u0005\u0003kB\u0011\"a%\u0015\u0001\u0004%I!!&\t\u0011\u0005\u0005F\u0003)Q\u0005\u0003oBq!a+\u0015\t\u0003\ti\u000bC\u0004\u00024R!\t!!.\t\u000f\u0005=B\u0003\"\u0001\u00022!9\u0011q\u0017\u000b\u0005\u0002\u0005e\u0006bBAa)\u0011\u0005\u0011\u0011X\u0001\u0016!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f\u0015\tYC&\u0001\u0004tKJ4XM\u001d\u0006\u0002[\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0019\u0002\u001b\u0005Q#!\u0006)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.Z\n\u0003\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00010\u0003e\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u0016t\u0017-\\3\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\u001b!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f]\u0006lW\rI\u0001\u0013/\"LG/Z*qC\u000e,7\u000fU1ui\u0016\u0014h.F\u0001I!\tIe*D\u0001K\u0015\tYE*A\u0003sK\u001e,\u0007P\u0003\u0002N\u0003\u0006!Q\u000f^5m\u0013\ty%JA\u0004QCR$XM\u001d8\u0002']C\u0017\u000e^3Ta\u0006\u001cWm\u001d)biR,'O\u001c\u0011\u0002\u001d\r+(O]3oiZ+'o]5p]V\t1\u000b\u0005\u00025)&\u0011Q+\u000e\u0002\u0004\u0013:$\u0018aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\u0002\u000f9,wOR5mKR\u0011\u0011l\u0018\t\u00035vk\u0011a\u0017\u0006\u00039\u0006\u000b!![8\n\u0005y[&\u0001\u0002$jY\u0016DQ\u0001Y\u0005A\u0002e\u000b1\u0001Z5s\u0003y\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u00164uN]7biR,'\u000f\u0005\u0002d\u00175\t\u0011A\u0001\u0010QCJ$\u0018\u000e^5p]6+G/\u00193bi\u00064\u0015\u000e\\3G_Jl\u0017\r\u001e;feN\u00111b\r\u000b\u0002E\u00061Ao\u001c$jY\u0016$\"![:\u0011\u0005)\fhBA6p!\taW'D\u0001n\u0015\tqg&\u0001\u0004=e>|GOP\u0005\u0003aV\na\u0001\u0015:fI\u00164\u0017B\u0001#s\u0015\t\u0001X\u0007C\u0003u\u001b\u0001\u0007Q/\u0001\u0003eCR\f\u0007C\u0001\u0019w\u0013\t9(FA\tQCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006\u00141\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b%\u0016\fGMQ;gM\u0016\u0014Xc\u0001>\u0002\u0018M\u0019abM>\u0011\u0005q|X\"A?\u000b\u0005yd\u0013!B;uS2\u001c\u0018bAA\u0001{\n9Aj\\4hS:<\u0017\u0001\u00037pG\u0006$\u0018n\u001c8\u0002\rI,\u0017\rZ3s!\rQ\u0016\u0011B\u0005\u0004\u0003\u0017Y&A\u0004\"vM\u001a,'/\u001a3SK\u0006$WM]\u0001\bm\u0016\u00148/[8o)!\t\t\"!\u000b\u0002,\u00055\u0002\u0003B2\u000f\u0003'\u0001B!!\u0006\u0002\u00181\u0001AaBA\r\u001d\t\u0007\u00111\u0004\u0002\u0002)F!\u0011QDA\u0012!\r!\u0014qD\u0005\u0004\u0003C)$a\u0002(pi\"Lgn\u001a\t\u0004i\u0005\u0015\u0012bAA\u0014k\t\u0019\u0011I\\=\t\r\u0005\r!\u00031\u0001j\u0011\u001d\t)A\u0005a\u0001\u0003\u000fAa!!\u0004\u0013\u0001\u0004\u0019\u0016\u0001\u0002:fC\u0012$\u0012!^\n\u0004)MZ\u0018\u0001\u00024jY\u0016,\u0012!W\u0001\u0006M&dW\rI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\u0007A\ny$C\u0002\u0002B)\u0012A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dGCBA#\u0003\u000f\nI\u0005\u0005\u00021)!1\u0011Q\u0007\rA\u0002eCq!a\u000f\u0019\u0001\u0004\ti$\u0001\u0003qCRDWCAA(!\u0011\t\t&!\u0017\u000e\u0005\u0005M#\u0002BA\u001b\u0003+R1!a\u0016B\u0003\rq\u0017n\\\u0005\u0005\u00037\n\u0019F\u0001\u0003QCRD\u0017!\u00029bi\"\u0004\u0013\u0001\u0003;f[B\u0004\u0016\r\u001e5\u0002\u0013Q,W\u000e\u001d)bi\"\u0004\u0013\u0001\u00027pG.,\"!a\u001a\u0011\u0007y\nI'C\u0002\u0002l}\u0012aa\u00142kK\u000e$\u0018!\u00027pG.\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001f\u0011L'\u000f^=U_BL7-\u00133PaR,\"!a\u001e\u0011\u000bQ\nI(! \n\u0007\u0005mTG\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u007f\ny)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0019\u0019w.\\7p]*\u0019Q&a\"\u000b\t\u0005%\u00151R\u0001\u0007CB\f7\r[3\u000b\u0005\u00055\u0015aA8sO&!\u0011\u0011SAA\u0005\u0011)V/\u001b3\u0002'\u0011L'\u000f^=U_BL7-\u00133PaR|F%Z9\u0015\t\u0005]\u0015Q\u0014\t\u0004i\u0005e\u0015bAANk\t!QK\\5u\u0011%\tyJIA\u0001\u0002\u0004\t9(A\u0002yIE\n\u0001\u0003Z5sif$v\u000e]5d\u0013\u0012|\u0005\u000f\u001e\u0011)\u0007\r\n)\u000bE\u00025\u0003OK1!!+6\u0005!1x\u000e\\1uS2,\u0017A\u0002:fG>\u0014H\r\u0006\u0003\u0002\u0018\u0006=\u0006bBAYI\u0001\u0007\u0011QP\u0001\bi>\u0004\u0018nY%e\u0003)i\u0017-\u001f2f\r2,8\u000f\u001b\u000b\u0003\u0003/\u000ba!\u001a=jgR\u001cHCAA^!\r!\u0014QX\u0005\u0004\u0003\u007f+$a\u0002\"p_2,\u0017M\\\u0001\u0007I\u0016dW\r^3")
public class PartitionMetadataFile
implements Logging {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String logDir;
    private volatile Option<Uuid> dirtyTopicIdOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static File newFile(File file) {
        return PartitionMetadataFile$.MODULE$.newFile(file);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    private String logDir() {
        return this.logDir;
    }

    private Option<Uuid> dirtyTopicIdOpt() {
        return this.dirtyTopicIdOpt;
    }

    private void dirtyTopicIdOpt_$eq(Option<Uuid> x$1) {
        this.dirtyTopicIdOpt = x$1;
    }

    public void record(Uuid topicId) {
        this.dirtyTopicIdOpt().foreach((Function1<Uuid, Object> & Serializable & scala.Serializable)dirtyTopicId -> {
            PartitionMetadataFile.$anonfun$record$1(topicId, dirtyTopicId);
            return BoxedUnit.UNIT;
        });
        this.dirtyTopicIdOpt_$eq(new Some<Uuid>(topicId));
    }

    public void maybeFlush() {
        this.dirtyTopicIdOpt().foreach((Function1<Uuid, Object> & Serializable & scala.Serializable)x$1 -> {
            PartitionMetadataFile.$anonfun$maybeFlush$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public PartitionMetadata read() {
        Object object = this.lock();
        synchronized (object) {
            PartitionMetadata partitionMetadata = this.liftedTree1$1();
            return partitionMetadata;
        }
    }

    public boolean exists() {
        return this.file().exists();
    }

    public boolean delete() {
        return this.file().delete();
    }

    public static final /* synthetic */ void $anonfun$record$1(Uuid topicId$1, Uuid dirtyTopicId) {
        Uuid uuid = dirtyTopicId;
        if (uuid == null ? topicId$1 != null : !((Object)uuid).equals(topicId$1)) {
            throw new InconsistentTopicIdException(new StringBuilder(59).append("Tried to record topic ID ").append(topicId$1).append(" to file ").append("but had already recorded ").append(dirtyTopicId).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$2(PartitionMetadataFile $this, Uuid topicId) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream($this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(PartitionMetadataFile$PartitionMetadataFileFormatter$.MODULE$.toFile(new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), topicId)));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback($this.tempPath(), $this.path());
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to partition metadata file ").append($this.file().getAbsolutePath()).toString();
            $this.logDirFailureChannel.maybeAddOfflineLogDir($this.logDir(), (Function0<String> & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, e);
        }
        $this.dirtyTopicIdOpt_$eq(None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(PartitionMetadataFile $this, Uuid x$1) {
        Object object = $this.lock();
        synchronized (object) {
            $this.dirtyTopicIdOpt().foreach((Function1<Uuid, Object> & Serializable & scala.Serializable)topicId -> {
                PartitionMetadataFile.$anonfun$maybeFlush$2($this, topicId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final /* synthetic */ PartitionMetadata liftedTree1$1() {
        try {
            PartitionMetadata partitionMetadata;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                partitionMetadata = new PartitionMetadataReadBuffer(this.file().getAbsolutePath(), reader, PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()).read();
            }
            return partitionMetadata;
        }
        catch (IOException e) {
            String msg = new StringBuilder(44).append("Error while reading partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), (Function0<String> & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, e);
        }
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        this.logDir = file.getParentFile().getParent();
        this.dirtyTopicIdOpt = None$.MODULE$;
    }

    public static class PartitionMetadataReadBuffer<T>
    implements Logging {
        private final String location;
        private final BufferedReader reader;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PartitionMetadata read() {
            String line = null;
            try {
                line = this.reader.readLine();
                String[] stringArray = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                Option option = Array$.MODULE$.unapplySeq(stringArray);
                if (option.isEmpty()) throw this.malformedLineException$1(line);
                if (option.get() == null) throw this.malformedLineException$1(line);
                if (((SeqLike)option.get()).lengthCompare(2) != 0) throw this.malformedLineException$1(line);
                String version = (String)((SeqLike)option.get()).apply(1);
                if (new StringOps(Predef$.MODULE$.augmentString(version)).toInt() != PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()) throw new IOException(new StringBuilder(52).append("Unrecognized version of partition metadata file (").append(this.location).append("): ").append(version).toString());
                line = this.reader.readLine();
                String[] stringArray2 = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                Option option2 = Array$.MODULE$.unapplySeq(stringArray2);
                if (option2.isEmpty()) throw this.malformedLineException$1(line);
                if (option2.get() == null) throw this.malformedLineException$1(line);
                if (((SeqLike)option2.get()).lengthCompare(2) != 0) throw this.malformedLineException$1(line);
                Uuid metadataTopicId = Uuid.fromString((String)((SeqLike)option2.get()).apply(1));
                if (!metadataTopicId.equals(Uuid.ZERO_UUID)) return new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), metadataTopicId);
                throw new IOException(new StringBuilder(46).append("Invalid topic ID in partition metadata file (").append(this.location).append(")").toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1(line);
            }
        }

        private final IOException malformedLineException$1(String line) {
            return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
        }

        public PartitionMetadataReadBuffer(String location, BufferedReader reader, int version) {
            this.location = location;
            this.reader = reader;
            Logging.$init$(this);
        }
    }
}

