/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import kafka.log.AppendOrigin$RaftLeader$;
import kafka.log.Log;
import kafka.log.LogOffsetSnapshot;
import kafka.log.SnapshotGenerated$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.SegmentPosition;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Scheduler;
import org.apache.pinot.shaded.org.apache.kafka.common.KafkaException;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.Records;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.raft.Isolation;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogAppendInfo;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogFetchInfo;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetMetadata;
import org.apache.pinot.shaded.org.apache.kafka.raft.ReplicatedLog;
import org.apache.pinot.shaded.org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotWriter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0012%\u0005%B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0019!\u0007\u0001)Q\u0005K\")\u0011\u000e\u0001C!U\")\u0001\u0010\u0001C!s\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\u000b\u0001\t\u0003\ni\u0003\u0003\u0004p\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005u\u0003\u0001\"\u0011\u0002.!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA2\u0001\u0011\u0005\u0013Q\u0007\u0005\u0007\u001d\u0002!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\u0007I\u0002!\t%a#\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u00111\u0013\u0001\u0005B\u0005U\u0005bBAN\u0001\u0011\u0005\u0013\u0011M\u0004\b\u0003;#\u0003\u0012AAP\r\u0019\u0019C\u0005#\u0001\u0002\"\"1Al\bC\u0001\u0003SCq!a+ \t\u0003\ti\u000bC\u0004\u0002f~!I!a:\u0003!-\u000bgm[1NKR\fG-\u0019;b\u0019><'BA\u0013'\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001UI\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\t1\fgn\u001a\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0004PE*,7\r\u001e\t\u0003gij\u0011\u0001\u000e\u0006\u0003KUR!a\n\u001c\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0005\u0003wQ\u0012QBU3qY&\u001c\u0017\r^3e\u0019><\u0017a\u00017pOB\u0011a\bQ\u0007\u0002\u007f)\u0011AHJ\u0005\u0003\u0003~\u00121\u0001T8h\u0003-\u0019h.\u00199tQ>$\u0018\nZ:\u0011\u0007\u0011K5*D\u0001F\u0015\t1u)\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u0013\u0018\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u0016\u0013QcQ8oGV\u0014(/\u001a8u'.L\u0007\u000fT5tiN+G\u000f\u0005\u00024\u0019&\u0011Q\n\u000e\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001U*\u000e\u0003ES!AU\u001b\u0002\r\r|W.\\8o\u0013\t!\u0016K\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002'5\f\u0007PR3uG\"\u001c\u0016N_3J]\nKH/Z:\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0006=\u0002\f'm\u0019\t\u0003?\u0002i\u0011\u0001\n\u0005\u0006y\u0015\u0001\r!\u0010\u0005\u0006\u0005\u0016\u0001\ra\u0011\u0005\u0006\u001d\u0016\u0001\ra\u0014\u0005\u0006+\u0016\u0001\rAV\u0001\u0011_2$Wm\u001d;T]\u0006\u00048\u000f[8u\u0013\u0012\u00042AZ4L\u001b\u00059\u0015B\u00015H\u0005!y\u0005\u000f^5p]\u0006d\u0017\u0001\u0002:fC\u0012$2a\u001b8t!\t\u0019D.\u0003\u0002ni\taAj\\4GKR\u001c\u0007.\u00138g_\")qn\u0002a\u0001a\u0006Y1\u000f^1si>3gm]3u!\t9\u0016/\u0003\u0002s1\n!Aj\u001c8h\u0011\u0015!x\u00011\u0001v\u00035\u0011X-\u00193Jg>d\u0017\r^5p]B\u00111G^\u0005\u0003oR\u0012\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u001d\u0005\u0004\b/\u001a8e\u0003NdU-\u00193feR!!0`A\u0006!\t\u001940\u0003\u0002}i\tiAj\\4BaB,g\u000eZ%oM>DQA \u0005A\u0002}\fqA]3d_J$7\u000f\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!U\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005%\u00111\u0001\u0002\b%\u0016\u001cwN\u001d3t\u0011\u0019\ti\u0001\u0003a\u0001-\u0006)Q\r]8dQ\u0006\u0001\u0012\r\u001d9f]\u0012\f5OR8mY><XM\u001d\u000b\u0004u\u0006M\u0001\"\u0002@\n\u0001\u0004y\u0018!\b5b]\u0012dW-\u00118e\u0007>tg/\u001a:u\u0019><\u0017\t\u001d9f]\u0012LeNZ8\u0015\u0007i\fI\u0002C\u0004\u0002\u001c)\u0001\r!!\b\u0002\u0015\u0005\u0004\b/\u001a8e\u0013:4w\u000eE\u0002?\u0003?I!\u0001` \u0002!1\f7\u000f\u001e$fi\u000eDW\rZ#q_\u000eDG#\u0001,\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000eF\u0002L\u0003SAa!!\u0004\r\u0001\u00041\u0016!C3oI>3gm]3u)\t\ty\u0003E\u00024\u0003cI1!a\r5\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u000b\u0002a\u0006QAO];oG\u0006$X\rV8\u0015\t\u0005m\u0012\u0011\t\t\u0004/\u0006u\u0012bAA 1\n!QK\\5u\u0011\u0019\t\u0019e\u0004a\u0001a\u00061qN\u001a4tKR\f\u0001\u0004\u001e:v]\u000e\fG/\u001a+p\u0019\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u)\t\tI\u0005E\u0002X\u0003\u0017J1!!\u0014Y\u0005\u001d\u0011un\u001c7fC:\fQ#\u001b8ji&\fG.\u001b>f\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0002<\u0005M\u0003BBA\u0007#\u0001\u0007a+A\nva\u0012\fG/\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u0006\u0003\u0002<\u0005e\u0003bBA.%\u0001\u0007\u0011qF\u0001\u000f_\u001a47/\u001a;NKR\fG-\u0019;b\u00035A\u0017n\u001a5XCR,'/\\1sW\u0006)a\r\\;tQR\u0011\u00111H\u0001\u0012Y\u0006\u001cHO\u00127vg\",Gm\u00144gg\u0016$H#A(\u0002\u001d\r\u0014X-\u0019;f':\f\u0007o\u001d5piR!\u00111NA<!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9k\u0005A1O\\1qg\"|G/\u0003\u0003\u0002v\u0005=$!\u0005*boNs\u0017\r]:i_R<&/\u001b;fe\"1\u0011\u0011P\fA\u0002-\u000b!b\u001d8baNDw\u000e^%e\u00031\u0011X-\u00193T]\u0006\u00048\u000f[8u)\u0011\ty(a\"\u0011\t\u0019<\u0017\u0011\u0011\t\u0005\u0003[\n\u0019)\u0003\u0003\u0002\u0006\u0006=$!\u0005*boNs\u0017\r]:i_R\u0014V-\u00193fe\"1\u0011\u0011\u0010\rA\u0002-\u000b\u0001\u0003\\1uKN$8K\\1qg\"|G/\u00133\u0015\u0003\u0015\f\u0001c\u001c8T]\u0006\u00048\u000f[8u\rJ|'0\u001a8\u0015\t\u0005m\u0012\u0011\u0013\u0005\u0007\u0003sZ\u0002\u0019A&\u0002)\u0011,G.\u001a;f\u0005\u00164wN]3T]\u0006\u00048\u000f[8u)\u0011\tI%a&\t\r\u0005eE\u00041\u0001L\u0003IawnZ*uCJ$8K\\1qg\"|G/\u00133\u0002\u000b\rdwn]3\u0002!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0007CA0 '\ry\u00121\u0015\t\u0004/\u0006\u0015\u0016bAAT1\n1\u0011I\\=SK\u001a$\"!a(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001by\u000by+!-\u0002B\u0006E\u0017q\\Ar\u0011\u0015q\u0015\u00051\u0001P\u0011\u001d\t\u0019,\ta\u0001\u0003k\u000bq\u0001Z1uC\u0012K'\u000f\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tYLL\u0001\u0003S>LA!a0\u0002:\n!a)\u001b7f\u0011\u001d\t\u0019-\ta\u0001\u0003\u000b\fA\u0001^5nKB!\u0011qYAg\u001b\t\tIMC\u0002\u0002LF\u000bQ!\u001e;jYNLA!a4\u0002J\n!A+[7f\u0011\u001d\t\u0019.\ta\u0001\u0003+\f\u0011b]2iK\u0012,H.\u001a:\u0011\t\u0005]\u00171\\\u0007\u0003\u00033T1!a3'\u0013\u0011\ti.!7\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bBBAqC\u0001\u0007a+A\nnCb\u0014\u0015\r^2i'&TX-\u00138CsR,7\u000fC\u0003VC\u0001\u0007a+\u0001\tsK\u000e|g/\u001a:T]\u0006\u00048\u000f[8ugR\u00191)!;\t\u000bq\u0012\u0003\u0019A\u001f")
public final class KafkaMetadataLog
implements ReplicatedLog {
    private final Log log;
    private final ConcurrentSkipListSet<OffsetAndEpoch> snapshotIds;
    private final TopicPartition topicPartition;
    private final int maxFetchSizeInBytes;
    private Optional<OffsetAndEpoch> oldestSnapshotId;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, File file, Time time, Scheduler scheduler, int n, int n2) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, file, time, scheduler, n, n2);
    }

    @Override
    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return ReplicatedLog.super.validateOffsetAndEpoch(x$1, x$2);
    }

    @Override
    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return ReplicatedLog.super.truncateToEndOffset(x$1);
    }

    @Override
    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        Serializable serializable;
        if (((Object)((Object)Isolation.COMMITTED)).equals((Object)readIsolation)) {
            serializable = FetchHighWatermark$.MODULE$;
        } else if (((Object)((Object)Isolation.UNCOMMITTED)).equals((Object)readIsolation)) {
            serializable = FetchLogEnd$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append((Object)readIsolation).toString());
        }
        FetchDataInfo fetchInfo = this.log.read(startOffset, this.maxFetchSizeInBytes, (FetchIsolation)((Object)serializable), true);
        return new LogFetchInfo(fetchInfo.records(), new org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata(fetchInfo.fetchOffsetMetadata().messageOffset(), Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata().segmentBaseOffset(), fetchInfo.fetchOffsetMetadata().relativePositionInSegment()))));
    }

    @Override
    public LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log.appendAsLeader((MemoryRecords)records, epoch, AppendOrigin$RaftLeader$.MODULE$, this.log.appendAsLeader$default$4()));
    }

    @Override
    public LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log.appendAsFollower((MemoryRecords)records));
    }

    private LogAppendInfo handleAndConvertLogAppendInfo(kafka.log.LogAppendInfo appendInfo) {
        LogOffsetMetadata firstOffset;
        Option<LogOffsetMetadata> option = appendInfo.firstOffset();
        if (option instanceof Some) {
            firstOffset = (LogOffsetMetadata)((Some)option).value();
            if (firstOffset.relativePositionInSegment() == 0) {
                this.log.deleteOldSegments();
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
            }
            throw new MatchError(option);
        }
        LogAppendInfo logAppendInfo = new LogAppendInfo(firstOffset.messageOffset(), appendInfo.lastOffset());
        return logAppendInfo;
    }

    @Override
    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt(this.log.latestEpoch().getOrElse((JFunction0$mcI$sp & Serializable)() -> BoxesRunTime.unboxToInt(this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger(KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger(0)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option<kafka.server.OffsetAndEpoch> option;
        Option<OffsetAndEpoch> option2 = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.oldestSnapshotId));
        Option<kafka.server.OffsetAndEpoch> option3 = this.log.endOffsetForEpoch(epoch);
        Tuple2<Option<kafka.server.OffsetAndEpoch>, Option<OffsetAndEpoch>> tuple2 = new Tuple2<Option<kafka.server.OffsetAndEpoch>, Option<OffsetAndEpoch>>(option3, option2);
        Option<kafka.server.OffsetAndEpoch> option4 = option3;
        Option<OffsetAndEpoch> option5 = option2;
        if (option4 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option4).value();
            if (option5 instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option5).value();
                if (offsetAndEpoch.offset() == snapshotId.offset && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
                }
            }
        }
        if ((option = option3) instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Option<kafka.server.OffsetAndEpoch> option6 = option3;
        if (!None$.MODULE$.equals(option6)) throw new MatchError(tuple2);
        return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
    }

    @Override
    public org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata endOffset() {
        LogOffsetMetadata endOffsetMetadata = this.log.logEndOffsetMetadata();
        return new org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata(endOffsetMetadata.messageOffset(), Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset(), endOffsetMetadata.relativePositionInSegment())));
    }

    @Override
    public long startOffset() {
        return this.log.logStartOffset();
    }

    @Override
    public void truncateTo(long offset) {
        this.log.truncateTo(offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean truncateToLatestSnapshot() {
        int latestEpoch = BoxesRunTime.unboxToInt(this.log.latestEpoch().getOrElse((JFunction0$mcI$sp & Serializable)() -> 0));
        Option<OffsetAndEpoch> option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(option instanceof Some)) return false;
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
        if (snapshotId.epoch <= latestEpoch) {
            if (snapshotId.epoch != latestEpoch) return false;
            if (snapshotId.offset <= this.endOffset().offset) return false;
        }
        this.log.truncateFullyAndStartAt(snapshotId.offset);
        this.oldestSnapshotId = this.latestSnapshotId();
        return true;
    }

    @Override
    public void initializeLeaderEpoch(int epoch) {
        this.log.maybeAssignEpochStartOffset(epoch, this.log.logEndOffset());
    }

    @Override
    public void updateHighWatermark(org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option<OffsetMetadata> option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log.updateHighWatermark(new LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log.updateHighWatermark(offsetMetadata.offset);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata highWatermark() {
        void var2_2;
        LogOffsetSnapshot logOffsetSnapshot = this.log.fetchOffsetSnapshot();
        if (logOffsetSnapshot == null) {
            throw new MatchError((Object)null);
        }
        LogOffsetMetadata hwm = logOffsetSnapshot.highWatermark();
        Optional<OffsetMetadata> segmentPosition = var2_2.messageOffsetOnly() ? Optional.of(new SegmentPosition(var2_2.segmentBaseOffset(), var2_2.relativePositionInSegment())) : Optional.empty();
        return new org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata(var2_2.messageOffset(), segmentPosition);
    }

    @Override
    public void flush() {
        this.log.flush();
    }

    @Override
    public long lastFlushedOffset() {
        return this.log.recoveryPoint();
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public RawSnapshotWriter createSnapshot(OffsetAndEpoch snapshotId) {
        this.latestSnapshotId().ifPresent(latest -> {
            if (latest.epoch > snapshotId$1.epoch || latest.offset > snapshotId$1.offset) {
                throw new IllegalArgumentException(new StringBuilder(81).append("Attemting to create a snapshot (").append(snapshotId).append(") that is not greater than the latest snapshot (").append(latest).append(")").toString());
            }
        });
        return FileRawSnapshotWriter.create(this.log.dir().toPath(), snapshotId, Optional.of(this));
    }

    @Override
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        Optional<RawSnapshotReader> optional;
        try {
            if (!this.snapshotIds.contains(snapshotId)) {
                return Optional.empty();
            }
            optional = Optional.of(FileRawSnapshotReader.open(this.log.dir().toPath(), snapshotId));
        }
        catch (NoSuchFileException noSuchFileException) {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<OffsetAndEpoch> latestSnapshotId() {
        try {
            return Optional.of(this.snapshotIds.last());
        }
        catch (NoSuchElementException noSuchElementException) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<OffsetAndEpoch> oldestSnapshotId() {
        return this.oldestSnapshotId;
    }

    @Override
    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        this.snapshotIds.add(snapshotId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteBeforeSnapshot(OffsetAndEpoch logStartSnapshotId) {
        Option<OffsetAndEpoch> option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(option instanceof Some)) return false;
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
        if (!this.snapshotIds.contains(logStartSnapshotId)) return false;
        if (this.startOffset() >= logStartSnapshotId.offset) return false;
        if (logStartSnapshotId.offset > snapshotId.offset) return false;
        if (!this.log.maybeIncrementLogStartOffset(logStartSnapshotId.offset, SnapshotGenerated$.MODULE$)) return false;
        this.log.deleteOldSegments();
        this.oldestSnapshotId = Optional.of(logStartSnapshotId);
        return true;
    }

    @Override
    public void close() {
        this.log.close();
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset == $this.startOffset() && snapshotId.offset == logEndOffset) {
            return snapshotId.epoch;
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public KafkaMetadataLog(Log log, ConcurrentSkipListSet<OffsetAndEpoch> snapshotIds, TopicPartition topicPartition, int maxFetchSizeInBytes) {
        this.log = log;
        this.snapshotIds = snapshotIds;
        this.topicPartition = topicPartition;
        this.maxFetchSizeInBytes = maxFetchSizeInBytes;
        this.oldestSnapshotId = snapshotIds.stream().filter(x$1 -> x$1.offset == this.startOffset()).findAny();
    }
}

