/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.JmxReporter;
import java.util.function.Predicate;

public class FilteringJmxReporter
extends JmxReporter {
    private volatile Predicate<MetricName> metricPredicate;

    public FilteringJmxReporter(MetricsRegistry registry, Predicate<MetricName> metricPredicate) {
        super(registry);
        this.metricPredicate = metricPredicate;
    }

    @Override
    public void onMetricAdded(MetricName name, Metric metric) {
        if (this.metricPredicate.test(name)) {
            super.onMetricAdded(name, metric);
        }
    }

    @Override
    public void onMetricRemoved(MetricName name) {
        super.onMetricRemoved(name);
    }

    public void updatePredicate(Predicate<MetricName> predicate) {
        this.metricPredicate = predicate;
        this.getMetricsRegistry().allMetrics().forEach((name, metric) -> {
            if (this.metricPredicate.test((MetricName)name)) {
                super.onMetricAdded((MetricName)name, (Metric)metric);
            } else {
                super.onMetricRemoved((MetricName)name);
            }
        });
    }
}

