/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.common.KafkaException;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1$mcVJ$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u000f\u001f\u0001\rB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001BA\u0002\u0013%q\u0007\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u0011!9\u0005A!A!B\u0013A\u0004\"\u0002'\u0001\t\u0003i\u0005b\u0002*\u0001\u0001\u0004%Ia\u0015\u0005\b?\u0002\u0001\r\u0011\"\u0003a\u0011\u0019\u0011\u0007\u0001)Q\u0005)\"9A\r\u0001a\u0001\n\u0013)\u0007bB4\u0001\u0001\u0004%I\u0001\u001b\u0005\u0007U\u0002\u0001\u000b\u0015\u00024\t\u000b-\u0004A\u0011\u00017\t\u000bI\u0004A\u0011A:\t\u000bQ\u0004A\u0011A\u001c\t\u000bU\u0004A\u0011\u0001<\t\u000be\u0004A\u0011\u0001>\t\u000by\u0004A\u0011B@\t\r\u0005\u0005\u0001\u0001\"\u0003\u0000\u0011\u0019\t\u0019\u0001\u0001C\u0001g\"1\u0011Q\u0001\u0001\u0005\u0002MDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013%\u00111\u000b\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBa!!\"\u0001\t\u0003\u0019(\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0015\ty\u0002%A\u0002m_\u001eT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\u0002\u0013!B;uS2\u001c\u0018BA\u0018-\u0005\u001daunZ4j]\u001e\f1b\u001d;beR|eMZ:fiV\t!\u0007\u0005\u0002&g%\u0011AG\n\u0002\u0005\u0019>tw-\u0001\u0007ti\u0006\u0014Ho\u00144gg\u0016$\b%A\u0003`M&dW-F\u00019!\tId(D\u0001;\u0015\tYD(\u0001\u0002j_*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\u00111\u0015\u000e\\3\u0002\u0013}3\u0017\u000e\\3`I\u0015\fHC\u0001\"F!\t)3)\u0003\u0002EM\t!QK\\5u\u0011\u001d1E!!AA\u0002a\n1\u0001\u001f\u00132\u0003\u0019yf-\u001b7fA!\u0012Q!\u0013\t\u0003K)K!a\u0013\u0014\u0003\u0011Y|G.\u0019;jY\u0016\fa\u0001P5oSRtDc\u0001(Q#B\u0011q\nA\u0007\u0002=!)\u0001G\u0002a\u0001e!)aG\u0002a\u0001q\u0005aQ.Y=cK\u000eC\u0017M\u001c8fYV\tA\u000bE\u0002&+^K!A\u0016\u0014\u0003\r=\u0003H/[8o!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0005dQ\u0006tg.\u001a7t\u0015\taF(A\u0002oS>L!AX-\u0003\u0017\u0019KG.Z\"iC:tW\r\\\u0001\u0011[\u0006L(-Z\"iC:tW\r\\0%KF$\"AQ1\t\u000f\u0019C\u0011\u0011!a\u0001)\u0006iQ.Y=cK\u000eC\u0017M\u001c8fY\u0002B#!C%\u0002\u00151\f7\u000f^(gMN,G/F\u0001g!\r)SKM\u0001\u000fY\u0006\u001cHo\u00144gg\u0016$x\fJ3r)\t\u0011\u0015\u000eC\u0004G\u0017\u0005\u0005\t\u0019\u00014\u0002\u00171\f7\u000f^(gMN,G\u000fI\u0001\u0007CB\u0004XM\u001c3\u0015\u0005\tk\u0007\"\u00028\u000e\u0001\u0004y\u0017AC1c_J$X\r\u001a+y]B\u0011q\n]\u0005\u0003cz\u0011!\"\u00112peR,G\r\u0016=o\u0003\u00151G.^:i)\u0005\u0011\u0015\u0001\u00024jY\u0016\fq\"\u001e9eCR,\u0007+\u0019:f]R$\u0015N\u001d\u000b\u0003\u0005^DQ\u0001\u001f\tA\u0002a\n\u0011\u0002]1sK:$H)\u001b:\u0002\u001d\u0011,G.\u001a;f\u0013\u001a,\u00050[:ugR\t1\u0010\u0005\u0002&y&\u0011QP\n\u0002\b\u0005>|G.Z1o\u0003\u001d\u0019\u0007.\u00198oK2$\u0012aV\u0001\f_B,gn\u00115b]:,G.A\u0003sKN,G/A\u0003dY>\u001cX-\u0001\u0005sK:\fW.\u001a+p)\r\u0011\u00151\u0002\u0005\u0007\u0003\u001b1\u0002\u0019\u0001\u001d\u0002\u0003\u0019\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\r\u0011\u00151\u0003\u0005\u0007\u0003+9\u0002\u0019\u0001\u001a\u0002\r=4gm]3u\u0003!IG/\u001a:bi>\u0014H\u0003BA\u000e\u0003\u007f\u0001b!!\b\u0002.\u0005Mb\u0002BA\u0010\u0003SqA!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K\u0011\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\r\tYCJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty#!\r\u0003\u0011%#XM]1u_JT1!a\u000b'!\u0019)\u0013QG8\u0002:%\u0019\u0011q\u0007\u0014\u0003\rQ+\b\u000f\\33!\r)\u00131H\u0005\u0004\u0003{1#aA%oi\"I\u0011\u0011\t\r\u0011\u0002\u0003\u0007\u00111I\u0001\tC2dwnY1uKB)Q%!\u0012\u0002J%\u0019\u0011q\t\u0014\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA&\u0003\u001bj\u0011aW\u0005\u0004\u0003\u001fZ&A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006\u0011\u0012\u000e^3sCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t)F\u000b\u0003\u0002D\u0005]3FAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rd%\u0001\u0006b]:|G/\u0019;j_:LA!a\u001a\u0002^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\u0005dG.\u00112peR,G\r\u0016=ogV\u0011\u0011Q\u000e\t\u0006\u0003;\tyg\\\u0005\u0005\u0003c\n\tD\u0001\u0003MSN$\u0018AE2pY2,7\r^!c_J$X\r\u001a+y]N$b!a\u001e\u0002~\u0005\u0005\u0005cA(\u0002z%\u0019\u00111\u0010\u0010\u0003)QCh.\u00138eKb\u001cV-\u0019:dQJ+7/\u001e7u\u0011\u0019\tyh\u0007a\u0001e\u0005Ya-\u001a;dQ>3gm]3u\u0011\u0019\t\u0019i\u0007a\u0001e\u0005\u0001R\u000f\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r^\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eK\u0002\u0001\u0003\u0013\u00032aKAF\u0013\r\ti\t\f\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class TransactionIndex
implements Logging {
    private final long startOffset;
    private volatile File _file;
    private volatile Option<FileChannel> maybeChannel;
    private Option<Object> lastOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public long startOffset() {
        return this.startOffset;
    }

    private File _file() {
        return this._file;
    }

    private void _file_$eq(File x$1) {
        this._file = x$1;
    }

    private Option<FileChannel> maybeChannel() {
        return this.maybeChannel;
    }

    private void maybeChannel_$eq(Option<FileChannel> x$1) {
        this.maybeChannel = x$1;
    }

    private Option<Object> lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(Option<Object> x$1) {
        this.lastOffset = x$1;
    }

    public void append(AbortedTxn abortedTxn) {
        this.lastOffset().foreach((JFunction1$mcVJ$sp & scala.Serializable)offset -> {
            if (offset >= abortedTxn.lastOffset()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(124).append("The last offset of appended transactions must increase sequentially, but ").append(abortedTxn.lastOffset()).append(" is not greater than current last offset ").append(offset).append(" of index ").append(this.file().getAbsolutePath()).toString());
            }
        });
        this.lastOffset_$eq(new Some<Object>(BoxesRunTime.boxToLong(abortedTxn.lastOffset())));
        Utils.writeFully(this.channel(), abortedTxn.buffer().duplicate());
    }

    public void flush() {
        this.maybeChannel().foreach((Function1<FileChannel, Object> & Serializable & scala.Serializable)x$1 -> {
            x$1.force(true);
            return BoxedUnit.UNIT;
        });
    }

    public File file() {
        return this._file();
    }

    public void updateParentDir(File parentDir) {
        this._file_$eq(new File(parentDir, this.file().getName()));
    }

    public boolean deleteIfExists() {
        this.close();
        return Files.deleteIfExists(this.file().toPath());
    }

    private FileChannel channel() {
        FileChannel fileChannel;
        Option<FileChannel> option = this.maybeChannel();
        if (option instanceof Some) {
            fileChannel = (FileChannel)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            fileChannel = this.openChannel();
        } else {
            throw new MatchError(option);
        }
        return fileChannel;
    }

    /*
     * WARNING - void declaration
     */
    private FileChannel openChannel() {
        void var1_1;
        FileChannel channel = FileChannel.open(this.file().toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.maybeChannel_$eq(new Some<FileChannel>(channel));
        channel.position(channel.size());
        return var1_1;
    }

    public void reset() {
        this.maybeChannel().foreach((Function1<FileChannel, FileChannel> & Serializable & scala.Serializable)x$2 -> x$2.truncate(0L));
        this.lastOffset_$eq(None$.MODULE$);
    }

    public void close() {
        this.maybeChannel().foreach((Function1<FileChannel, Object> & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.maybeChannel_$eq(None$.MODULE$);
    }

    public void renameTo(File f) {
        try {
            if (this.file().exists()) {
                Utils.atomicMoveWithFallback(this.file().toPath(), f.toPath());
            }
        }
        finally {
            this._file_$eq(f);
        }
    }

    public void truncateTo(long offset) {
        Object object = new Object();
        try {
            Iterator<Tuple2<AbortedTxn, Object>> iterator;
            ByteBuffer buffer = ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
            ObjectRef<None$> newLastOffset = ObjectRef.create(None$.MODULE$);
            Function0<ByteBuffer> & Serializable & scala.Serializable iterator_allocate = (Function0<ByteBuffer> & Serializable & scala.Serializable)() -> buffer;
            Option<FileChannel> option = this.maybeChannel();
            if (None$.MODULE$.equals(option)) {
                iterator = package$.MODULE$.Iterator().empty();
            } else if (option instanceof Some) {
                FileChannel iterator_channel = (FileChannel)((Some)option).value();
                IntRef iterator_position = IntRef.create(0);
                iterator = new Iterator<Tuple2<AbortedTxn, Object>>(this, iterator_channel, iterator_position, (Function0)iterator_allocate){
                    private final /* synthetic */ TransactionIndex $outer;
                    private final FileChannel channel$1;
                    private final IntRef position$1;
                    private final Function0 allocate$1;

                    public Iterator<Tuple2<AbortedTxn, Object>> seq() {
                        return Iterator.seq$(this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$(this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$(this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$(this);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> take(int n) {
                        return Iterator.take$(this, n);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> drop(int n) {
                        return Iterator.drop$(this, n);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> slice(int from, int until) {
                        return Iterator.slice$(this, from, until);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$(this, from, until);
                    }

                    public <B> Iterator<B> map(Function1<Tuple2<AbortedTxn, Object>, B> f) {
                        return Iterator.map$(this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$(this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<Tuple2<AbortedTxn, Object>, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$(this, f);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> filter(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.filter$(this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<AbortedTxn, Object>, B, Object> p) {
                        return Iterator.corresponds$(this, that, p);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> withFilter(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.withFilter$(this, p);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> filterNot(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.filterNot$(this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<Tuple2<AbortedTxn, Object>, B> pf) {
                        return Iterator.collect$(this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return Iterator.scanLeft$(this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return Iterator.scanRight$(this, z, op);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> takeWhile(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.takeWhile$(this, p);
                    }

                    public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> partition(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.partition$(this, p);
                    }

                    public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> span(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.span$(this, p);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> dropWhile(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.dropWhile$(this, p);
                    }

                    public <B> Iterator<Tuple2<Tuple2<AbortedTxn, Object>, B>> zip(Iterator<B> that) {
                        return Iterator.zip$(this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$(this, len, elem);
                    }

                    public Iterator<Tuple2<Tuple2<AbortedTxn, Object>, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$(this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$(this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<Tuple2<AbortedTxn, Object>, U> f) {
                        Iterator.foreach$(this, f);
                    }

                    public boolean forall(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.forall$(this, p);
                    }

                    public boolean exists(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.exists$(this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$(this, elem);
                    }

                    public Option<Tuple2<AbortedTxn, Object>> find(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.find$(this, p);
                    }

                    public int indexWhere(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.indexWhere$(this, p);
                    }

                    public int indexWhere(Function1<Tuple2<AbortedTxn, Object>, Object> p, int from) {
                        return Iterator.indexWhere$(this, p, from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$(this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$(this, elem, from);
                    }

                    public BufferedIterator<Tuple2<AbortedTxn, Object>> buffered() {
                        return Iterator.buffered$(this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$(this, size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$(this, size, step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$(this);
                    }

                    public int length() {
                        return Iterator.length$(this);
                    }

                    public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> duplicate() {
                        return Iterator.duplicate$(this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$(this, from, patchElems, replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$(this, xs, start, len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$(this, that);
                    }

                    public Traversable<Tuple2<AbortedTxn, Object>> toTraversable() {
                        return Iterator.toTraversable$(this);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> toIterator() {
                        return Iterator.toIterator$(this);
                    }

                    public Stream<Tuple2<AbortedTxn, Object>> toStream() {
                        return Iterator.toStream$(this);
                    }

                    public String toString() {
                        return Iterator.toString$(this);
                    }

                    public List<Tuple2<AbortedTxn, Object>> reversed() {
                        return TraversableOnce.reversed$(this);
                    }

                    public int size() {
                        return TraversableOnce.size$(this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$(this);
                    }

                    public int count(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return TraversableOnce.count$(this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<Tuple2<AbortedTxn, Object>, B> pf) {
                        return TraversableOnce.collectFirst$(this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return (B)TraversableOnce.$div$colon$(this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$(this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return (B)TraversableOnce.foldLeft$(this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return (B)TraversableOnce.foldRight$(this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return (B)TraversableOnce.reduceLeft$(this, op);
                    }

                    public <B> B reduceRight(Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return (B)TraversableOnce.reduceRight$(this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return TraversableOnce.reduceLeftOption$(this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return TraversableOnce.reduceRightOption$(this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$(this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$(this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$(this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<AbortedTxn, Object>, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$(this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$(this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$(this, cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$(this, cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$(this, f, cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$(this, f, cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$(this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$(this, xs, start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$(this, xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$(this, evidence$1);
                    }

                    public List<Tuple2<AbortedTxn, Object>> toList() {
                        return TraversableOnce.toList$(this);
                    }

                    public Iterable<Tuple2<AbortedTxn, Object>> toIterable() {
                        return TraversableOnce.toIterable$(this);
                    }

                    public Seq<Tuple2<AbortedTxn, Object>> toSeq() {
                        return TraversableOnce.toSeq$(this);
                    }

                    public IndexedSeq<Tuple2<AbortedTxn, Object>> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$(this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$(this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$(this);
                    }

                    public Vector<Tuple2<AbortedTxn, Object>> toVector() {
                        return TraversableOnce.toVector$(this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<AbortedTxn, Object>, Col> cbf) {
                        return (Col)TraversableOnce.to$(this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Tuple2<AbortedTxn, Object>, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$(this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$(this, start, sep, end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$(this, sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$(this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$(this, b, start, sep, end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$(this, b, sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$(this, b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$(this);
                    }

                    public boolean hasNext() {
                        return this.channel$1.position() - (long)this.position$1.elem >= (long)AbortedTxn$.MODULE$.TotalSize();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Tuple2<AbortedTxn, Object> next() {
                        try {
                            void var3_3;
                            ByteBuffer buffer = (ByteBuffer)this.allocate$1.apply();
                            Utils.readFully(this.channel$1, buffer, this.position$1.elem);
                            buffer.flip();
                            AbortedTxn abortedTxn = new AbortedTxn(buffer);
                            if (abortedTxn.version() > AbortedTxn$.MODULE$.CurrentVersion()) {
                                throw new KafkaException(new java.lang.StringBuilder(82).append("Unexpected aborted transaction version ").append(abortedTxn.version()).append(" ").append("in transaction index ").append(this.$outer.file().getAbsolutePath()).append(", current version is ").append(AbortedTxn$.MODULE$.CurrentVersion()).toString());
                            }
                            Tuple2<AbortedTxn, Integer> nextEntry = new Tuple2<AbortedTxn, Integer>(abortedTxn, BoxesRunTime.boxToInteger(this.position$1.elem));
                            this.position$1.elem += AbortedTxn$.MODULE$.TotalSize();
                            return var3_3;
                        }
                        catch (IOException e) {
                            throw new KafkaException(new java.lang.StringBuilder(42).append("Failed to read from the transaction index ").append(this.$outer.file().getAbsolutePath()).toString(), e);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.channel$1 = channel$1;
                        this.position$1 = position$1;
                        this.allocate$1 = allocate$1;
                        GenTraversableOnce.$init$(this);
                        TraversableOnce.$init$(this);
                        Iterator.$init$(this);
                    }
                };
            } else {
                throw new MatchError(option);
            }
            iterator.withFilter((Function1<Nothing$, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$1 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> {
                TransactionIndex.$anonfun$truncateTo$3(this, offset, newLastOffset, object, x$4);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private Iterator<Tuple2<AbortedTxn, Object>> iterator(Function0<ByteBuffer> allocate) {
        Iterator<Tuple2<AbortedTxn, Object>> iterator;
        Option<FileChannel> option = this.maybeChannel();
        if (None$.MODULE$.equals(option)) {
            iterator = package$.MODULE$.Iterator().empty();
        } else if (option instanceof Some) {
            FileChannel channel = (FileChannel)((Some)option).value();
            IntRef position = IntRef.create(0);
            iterator = new /* invalid duplicate definition of identical inner class */;
        } else {
            throw new MatchError(option);
        }
        return iterator;
    }

    private Function0<ByteBuffer> iterator$default$1() {
        return (Function0<ByteBuffer> & Serializable & scala.Serializable)() -> ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
    }

    public List<AbortedTxn> allAbortedTxns() {
        return this.iterator(this.iterator$default$1()).map((Function1<Tuple2, AbortedTxn> & Serializable & scala.Serializable)x$5 -> (AbortedTxn)x$5._1()).toList();
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        Object object = new Object();
        try {
            ListBuffer abortedTransactions = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.iterator(this.iterator$default$1()).withFilter((Function1<Tuple2<AbortedTxn, Object>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$2 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$6 -> {
                TransactionIndex.$anonfun$collectAbortedTxns$2(fetchOffset, upperBoundOffset, abortedTransactions, object, x$6);
                return BoxedUnit.UNIT;
            });
            return new TxnIndexSearchResult(abortedTransactions.toList(), false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (TxnIndexSearchResult)ex.value();
            }
            throw ex;
        }
    }

    public void sanityCheck() {
        Iterator<Tuple2<AbortedTxn, Object>> iterator;
        Function0<ByteBuffer> & Serializable & scala.Serializable iterator_allocate = () -> TransactionIndex.$anonfun$sanityCheck$1(ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize()));
        Option<FileChannel> option = this.maybeChannel();
        if (None$.MODULE$.equals(option)) {
            iterator = package$.MODULE$.Iterator().empty();
        } else if (option instanceof Some) {
            FileChannel iterator_channel = (FileChannel)((Some)option).value();
            IntRef iterator_position = IntRef.create(0);
            iterator = new /* invalid duplicate definition of identical inner class */;
        } else {
            throw new MatchError(option);
        }
        iterator.withFilter((Function1<Nothing$, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$3 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$7 -> {
            TransactionIndex.$anonfun$sanityCheck$3(this, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$truncateTo$3(TransactionIndex $this, long offset$1, ObjectRef newLastOffset$1, Object nonLocalReturnKey1$1, Tuple2 x$4) {
        if (x$4 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)x$4._1();
            int position = x$4._2$mcI$sp();
            if (abortedTxn.lastOffset() >= offset$1) {
                $this.channel().truncate(position);
                $this.lastOffset_$eq((Option)newLastOffset$1.elem);
                throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            newLastOffset$1.elem = new Some<Long>(BoxesRunTime.boxToLong(abortedTxn.lastOffset()));
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$collectAbortedTxns$2(long fetchOffset$1, long upperBoundOffset$1, ListBuffer abortedTransactions$1, Object nonLocalReturnKey2$1, Tuple2 x$6) {
        if (x$6 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)x$6._1();
            if (abortedTxn.lastOffset() >= fetchOffset$1 && abortedTxn.firstOffset() < upperBoundOffset$1) {
                abortedTransactions$1.$plus$eq(abortedTxn);
            }
            if (abortedTxn.lastStableOffset() >= upperBoundOffset$1) {
                throw new NonLocalReturnControl<TxnIndexSearchResult>(nonLocalReturnKey2$1, new TxnIndexSearchResult(abortedTransactions$1.toList(), true));
            }
        } else {
            throw new MatchError((Object)null);
        }
    }

    public static final /* synthetic */ ByteBuffer $anonfun$sanityCheck$1(ByteBuffer buffer$2) {
        return buffer$2;
    }

    public static final /* synthetic */ void $anonfun$sanityCheck$3(TransactionIndex $this, Tuple2 x$7) {
        if (x$7 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)x$7._1();
            if (abortedTxn.lastOffset() < $this.startOffset()) {
                throw new CorruptIndexException(new java.lang.StringBuilder(72).append("Last offset of aborted transaction ").append(abortedTxn).append(" in index ").append($this.file().getAbsolutePath()).append(" is less than start offset ").append($this.startOffset()).toString());
            }
        } else {
            throw new MatchError((Object)null);
        }
    }

    public TransactionIndex(long startOffset, File _file) {
        this.startOffset = startOffset;
        this._file = _file;
        Logging.$init$(this);
        this.maybeChannel = None$.MODULE$;
        this.lastOffset = None$.MODULE$;
        if (this._file().exists()) {
            this.openChannel();
        }
    }
}

