/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerStateEntry;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Crc32C;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcJ$sp;

public final class ProducerStateManager$ {
    public static ProducerStateManager$ MODULE$;
    private final short ProducerSnapshotVersion;
    private final String VersionField;
    private final String CrcField;
    private final String ProducerIdField;
    private final String LastSequenceField;
    private final String ProducerEpochField;
    private final String LastOffsetField;
    private final String OffsetDeltaField;
    private final String TimestampField;
    private final String ProducerEntriesField;
    private final String CoordinatorEpochField;
    private final String CurrentTxnFirstOffsetField;
    private final int VersionOffset;
    private final int CrcOffset;
    private final int ProducerEntriesOffset;
    private final Schema ProducerSnapshotEntrySchema;
    private final Schema PidSnapshotMapSchema;

    static {
        new ProducerStateManager$();
    }

    public int $lessinit$greater$default$3() {
        return 3600000;
    }

    private short ProducerSnapshotVersion() {
        return this.ProducerSnapshotVersion;
    }

    private String VersionField() {
        return this.VersionField;
    }

    private String CrcField() {
        return this.CrcField;
    }

    private String ProducerIdField() {
        return this.ProducerIdField;
    }

    private String LastSequenceField() {
        return this.LastSequenceField;
    }

    private String ProducerEpochField() {
        return this.ProducerEpochField;
    }

    private String LastOffsetField() {
        return this.LastOffsetField;
    }

    private String OffsetDeltaField() {
        return this.OffsetDeltaField;
    }

    private String TimestampField() {
        return this.TimestampField;
    }

    private String ProducerEntriesField() {
        return this.ProducerEntriesField;
    }

    private String CoordinatorEpochField() {
        return this.CoordinatorEpochField;
    }

    private String CurrentTxnFirstOffsetField() {
        return this.CurrentTxnFirstOffsetField;
    }

    private int VersionOffset() {
        return this.VersionOffset;
    }

    private int CrcOffset() {
        return this.CrcOffset;
    }

    private int ProducerEntriesOffset() {
        return this.ProducerEntriesOffset;
    }

    public Schema ProducerSnapshotEntrySchema() {
        return this.ProducerSnapshotEntrySchema;
    }

    public Schema PidSnapshotMapSchema() {
        return this.PidSnapshotMapSchema;
    }

    public Iterable<ProducerStateEntry> readSnapshot(File file) {
        try {
            long computedCrc;
            byte[] buffer = Files.readAllBytes(file.toPath());
            Struct struct = this.PidSnapshotMapSchema().read(ByteBuffer.wrap(buffer));
            Short version = struct.getShort(this.VersionField());
            if (!BoxesRunTime.equalsNumObject(version, BoxesRunTime.boxToShort(this.ProducerSnapshotVersion()))) {
                throw new CorruptSnapshotException(new StringBuilder(43).append("Snapshot contained an unknown file version ").append(version).toString());
            }
            Long crc = struct.getUnsignedInt(this.CrcField());
            if (!BoxesRunTime.equalsNumObject(crc, BoxesRunTime.boxToLong(computedCrc = Crc32C.compute(buffer, this.ProducerEntriesOffset(), buffer.length - this.ProducerEntriesOffset())))) {
                throw new CorruptSnapshotException(new StringBuilder(74).append("Snapshot is corrupt (CRC is no longer valid). ").append("Stored crc: ").append(crc).append(". Computed crc: ").append(computedCrc).toString());
            }
            return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(struct.getArray(this.ProducerEntriesField()))).map((Function1<Object, ProducerStateEntry> & Serializable & scala.Serializable)producerEntryObj -> {
                Struct producerEntryStruct = (Struct)producerEntryObj;
                Long producerId = producerEntryStruct.getLong(MODULE$.ProducerIdField());
                Short producerEpoch = producerEntryStruct.getShort(MODULE$.ProducerEpochField());
                Integer seq = producerEntryStruct.getInt(MODULE$.LastSequenceField());
                Long offset = producerEntryStruct.getLong(MODULE$.LastOffsetField());
                Long timestamp = producerEntryStruct.getLong(MODULE$.TimestampField());
                Integer offsetDelta = producerEntryStruct.getInt(MODULE$.OffsetDeltaField());
                Integer coordinatorEpoch = producerEntryStruct.getInt(MODULE$.CoordinatorEpochField());
                Long currentTxnFirstOffset = producerEntryStruct.getLong(MODULE$.CurrentTxnFirstOffsetField());
                Queue lastAppendedDataBatches = (Queue)Queue$.MODULE$.empty();
                if (Predef$.MODULE$.Long2long(offset) >= 0L) {
                    lastAppendedDataBatches.$plus$eq(new BatchMetadata(Predef$.MODULE$.Integer2int(seq), Predef$.MODULE$.Long2long(offset), Predef$.MODULE$.Integer2int(offsetDelta), Predef$.MODULE$.Long2long(timestamp)));
                }
                return new ProducerStateEntry(Predef$.MODULE$.Long2long(producerId), lastAppendedDataBatches, Predef$.MODULE$.Short2short(producerEpoch), Predef$.MODULE$.Integer2int(coordinatorEpoch), Predef$.MODULE$.Long2long(timestamp), Predef$.MODULE$.Long2long(currentTxnFirstOffset) >= 0L ? new Some<Long>(BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(currentTxnFirstOffset))) : None$.MODULE$);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (SchemaException e) {
            throw new CorruptSnapshotException(new StringBuilder(35).append("Snapshot failed schema validation: ").append(e.getMessage()).toString());
        }
    }

    public void kafka$log$ProducerStateManager$$writeSnapshot(File file, Map<Object, ProducerStateEntry> entries) {
        Struct struct = new Struct(this.PidSnapshotMapSchema());
        struct.set(this.VersionField(), (Object)BoxesRunTime.boxToShort(this.ProducerSnapshotVersion()));
        struct.set(this.CrcField(), (Object)BoxesRunTime.boxToLong(0L));
        Struct[] entriesArray = (Struct[])((TraversableOnce)entries.map((Function1<Tuple2, Struct> & Serializable & scala.Serializable)x0$1 -> {
            void var5_4;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            long producerId = x0$1._1$mcJ$sp();
            ProducerStateEntry entry = (ProducerStateEntry)x0$1._2();
            Struct producerEntryStruct = struct.instance(MODULE$.ProducerEntriesField());
            producerEntryStruct.set(MODULE$.ProducerIdField(), (Object)BoxesRunTime.boxToLong(producerId)).set(MODULE$.ProducerEpochField(), (Object)BoxesRunTime.boxToShort(entry.producerEpoch())).set(MODULE$.LastSequenceField(), (Object)BoxesRunTime.boxToInteger(entry.lastSeq())).set(MODULE$.LastOffsetField(), (Object)BoxesRunTime.boxToLong(entry.lastDataOffset())).set(MODULE$.OffsetDeltaField(), (Object)BoxesRunTime.boxToInteger(entry.lastOffsetDelta())).set(MODULE$.TimestampField(), (Object)BoxesRunTime.boxToLong(entry.lastTimestamp())).set(MODULE$.CoordinatorEpochField(), (Object)BoxesRunTime.boxToInteger(entry.coordinatorEpoch())).set(MODULE$.CurrentTxnFirstOffsetField(), entry.currentTxnFirstOffset().getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
            return var5_4;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Struct.class));
        struct.set(this.ProducerEntriesField(), (Object)entriesArray);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        long crc = Crc32C.compute(buffer, this.ProducerEntriesOffset(), buffer.limit() - this.ProducerEntriesOffset());
        ByteUtils.writeUnsignedInt(buffer, this.CrcOffset(), crc);
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileChannel.write(buffer);
            fileChannel.force(true);
        }
    }

    private boolean isSnapshotFile(File file) {
        return file.getName().endsWith(Log$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public Seq<SnapshotFile> listSnapshotFiles(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            return (Seq)Option$.MODULE$.apply(dir.listFiles()).map((Function1<File[], Seq> & Serializable & scala.Serializable)files -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(ProducerStateManager$.$anonfun$listSnapshotFiles$2(f))))).map((Function1<File, SnapshotFile> & Serializable & scala.Serializable)x$1 -> SnapshotFile$.MODULE$.apply((File)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SnapshotFile.class))))).toSeq()).getOrElse((Function0<Seq> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$listSnapshotFiles$2(File f) {
        return f.isFile() && MODULE$.isSnapshotFile(f);
    }

    private ProducerStateManager$() {
        MODULE$ = this;
        this.ProducerSnapshotVersion = 1;
        this.VersionField = "version";
        this.CrcField = "crc";
        this.ProducerIdField = "producer_id";
        this.LastSequenceField = "last_sequence";
        this.ProducerEpochField = "epoch";
        this.LastOffsetField = "last_offset";
        this.OffsetDeltaField = "offset_delta";
        this.TimestampField = "timestamp";
        this.ProducerEntriesField = "producer_entries";
        this.CoordinatorEpochField = "coordinator_epoch";
        this.CurrentTxnFirstOffsetField = "current_txn_first_offset";
        this.VersionOffset = 0;
        this.CrcOffset = this.VersionOffset() + 2;
        this.ProducerEntriesOffset = this.CrcOffset() + 4;
        this.ProducerSnapshotEntrySchema = new Schema(new Field(this.ProducerIdField(), Type.INT64, "The producer ID"), new Field(this.ProducerEpochField(), Type.INT16, "Current epoch of the producer"), new Field(this.LastSequenceField(), Type.INT32, "Last written sequence of the producer"), new Field(this.LastOffsetField(), Type.INT64, "Last written offset of the producer"), new Field(this.OffsetDeltaField(), Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field(this.TimestampField(), Type.INT64, "Max timestamp from the last written entry"), new Field(this.CoordinatorEpochField(), Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field(this.CurrentTxnFirstOffsetField(), Type.INT64, "The first offset of the on-going transaction (-1 if there is none)"));
        this.PidSnapshotMapSchema = new Schema(new Field(this.VersionField(), Type.INT16, "Version of the snapshot file"), new Field(this.CrcField(), Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field(this.ProducerEntriesField(), new ArrayOf(this.ProducerSnapshotEntrySchema()), "The entries in the producer table"));
    }
}

