/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.pinot.shaded.org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005utAB\u0013'\u0011\u00031#F\u0002\u0004-M!\u0005a%\f\u0005\u0006i\u0005!\tA\u000e\u0005\to\u0005\u0011\r\u0011\"\u0001'q!1A(\u0001Q\u0001\neBQ!P\u0001\u0005\u0002y2Q\u0001\f\u0014\u0001M\u0001C\u0001\"\u0011\u0004\u0003\u0006\u0004%\tA\u0011\u0005\t\r\u001a\u0011\t\u0011)A\u0005\u0007\"AqI\u0002BC\u0002\u0013\u0005\u0001\n\u0003\u0005U\r\t\u0005\t\u0015!\u0003J\u0011!)fA!a\u0001\n\u00031\u0006\u0002\u0003.\u0007\u0005\u0003\u0007I\u0011A.\t\u0011\u00054!\u0011!Q!\n]C\u0001B\u0019\u0004\u0003\u0002\u0004%\t\u0001\u000f\u0005\tG\u001a\u0011\t\u0019!C\u0001I\"AaM\u0002B\u0001B\u0003&\u0011\b\u0003\u0005h\r\t\u0005\r\u0011\"\u0001C\u0011!AgA!a\u0001\n\u0003I\u0007\u0002C6\u0007\u0005\u0003\u0005\u000b\u0015B\"\t\u001114!\u00111A\u0005\u00025D\u0001\"\u001d\u0004\u0003\u0002\u0004%\tA\u001d\u0005\ti\u001a\u0011\t\u0011)Q\u0005]\")AG\u0002C\u0001k\")AP\u0002C\u0001q!)QP\u0002C\u0001\u0005\")aP\u0002C\u0001q!)qP\u0002C\u0001\u0005\"1\u0011\u0011\u0001\u0004\u0005\u0002aBq!a\u0001\u0007\t\u0003\t)\u0001C\u0004\u0002\u000e\u0019!\t!a\u0004\t\u000f\u0005\u0005b\u0001\"\u0001\u0002$!9\u0011q\u0005\u0004\u0005\n\u0005%\u0002bBA\u0018\r\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003o1A\u0011AA\u001d\u0011\u001d\tIF\u0002C\u0001\u00037Bq!!\u0019\u0007\t\u0003\n\u0019'\u0001\nQe>$WoY3s'R\fG/Z#oiJL(BA\u0014)\u0003\rawn\u001a\u0006\u0002S\u0005)1.\u00194lCB\u00111&A\u0007\u0002M\t\u0011\u0002K]8ek\u000e,'o\u0015;bi\u0016,e\u000e\u001e:z'\t\ta\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!&\u0001\nOk6\u0014\u0015\r^2iKN$vNU3uC&tW#A\u001d\u0011\u0005=R\u0014BA\u001e1\u0005\rIe\u000e^\u0001\u0014\u001dVl')\u0019;dQ\u0016\u001cHk\u001c*fi\u0006Lg\u000eI\u0001\u0006K6\u0004H/\u001f\u000b\u0004\u007f\u0005m\u0004CA\u0016\u0007'\t1a&\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012a\u0011\t\u0003_\u0011K!!\u0012\u0019\u0003\t1{gnZ\u0001\faJ|G-^2fe&#\u0007%A\u0007cCR\u001c\u0007.T3uC\u0012\fG/Y\u000b\u0002\u0013B\u0019!jT)\u000e\u0003-S!\u0001T'\u0002\u000f5,H/\u00192mK*\u0011a\nM\u0001\u000bG>dG.Z2uS>t\u0017B\u0001)L\u0005\u0015\tV/Z;f!\tY#+\u0003\u0002TM\ti!)\u0019;dQ6+G/\u00193bi\u0006\faBY1uG\"lU\r^1eCR\f\u0007%A\u0007qe>$WoY3s\u000bB|7\r[\u000b\u0002/B\u0011q\u0006W\u0005\u00033B\u0012Qa\u00155peR\f\u0011\u0003\u001d:pIV\u001cWM]#q_\u000eDw\fJ3r)\tav\f\u0005\u00020;&\u0011a\f\r\u0002\u0005+:LG\u000fC\u0004a\u0019\u0005\u0005\t\u0019A,\u0002\u0007a$\u0013'\u0001\bqe>$WoY3s\u000bB|7\r\u001b\u0011\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0017\u0001F2p_J$\u0017N\\1u_J,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u0002]K\"9\u0001mDA\u0001\u0002\u0004I\u0014!E2p_J$\u0017N\\1u_J,\u0005o\\2iA\u0005iA.Y:u)&lWm\u001d;b[B\f\u0011\u0003\\1tiRKW.Z:uC6\u0004x\fJ3r)\ta&\u000eC\u0004a%\u0005\u0005\t\u0019A\"\u0002\u001d1\f7\u000f\u001e+j[\u0016\u001cH/Y7qA\u0005)2-\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X#\u00018\u0011\u0007=z7)\u0003\u0002qa\t1q\n\u001d;j_:\f\u0011dY;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,Go\u0018\u0013fcR\u0011Al\u001d\u0005\bAV\t\t\u00111\u0001o\u0003Y\u0019WO\u001d:f]R$\u0006P\u001c$jeN$xJ\u001a4tKR\u0004CcB wobL(p\u001f\u0005\u0006\u0003^\u0001\ra\u0011\u0005\u0006\u000f^\u0001\r!\u0013\u0005\u0006+^\u0001\ra\u0016\u0005\u0006E^\u0001\r!\u000f\u0005\u0006O^\u0001\ra\u0011\u0005\u0006Y^\u0001\rA\\\u0001\tM&\u00148\u000f^*fc\u0006ya-\u001b:ti\u0012\u000bG/Y(gMN,G/A\u0004mCN$8+Z9\u0002\u001d1\f7\u000f\u001e#bi\u0006|eMZ:fi\u0006yA.Y:u\u001f\u001a47/\u001a;EK2$\u0018-A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005\u001d\u0001cA\u0018\u0002\n%\u0019\u00111\u0002\u0019\u0003\u000f\t{w\u000e\\3b]\u0006A\u0011\r\u001a3CCR\u001c\u0007\u000eF\u0006]\u0003#\t\u0019\"!\u0006\u0002\u001a\u0005u\u0001\"B+\u001f\u0001\u00049\u0006\"\u0002@\u001f\u0001\u0004I\u0004BBA\f=\u0001\u00071)\u0001\u0006mCN$xJ\u001a4tKRDa!a\u0007\u001f\u0001\u0004I\u0014aC8gMN,G\u000fR3mi\u0006Da!a\b\u001f\u0001\u0004\u0019\u0015!\u0003;j[\u0016\u001cH/Y7q\u0003ai\u0017-\u001f2f+B$\u0017\r^3Qe>$WoY3s\u000bB|7\r\u001b\u000b\u0005\u0003\u000f\t)\u0003C\u0003V?\u0001\u0007q+\u0001\tbI\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR\u0019A,a\u000b\t\r\u00055\u0002\u00051\u0001R\u0003\u0015\u0011\u0017\r^2i\u0003\u0019)\b\u000fZ1uKR\u0019A,a\r\t\r\u0005U\u0012\u00051\u0001@\u0003%qW\r\u001f;F]R\u0014\u00180\u0001\ngS:$G)\u001e9mS\u000e\fG/\u001a\"bi\u000eDG\u0003BA\u001e\u0003{\u00012aL8R\u0011\u001d\tiC\ta\u0001\u0003\u007f\u0001B!!\u0011\u0002V5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0003\u0013\nY%\u0001\u0004d_6lwN\u001c\u0006\u0004S\u00055#\u0002BA(\u0003#\na!\u00199bG\",'BAA*\u0003\ry'oZ\u0005\u0005\u0003/\n\u0019EA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0017A\u00062bi\u000eDw+\u001b;i'\u0016\fX/\u001a8dKJ\u000bgnZ3\u0015\r\u0005m\u0012QLA0\u0011\u0015a8\u00051\u0001:\u0011\u0015q8\u00051\u0001:\u0003!!xn\u0015;sS:<GCAA3!\u0011\t9'!\u001e\u000f\t\u0005%\u0014\u0011\u000f\t\u0004\u0003W\u0002TBAA7\u0015\r\ty'N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u0002\u0004\"B!\u0006\u0001\u0004\u0019\u0005")
public class ProducerStateEntry {
    private final long producerId;
    private final Queue<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private long lastTimestamp;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long l) {
        return ProducerStateEntry$.MODULE$.empty(l);
    }

    public long producerId() {
        return this.producerId;
    }

    public Queue<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public long lastTimestamp() {
        return this.lastTimestamp;
    }

    public void lastTimestamp_$eq(long x$1) {
        this.lastTimestamp = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.batchMetadata().front().firstSeq();
    }

    public long firstDataOffset() {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.batchMetadata().front().firstOffset();
    }

    public int lastSeq() {
        if (this.isEmpty()) {
            return -1;
        }
        return ((BatchMetadata)this.batchMetadata().last()).lastSeq();
    }

    public long lastDataOffset() {
        if (this.isEmpty()) {
            return -1L;
        }
        return ((BatchMetadata)this.batchMetadata().last()).lastOffset();
    }

    public int lastOffsetDelta() {
        if (this.isEmpty()) {
            return 0;
        }
        return ((BatchMetadata)this.batchMetadata().last()).offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateProducerEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
        this.lastTimestamp_$eq(timestamp);
    }

    public boolean maybeUpdateProducerEpoch(short producerEpoch) {
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            return true;
        }
        return false;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        if (this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain()) {
            this.batchMetadata().dequeue();
        }
        this.batchMetadata().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{batch}));
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateProducerEpoch(nextEntry.producerEpoch());
        while (nextEntry.batchMetadata().nonEmpty()) {
            this.addBatchMetadata(nextEntry.batchMetadata().dequeue());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
        this.lastTimestamp_$eq(nextEntry.lastTimestamp());
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        if (batch.producerEpoch() != this.producerEpoch()) {
            return None$.MODULE$;
        }
        return this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        return ((Queue)this.batchMetadata().filter((Function1<BatchMetadata, Object> & java.io.Serializable & Serializable)metadata -> BoxesRunTime.boxToBoolean(ProducerStateEntry.$anonfun$batchWithSequenceRange$1(firstSeq, lastSeq, metadata)))).headOption();
    }

    public String toString() {
        return new StringBuilder(121).append("ProducerStateEntry(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("currentTxnFirstOffset=").append(this.currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.coordinatorEpoch()).append(", ").append("lastTimestamp=").append(this.lastTimestamp()).append(", ").append("batchMetadata=").append(this.batchMetadata()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$batchWithSequenceRange$1(int firstSeq$1, int lastSeq$1, BatchMetadata metadata) {
        return firstSeq$1 == metadata.firstSeq() && lastSeq$1 == metadata.lastSeq();
    }

    public ProducerStateEntry(long producerId, Queue<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, long lastTimestamp, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.lastTimestamp = lastTimestamp;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

