/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\t\u0013\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!A\u0004A!A!\u0002\u0013I\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002#\u0001\u0005\u0004%I!\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\t(\t\u000b\t\u0004A\u0011B2\t\u000b!\u0004A\u0011B5\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\u0012QCW6SKBd\u0017nY1Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0014)\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0015\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001&\n\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\"!G\u0016\n\u00051\u0012\"!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005ey\u0013B\u0001\u0019\u0013\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\tu.\u001cE.[3oiB\u00111GN\u0007\u0002i)\u0011Q\u0007F\u0001\u0003u.L!a\u000e\u001b\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003q\u0019wN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"!\u0007\u001e\n\u0005m\u0012\"\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u0001\u0007y%t\u0017\u000e\u001e \u0015\ryz\u0004)\u0011\"D!\tI\u0002\u0001C\u0003#\r\u0001\u00071\u0005C\u0003*\r\u0001\u0007!\u0006C\u0003.\r\u0001\u0007a\u0006C\u00032\r\u0001\u0007!\u0007C\u00039\r\u0001\u0007\u0011(\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0004\u001fJk\u0006CA$Q\u0013\t\t\u0006J\u0001\u0003V]&$\b\"B*\n\u0001\u0004!\u0016\u0001\u0003:fa2L7-Y:\u0011\u0007UC&,D\u0001W\u0015\t9\u0006*\u0001\u0006d_2dWm\u0019;j_:L!!\u0017,\u0003\u0007M+\u0017\u000f\u0005\u0002\u001a7&\u0011AL\u0005\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\u0006=&\u0001\raX\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0002\u001aA&\u0011\u0011M\u0005\u0002\r%\u0016\u0004H.[2b'R\fG/Z\u0001\u0015I>D\u0015M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\t=#gm\u001a\u0005\u0006K*\u0001\rAR\u0001\ne\u0016\u0004H.[2b\u0013\u0012DQa\u0015\u0006A\u0002QCQA\u0018\u0006A\u0002}\u000bQC]3n_Z,'+\u001a9mS\u000e\f7O\u0012:p[&\u001b(\u000fF\u0003k\u0003\u000f\tI\u0001E\u0003leV\f\tA\u0004\u0002maB\u0011Q\u000eS\u0007\u0002]*\u0011qNF\u0001\u0007yI|w\u000e\u001e \n\u0005ED\u0015A\u0002)sK\u0012,g-\u0003\u0002ti\n\u0019Q*\u00199\u000b\u0005ED\u0005C\u0001<\u007f\u001b\u00059(B\u0001=z\u0003\u0019\u0019w.\\7p]*\u0011QC\u001f\u0006\u0003wr\fa!\u00199bG\",'\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000o\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cA\r\u0002\u0004%\u0019\u0011Q\u0001\n\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u0015)7\u00021\u0001G\u0011\u001d\tYa\u0003a\u0001\u0003\u001b\t!\u0002]1si&$\u0018n\u001c8t!\r)\u0006,^\u0001\u0018I>\u0014V-\\8wKJ+\u0007\u000f\\5dCN4%o\\7JgJ$b!a\u0005\u00024\u0005U\u0002cB$\u0002\u0016\u0005e\u0011QB\u0005\u0004\u0003/A%A\u0002+va2,'\u0007E\u0003leV\fY\u0002\u0005\u0005\u0002\u001e\u0005\u001d\u0012QFA\u0001\u001d\u0011\ty\"a\t\u000f\u00075\f\t#C\u0001J\u0013\r\t)\u0003S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI#a\u000b\u0003\r\u0015KG\u000f[3s\u0015\r\t)\u0003\u0013\t\u0005\u0003;\ty#\u0003\u0003\u00022\u0005-\"!C#yG\u0016\u0004H/[8o\u0011\u0015)G\u00021\u0001G\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001b\tQdZ3u)>\u0004\u0018n\u0019)beRLG/[8o'R\fG/Z:Ge>l'l\u001b\u000b\u0005\u0003w\ti\u0005E\u0004H\u0003+\ti$!\u0004\u0011\u000b-\u0014X/a\u0010\u0011\u0011\u0005u\u0011qEA\u0017\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\"\u0012aA1qS&!\u00111JA#\u00051aU-\u00193fe\u0006sG-S:s\u0011\u001d\tY!\u0004a\u0001\u0003\u001b\tq\u0003\\8h'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8\u0015\u0017=\u000b\u0019&a\u0016\u0002Z\u0005u\u0013\u0011\r\u0005\u0007\u0003+r\u0001\u0019\u0001\u0016\u0002\r1|wmZ3s\u0011\u0015)g\u00021\u0001G\u0011\u0019\tYF\u0004a\u0001k\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\u0007\u0003?r\u0001\u0019A0\u0002\u0013\r,(O]*uCR,\u0007\"\u00020\u000f\u0001\u0004y\u0016\u0001\u00067pO&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003P\u0003O\nY\u0007\u0003\u0004\u0002j=\u0001\rAW\u0001\be\u0016\u0004H.[2b\u0011\u0015qv\u00021\u0001`\u0003Qawn\u001a$bS2,Gm\u0015;bi\u0016\u001c\u0005.\u00198hKRIq*!\u001d\u0002t\u0005U\u0014q\u000f\u0005\u0007\u0003S\u0002\u0002\u0019\u0001.\t\r\u0005}\u0003\u00031\u0001`\u0011\u0015q\u0006\u00031\u0001`\u0011\u001d\tI\b\u0005a\u0001\u0003w\n\u0011\u0001\u001e\t\u0005\u0003;\ti(\u0003\u0003\u0002\u0000\u0005-\"!\u0003+ie><\u0018M\u00197f\u0001")
public class ZkReplicaStateMachine
extends ReplicaStateMachine {
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;

    private int controllerId() {
        return this.controllerId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleStateChanges(Seq<PartitionAndReplica> replicas2, ReplicaState targetState) {
        if (replicas2.nonEmpty()) {
            try {
                void forKeyValue$extension_f;
                void forKeyValue$extension_$this;
                this.controllerBrokerRequestBatch.newBatch();
                Function2<Object, Seq, Object> & Serializable & scala.Serializable intersect = (Function2<Object, Seq, Object> & Serializable & scala.Serializable)(replicaId, replicas) -> {
                    this.doHandleStateChanges(BoxesRunTime.unboxToInt(replicaId), replicas, targetState);
                    return BoxedUnit.UNIT;
                };
                Map map = Implicits$.MODULE$.MapExtensionMethods(replicas2.groupBy((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.replica())));
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(scala.collection.compat.package$.MODULE$.toMapExtensionMethods(forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                return;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Controller moved to another broker when moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0<ControllerMovedException> & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error while moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doHandleStateChanges(int replicaId, Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        void var8_8;
        void var7_7;
        StateChangeLogger stateLogger = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        boolean traceEnabled = stateLogger.isTraceEnabled();
        replicas.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
            this.controllerContext.putReplicaStateIfNotExists(replica, NonExistentReplica$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple2 = this.controllerContext.checkValidReplicaStateChange(replicas, targetState);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<PartitionAndReplica> validReplicas = tuple2._1();
        Seq<PartitionAndReplica> invalidReplicas = tuple2._2();
        void validReplicas2 = var7_7;
        var8_8.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
            this.logInvalidTransition(replica, targetState);
            return BoxedUnit.UNIT;
        });
        if (NewReplica$.MODULE$.equals(targetState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$3(this, replicaId, traceEnabled, stateLogger, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (OnlineReplica$.MODULE$.equals(targetState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$4(this, replicaId, traceEnabled, stateLogger, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (OfflineReplica$.MODULE$.equals(targetState)) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            void var12_12;
            void var11_11;
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), replica.topicPartition(), false);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple22 = validReplicas2.partition((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean(ZkReplicaStateMachine.$anonfun$doHandleStateChanges$7(this, replica)));
            if (tuple22 == null) {
                throw new MatchError((Object)null);
            }
            Seq replicasWithLeadershipInfo = (Seq)tuple22._1();
            Seq replicasWithoutLeadershipInfo = (Seq)tuple22._2();
            void replicasWithLeadershipInfo2 = var11_11;
            void replicasWithoutLeadershipInfo2 = var12_12;
            scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, replicasWithLeadershipInfo2.map((Function1<PartitionAndReplica, TopicPartition> & Serializable & scala.Serializable)x$5 -> x$5.topicPartition(), Seq$.MODULE$.canBuildFrom()));
            Function2<TopicPartition, LeaderIsrAndControllerEpoch, Object> & Serializable & scala.Serializable intersect = (Function2<TopicPartition, LeaderIsrAndControllerEpoch, Object> & Serializable & scala.Serializable)(partition, leaderIsrAndControllerEpoch) -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$9(this, stateLogger, replicaId, traceEnabled, partition, leaderIsrAndControllerEpoch);
                return BoxedUnit.UNIT;
            };
            Map<TopicPartition, LeaderIsrAndControllerEpoch> map = Implicits$.MODULE$.MapExtensionMethods(updatedLeaderIsrAndControllerEpochs);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(scala.collection.compat.package$.MODULE$.toMapExtensionMethods(forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            replicasWithoutLeadershipInfo2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$12(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionStarted$.MODULE$.equals(targetState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$13(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionIneligible$.MODULE$.equals(targetState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$14(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionSuccessful$.MODULE$.equals(targetState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$15(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (NonExistentReplica$.MODULE$.equals(targetState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$16(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(targetState);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        ObjectRef<GenMap> results = ObjectRef.create(Predef$.MODULE$.Map().empty());
        Seq<TopicPartition> remaining = partitions;
        while (remaining.nonEmpty()) {
            void var7_7;
            void var6_6;
            Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>>, Seq<TopicPartition>> tuple2 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>> finishedRemoval = tuple2._1();
            Seq<TopicPartition> removalsToRetry = tuple2._2();
            void finishedRemoval2 = var6_6;
            remaining = var7_7;
            finishedRemoval2.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                ZkReplicaStateMachine.$anonfun$removeReplicasFromIsr$1(this, replicaId, results, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return (scala.collection.immutable.Map)results.elem;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>>, Seq<TopicPartition>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        void var16_16;
        void var15_15;
        void var10_10;
        void var9_9;
        void var5_5;
        void var4_4;
        Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>> leaderAndIsrs = tuple2._1();
        Seq<TopicPartition> partitionsWithNoLeaderAndIsrInZk = tuple2._2();
        void leaderAndIsrs2 = var4_4;
        void partitionsWithNoLeaderAndIsrInZk2 = var5_5;
        Tuple2 tuple22 = leaderAndIsrs2.partition((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$1(replicaId, x0$1)));
        if (tuple22 == null) {
            throw new MatchError((Object)null);
        }
        scala.collection.immutable.Map leaderAndIsrsWithReplica = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica = (scala.collection.immutable.Map)tuple22._2();
        void leaderAndIsrsWithReplica2 = var9_9;
        void leaderAndIsrsWithoutReplica2 = var10_10;
        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> adjustedLeaderAndIsrs = leaderAndIsrsWithReplica2.flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition partition = (TopicPartition)x0$2._1();
            Either result = (Either)x0$2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(result.toOption().map((Function1<LeaderAndIsr, Tuple2> & Serializable & scala.Serializable)leaderAndIsr -> {
                int newLeader = replicaId == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
                List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : (List)leaderAndIsr.isr().filter((JFunction1$mcZI$sp & scala.Serializable)x$10 -> x$10 != replicaId);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), leaderAndIsr.newLeaderAndIsr(newLeader, adjustedIsr));
            }));
            return iterable;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr(adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, Either<Exception, LeaderAndIsr>> finishedPartitions = updateLeaderAndIsrResult.finishedPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        void finishedPartitions2 = var15_15;
        void updatesToRetry2 = var16_16;
        scala.collection.immutable.Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = partitionsWithNoLeaderAndIsrInZk2.iterator().flatMap((Function1<TopicPartition, Iterable> & Serializable & scala.Serializable)partition -> {
            if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Failed to change state of replica ").append(replicaId).append(" for partition ").append(partition).append(" since the leader and isr ").append("path in zookeeper is empty").toString());
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), package$.MODULE$.Left().apply(exception))));
            }
            return Option$.MODULE$.option2Iterable(None$.MODULE$);
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = leaderAndIsrsWithoutReplica2.$plus$plus(finishedPartitions2).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition partition = (TopicPartition)x0$3._1();
            Either result = (Either)x0$3._2();
            Tuple2 tuple2 = new Tuple2(partition, result.map((Function1<LeaderAndIsr, LeaderIsrAndControllerEpoch> & Serializable & scala.Serializable)leaderAndIsr -> {
                void var3_3;
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)leaderAndIsr, $this.controllerContext.epoch());
                $this.controllerContext.putPartitionLeadershipInfo(partition, leaderIsrAndControllerEpoch);
                return var3_3;
            }));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (this.isDebugEnabled()) {
            updatesToRetry2.foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)partition -> {
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(141).append("Controller failed to remove replica ").append(replicaId$3).append(" from ISR of partition ").append(partition).append(". ").append("Attempted to write state ").append(adjustedLeaderAndIsrs$1.apply(partition)).append(", but failed with bad ZK version. This will be retried.").toString());
                return BoxedUnit.UNIT;
            });
        }
        return new Tuple2(leaderIsrAndControllerEpochs.$plus$plus(exceptionsForPartitionsWithNoLeaderAndIsrInZk), updatesToRetry2);
    }

    private Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>>(partitions.iterator().map((Function1<TopicPartition, Tuple2> & Serializable & scala.Serializable)x$12 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$12), package$.MODULE$.Left().apply(e))).toMap(Predef$.MODULE$.$conforms()), Nil$.MODULE$);
        }
        Seq<GetDataResponse> getDataResponses = seq;
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        GenMap result = Map$.MODULE$.empty();
        getDataResponses.foreach(arg_0 -> ZkReplicaStateMachine.$anonfun$getTopicPartitionStatesFromZk$2$adapted(this, partitionsWithNoLeaderAndIsrInZk, (scala.collection.mutable.Map)result, arg_0));
        return new Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>>(result.toMap(Predef$.MODULE$.$conforms()), partitionsWithNoLeaderAndIsrInZk);
    }

    private void logSuccessfulTransition(StateChangeLogger logger, int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        logger.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Changed state of replica ").append(replicaId).append(" for partition ").append(partition).append(" from ").append(currState).append(" to ").append(targetState).toString());
    }

    private void logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = this.controllerContext.replicaState(replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder(82).append("Replica ").append(replica).append(" should be in the ").append(targetState.validPreviousStates().mkString(",")).append(" ").append("states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString());
        this.logFailedStateChange(replica, currState, targetState, e);
    }

    private void logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" initiated state change of replica ").append(replica.replica()).append(" ").append("for partition ").append(replica.topicPartition()).append(" from ").append(currState).append(" to ").append(targetState).append(" failed").toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkReplicaStateMachine $this, int replicaId$1, boolean traceEnabled$1, StateChangeLogger stateLogger$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        Option<LeaderIsrAndControllerEpoch> option = $this.controllerContext.partitionLeadershipInfo(partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId$1) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Replica ").append(replicaId$1).append(" for partition ").append(partition).append(" cannot be moved to NewReplica state as it is being requested to become leader").toString());
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, exception);
                return;
            }
            $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(replica.topicPartition()), true);
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, NewReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, NewReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$4(ZkReplicaStateMachine $this, int replicaId$1, boolean traceEnabled$1, StateChangeLogger stateLogger$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (NewReplica$.MODULE$.equals(currentState)) {
            ReplicaAssignment assignment = $this.controllerContext.partitionFullReplicaAssignment(partition);
            if (!assignment.replicas().contains(BoxesRunTime.boxToInteger(replicaId$1))) {
                $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Adding replica (").append(replicaId$1).append(") that is not part of the assignment ").append(assignment).toString());
                ReplicaAssignment newAssignment = assignment.copy(assignment.replicas().$colon$plus(BoxesRunTime.boxToInteger(replicaId$1), Seq$.MODULE$.canBuildFrom()), assignment.copy$default$2(), assignment.copy$default$3());
                $this.controllerContext.updatePartitionFullReplicaAssignment(partition, newAssignment);
            }
        } else {
            Option<LeaderIsrAndControllerEpoch> option = $this.controllerContext.partitionLeadershipInfo(partition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), false);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, OnlineReplica$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, OnlineReplica$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$7(ZkReplicaStateMachine $this, PartitionAndReplica replica) {
        return $this.controllerContext.partitionLeadershipInfo(replica.topicPartition()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(ZkReplicaStateMachine $this, StateChangeLogger stateLogger$1, int replicaId$1, boolean traceEnabled$1, TopicPartition partition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch) {
        stateLogger$1.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Partition ").append(partition).append(" state changed to ").append(leaderIsrAndControllerEpoch).append(" after removing replica ").append(replicaId$1).append(" from the ISR as part of transition to ").append(OfflineReplica$.MODULE$).toString());
        if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
            Seq recipients = (Seq)$this.controllerContext.partitionReplicaAssignment(partition).filterNot((JFunction1$mcZI$sp & scala.Serializable)x$6 -> x$6 == replicaId$1);
            $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers(recipients, partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), false);
        }
        PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$1);
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, OfflineReplica$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$12(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, OfflineReplica$.MODULE$);
        }
        $this.controllerBrokerRequestBatch.addUpdateMetadataRequestForBrokers($this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{replica.topicPartition()})));
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionStarted$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionStarted$.MODULE$);
        $this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), replica.topicPartition(), true);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$14(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionIneligible$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionSuccessful$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionSuccessful$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$16(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        ReplicaAssignment newAssignedReplicas = $this.controllerContext.partitionFullReplicaAssignment(replica.topicPartition()).removeReplica(replica.replica());
        $this.controllerContext.updatePartitionFullReplicaAssignment(replica.topicPartition(), newAssignedReplicas);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, NonExistentReplica$.MODULE$);
        }
        $this.controllerContext.removeReplicaState(replica);
    }

    public static final /* synthetic */ void $anonfun$removeReplicasFromIsr$1(ZkReplicaStateMachine $this, int replicaId$2, ObjectRef results$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Left) {
                Exception e = (Exception)((Left)either).value();
                PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$2);
                ReplicaState currentState = $this.controllerContext.replicaState(replica);
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, e);
                return;
            }
        }
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Right) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Right)either).value();
                results$1.elem = ((scala.collection.immutable.Map)results$1.elem).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), leaderIsrAndEpoch));
                return;
            }
        }
        throw new MatchError(x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$2(int replicaId$3, LeaderAndIsr leaderAndIsr) {
        return leaderAndIsr.isr().contains(BoxesRunTime.boxToInteger(replicaId$3));
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$1(int replicaId$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = BoxesRunTime.unboxToBoolean(((Either)x0$1._2()).map((Function1<LeaderAndIsr, Object> & Serializable & scala.Serializable)leaderAndIsr -> BoxesRunTime.boxToBoolean(ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$2(replicaId$3, leaderAndIsr))).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> false));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getTopicPartitionStatesFromZk$2(ZkReplicaStateMachine $this, Buffer partitionsWithNoLeaderAndIsrInZk$1, scala.collection.mutable.Map result$1, GetDataResponse getDataResponse) {
        TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
        KeeperException.Code code = getDataResponse.resultCode();
        KeeperException.Code code2 = KeeperException.Code.OK;
        if (!(code != null ? !code.equals(code2) : code2 != null)) {
            Option<LeaderIsrAndControllerEpoch> option = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
            if (None$.MODULE$.equals(option)) {
                partitionsWithNoLeaderAndIsrInZk$1.$plus$eq(partition);
                return;
            }
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(222).append("Leader and isr path written by another controller. This probably ").append("means the current controller with epoch ").append($this.controllerContext.epoch()).append(" went through a soft failure and ").append("another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(". Aborting ").append("state change by this controller").toString());
                    result$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), package$.MODULE$.Left().apply(exception)));
                    return;
                }
                result$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), package$.MODULE$.Right().apply(leaderIsrAndControllerEpoch.leaderAndIsr())));
                return;
            }
            throw new MatchError(option);
        }
        KeeperException.Code code3 = getDataResponse.resultCode();
        KeeperException.Code code4 = KeeperException.Code.NONODE;
        if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
            partitionsWithNoLeaderAndIsrInZk$1.$plus$eq(partition);
            return;
        }
        result$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), package$.MODULE$.Left().apply(getDataResponse.resultException().get())));
    }

    public ZkReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(36).append("[ReplicaStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }

    public static final /* synthetic */ Object $anonfun$getTopicPartitionStatesFromZk$2$adapted(ZkReplicaStateMachine $this, Buffer partitionsWithNoLeaderAndIsrInZk$1, scala.collection.mutable.Map result$1, GetDataResponse getDataResponse) {
        ZkReplicaStateMachine.$anonfun$getTopicPartitionStatesFromZk$2($this, partitionsWithNoLeaderAndIsrInZk$1, result$1, getDataResponse);
        return BoxedUnit.UNIT;
    }
}

