/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.cluster.Broker;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.Admin;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.pinot.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.pinot.shaded.org.apache.kafka.common.Node;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartitionInfo;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartitionReplica;
import org.apache.pinot.shaded.org.apache.kafka.common.config.ConfigResource;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.pinot.shaded.org.apache.kafka.common.security.JaasUtils;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenMap;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.TreeSet;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionForJava8$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered$;
import scala.math.Ordering$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final String AnyLogDir;
    private final String helpText;
    private final int EarliestVersion;
    private final int EarliestTopicsJsonVersion;
    private final String brokerLevelLeaderThrottle;
    private final String brokerLevelFollowerThrottle;
    private final String brokerLevelLogDirThrottle;
    private final Seq<String> brokerLevelThrottles;
    private final String topicLevelLeaderThrottle;
    private final String topicLevelFollowerThrottle;
    private final Seq<String> topicLevelThrottles;
    private final String cannotExecuteBecauseOfExistingMessage;
    private final String youMustRunVerifyPeriodicallyMessage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public String helpText() {
        return this.helpText;
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public int EarliestTopicsJsonVersion() {
        return this.EarliestTopicsJsonVersion;
    }

    public String brokerLevelLeaderThrottle() {
        return this.brokerLevelLeaderThrottle;
    }

    public String brokerLevelFollowerThrottle() {
        return this.brokerLevelFollowerThrottle;
    }

    public String brokerLevelLogDirThrottle() {
        return this.brokerLevelLogDirThrottle;
    }

    public Seq<String> brokerLevelThrottles() {
        return this.brokerLevelThrottles;
    }

    public String topicLevelLeaderThrottle() {
        return this.topicLevelLeaderThrottle;
    }

    public String topicLevelFollowerThrottle() {
        return this.topicLevelFollowerThrottle;
    }

    public Seq<String> topicLevelThrottles() {
        return this.topicLevelThrottles;
    }

    public String cannotExecuteBecauseOfExistingMessage() {
        return this.cannotExecuteBecauseOfExistingMessage;
    }

    public String youMustRunVerifyPeriodicallyMessage() {
        return this.youMustRunVerifyPeriodicallyMessage;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        Option toClose = None$.MODULE$;
        boolean failed = true;
        try {
            try {
                if (opts.options().has(opts.bootstrapServerOpt())) {
                    if (opts.options().has(opts.zkConnectOpt())) {
                        Predef$.MODULE$.println("Warning: ignoring deprecated --zookeeper option because --bootstrap-server was specified.  The --zookeeper option will be removed in a future version of Kafka.");
                    }
                    Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps(opts.options().valueOf(opts.commandConfigOpt())) : new Properties();
                    props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
                    props.putIfAbsent("client.id", "reassign-partitions-tool");
                    Admin adminClient = Admin.create(props);
                    toClose = new Some<Admin>(adminClient);
                    this.handleAction(adminClient, opts);
                } else {
                    Predef$.MODULE$.println("Warning: --zookeeper is deprecated, and will be removed in a future version of Kafka.");
                    KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(opts.options().valueOf(opts.zkConnectOpt()), JaasUtils.isZkSaslEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10());
                    toClose = new Some<KafkaZkClient>(zkClient);
                    this.handleAction(zkClient, opts);
                }
                failed = false;
            }
            catch (ReassignPartitionsCommand.TerseReassignmentFailureException e) {
                Predef$.MODULE$.println(e.getMessage());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println(new StringBuilder(7).append("Error: ").append(e.getMessage()).toString());
                Predef$.MODULE$.println(Utils.stackTrace(e));
            }
        }
        finally {
            toClose.foreach((Function1<AutoCloseable, Object> & Serializable & scala.Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
        }
        if (failed) {
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    private void handleAction(Admin adminClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.verifyOpt())) {
            this.verifyAssignment(adminClient, Utils.readFileAsString(opts.options().valueOf(opts.reassignmentJsonFileOpt())), opts.options().has(opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options().has(opts.generateOpt())) {
            this.generateAssignment(adminClient, Utils.readFileAsString(opts.options().valueOf(opts.topicsToMoveJsonFileOpt())), opts.options().valueOf(opts.brokerListOpt()), !opts.options().has(opts.disableRackAware()));
            return;
        }
        if (opts.options().has(opts.executeOpt())) {
            this.executeAssignment(adminClient, opts.options().has(opts.additionalOpt()), Utils.readFileAsString(opts.options().valueOf(opts.reassignmentJsonFileOpt())), BoxesRunTime.unboxToLong(opts.options().valueOf(opts.interBrokerThrottleOpt())), BoxesRunTime.unboxToLong(opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt())), BoxesRunTime.unboxToLong(opts.options().valueOf(opts.timeoutOpt())), this.executeAssignment$default$7());
            return;
        }
        if (opts.options().has(opts.cancelOpt())) {
            this.cancelAssignment(adminClient, Utils.readFileAsString(opts.options().valueOf(opts.reassignmentJsonFileOpt())), opts.options().has(opts.preserveThrottlesOpt()), BoxesRunTime.unboxToLong(opts.options().valueOf(opts.timeoutOpt())), this.cancelAssignment$default$5());
            return;
        }
        if (opts.options().has(opts.listOpt())) {
            this.listReassignments(adminClient);
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    private void handleAction(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.verifyOpt())) {
            this.verifyAssignment(zkClient, Utils.readFileAsString(opts.options().valueOf(opts.reassignmentJsonFileOpt())), opts.options().has(opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options().has(opts.generateOpt())) {
            this.generateAssignment(zkClient, Utils.readFileAsString(opts.options().valueOf(opts.topicsToMoveJsonFileOpt())), opts.options().valueOf(opts.brokerListOpt()), !opts.options().has(opts.disableRackAware()));
            return;
        }
        if (opts.options().has(opts.executeOpt())) {
            this.executeAssignment(zkClient, Utils.readFileAsString(opts.options().valueOf(opts.reassignmentJsonFileOpt())), BoxesRunTime.unboxToLong(opts.options().valueOf(opts.interBrokerThrottleOpt())));
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        void var10_11;
        void var8_8;
        void var6_6;
        void var5_5;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts = tuple2._1();
        Map<TopicPartitionReplica, String> targetLogDirs = tuple2._2();
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        if (tuple22 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> partStates = tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> tuple23 = this.verifyReplicaMoves(adminClient, (Map<TopicPartitionReplica, String>)var6_6);
        if (tuple23 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> moveStates = tuple23._1();
        boolean bl2 = tuple23._2$mcZ$sp();
        if (!(bl || bl2 || preserveThrottles)) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_8, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)var10_11, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(adminClient, targets);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> partStates = tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Predef$.MODULE$.println(this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4));
        return new Tuple2<void, Boolean>(var4_4, BoxesRunTime.boxToBoolean(bl));
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(KafkaZkClient zkClient, String jsonString, boolean preserveThrottles) {
        void var8_8;
        void var5_5;
        void var6_6;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts = tuple2._1();
        Map<TopicPartitionReplica, String> targetLogDirs = tuple2._2();
        if (var6_6.nonEmpty()) {
            throw new AdminCommandFailedException("bootstrap-server needs to be provided when replica reassignments are present.");
        }
        Predef$.MODULE$.println("Warning: because you are using the deprecated --zookeeper option, the results may be incomplete.  Use --bootstrap-server instead for more accurate results.");
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(zkClient, var5_5.toMap(Predef$.MODULE$.$conforms()));
        if (tuple22 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> partStates = tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        if (!bl && !preserveThrottles) {
            this.clearAllThrottles(zkClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_8, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)scala.collection.Map$.MODULE$.empty(), false);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(zkClient, targets);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> partStates = tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Predef$.MODULE$.println(this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4));
        return new Tuple2<void, Boolean>(var4_4, BoxesRunTime.boxToBoolean(bl));
    }

    public boolean compareTopicPartitions(TopicPartition a, TopicPartition b) {
        return Ordered$.MODULE$.orderingToOrdered(new Tuple2<String, Integer>(a.topic(), BoxesRunTime.boxToInteger(a.partition())), Ordering$.MODULE$.Tuple2(Ordering$String$.MODULE$, Ordering$Int$.MODULE$)).$less(new Tuple2<String, Integer>(b.topic(), BoxesRunTime.boxToInteger(b.partition())));
    }

    public boolean compareTopicPartitionReplicas(TopicPartitionReplica a, TopicPartitionReplica b) {
        return Ordered$.MODULE$.orderingToOrdered(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(a.brokerId()), a.topic(), BoxesRunTime.boxToInteger(a.partition())), Ordering$.MODULE$.Tuple3(Ordering$Int$.MODULE$, Ordering$String$.MODULE$, Ordering$Int$.MODULE$)).$less(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(b.brokerId()), b.topic(), BoxesRunTime.boxToInteger(b.partition())));
    }

    public String partitionReassignmentStatesToString(Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> states) {
        ArrayBuffer<Object> bld = new ArrayBuffer<Object>();
        bld.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Status of partition reassignment:"}));
        ((IterableLike)states.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)topicPartition -> {
            ReassignPartitionsCommand$.$anonfun$partitionReassignmentStatesToString$2(states, bld, topicPartition);
            return BoxedUnit.UNIT;
        });
        return bld.mkString(System.lineSeparator());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetReassignments) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map<TopicPartition, PartitionReassignment> currentReassignments = CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.listPartitionReassignments().reassignments().get()).asScala();
        Tuple2 tuple2 = targetReassignments.partition((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$1(currentReassignments, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq foundReassignments = (Seq)tuple2._1();
        Seq notFoundReassignments = (Seq)tuple2._2();
        void foundReassignments2 = var5_5;
        void notFoundReassignments2 = var6_6;
        Seq foundResults = foundReassignments2.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition part = (TopicPartition)x0$2._1();
            Seq targetReplicas = (Seq)x0$2._2();
            Tuple2<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> tuple2 = new Tuple2<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>(part, new ReassignPartitionsCommand.PartitionReassignmentState(((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((PartitionReassignment)currentReassignments.apply(part)).replicas()).asScala()).map((Function1<Integer, Object> & Serializable & scala.Serializable)i -> BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$3(i)), Buffer$.MODULE$.canBuildFrom()), targetReplicas, false));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        HashSet topicNamesToLookUp = new HashSet();
        notFoundReassignments2.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition part = (TopicPartition)x0$3._1();
            BoxedUnit boxedUnit = !currentReassignments.contains(part) ? BoxesRunTime.boxToBoolean(topicNamesToLookUp.add(part.topic())) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        scala.collection.mutable.Map<String, KafkaFuture<TopicDescription>> topicDescriptions = CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeTopics(CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter(topicNamesToLookUp).asJava()).values()).asScala();
        Seq notFoundResults = notFoundReassignments2.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 == null) throw new MatchError((Object)null);
            TopicPartition part = (TopicPartition)x0$4._1();
            Seq targetReplicas = (Seq)x0$4._2();
            Option option = currentReassignments.get(part);
            if (option instanceof Some) {
                PartitionReassignment reassignment = (PartitionReassignment)((Some)option).value();
                return new Tuple2<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>(part, new ReassignPartitionsCommand.PartitionReassignmentState(((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.replicas()).asScala()).map((Function1<Integer, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$6(x$10)), Buffer$.MODULE$.canBuildFrom()), targetReplicas, false));
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            return new Tuple2<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>(part, MODULE$.topicDescriptionFutureToState(part.partition(), (KafkaFuture)topicDescriptions.apply(part.topic()), targetReplicas));
        }, Seq$.MODULE$.canBuildFrom());
        Seq allResults = foundResults.$plus$plus(notFoundResults, Seq$.MODULE$.canBuildFrom());
        return new Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object>(allResults.toMap(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToBoolean(currentReassignments.nonEmpty()));
    }

    private ReassignPartitionsCommand.PartitionReassignmentState topicDescriptionFutureToState(int partition, KafkaFuture<TopicDescription> future, Seq<Object> targetReplicas) {
        try {
            TopicDescription topicDescription = future.get();
            if (topicDescription.partitions().size() < partition) {
                throw new ExecutionException("Too few partitions found", new UnknownTopicOrPartitionException());
            }
            return new ReassignPartitionsCommand.PartitionReassignmentState(((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions().get(partition).replicas()).asScala()).map((Function1<Node, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger(x$11.id()), Buffer$.MODULE$.canBuildFrom()), targetReplicas, true);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (!(throwable instanceof UnknownTopicOrPartitionException)) {
                throw throwable;
            }
            ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState(Nil$.MODULE$, targetReplicas, true);
            return partitionReassignmentState;
        }
    }

    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> targetReassignments) {
        Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        targetReassignments.groupBy((Function1<Tuple2, String> & Serializable & scala.Serializable)x$12 -> ((TopicPartition)x$12._1()).topic()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$8(zkClient, results, partitionsBeingReassigned, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object>(results, BoxesRunTime.boxToBoolean(partitionsBeingReassigned.nonEmpty()));
    }

    public Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> verifyReplicaMoves(Admin adminClient, Map<TopicPartitionReplica, String> targetReassignments) {
        Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> moveStates = this.findLogDirMoveStates(adminClient, targetReassignments);
        Predef$.MODULE$.println(this.replicaMoveStatesToString(moveStates));
        return new Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object>(moveStates, BoxesRunTime.boxToBoolean(!moveStates.values().forall((Function1<ReassignPartitionsCommand.LogDirMoveState, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.done()))));
    }

    public Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> findLogDirMoveStates(Admin adminClient, Map<TopicPartitionReplica, String> targetMoves) {
        scala.collection.mutable.Map<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> replicaLogDirInfos = CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeReplicaLogDirs(CollectionConverters$.MODULE$.setAsJavaSetConverter(targetMoves.keySet()).asJava()).all().get()).asScala();
        return targetMoves.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            void var3_7;
            if (x0$1 == null) throw new MatchError((Object)null);
            TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
            String targetLogDir = (String)x0$1._2();
            Option option = replicaLogDirInfos.get(replica);
            if (None$.MODULE$.equals(option)) {
                ReassignPartitionsCommand.MissingReplicaMoveState missingReplicaMoveState = new ReassignPartitionsCommand.MissingReplicaMoveState(targetLogDir);
                return new Tuple2<TopicPartitionReplica, void>(replica, var3_7);
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                DescribeReplicaLogDirsResult.ReplicaLogDirInfo info = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((Some)option).value();
                scala.Serializable serializable = info.getCurrentReplicaLogDir() == null ? new ReassignPartitionsCommand.MissingLogDirMoveState(targetLogDir) : (info.getFutureReplicaLogDir() == null ? (info.getCurrentReplicaLogDir().equals(targetLogDir) ? new ReassignPartitionsCommand.CompletedMoveState(targetLogDir) : new ReassignPartitionsCommand.CancelledMoveState(info.getCurrentReplicaLogDir(), targetLogDir)) : new ReassignPartitionsCommand.ActiveMoveState(info.getCurrentReplicaLogDir(), targetLogDir, info.getFutureReplicaLogDir()));
            }
            return new Tuple2<TopicPartitionReplica, void>(replica, var3_7);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public String replicaMoveStatesToString(Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> states) {
        ArrayBuffer bld = new ArrayBuffer();
        ((IterableLike)states.keySet().toBuffer().sortWith((Function2<TopicPartitionReplica, TopicPartitionReplica, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).foreach((Function1<TopicPartitionReplica, Object> & Serializable & scala.Serializable)replica -> {
            ReassignPartitionsCommand$.$anonfun$replicaMoveStatesToString$2(states, bld, replica);
            return BoxedUnit.UNIT;
        });
        return bld.mkString(System.lineSeparator());
    }

    public void clearAllThrottles(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1<Node, Object> & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger(x$14.id()), Iterable$.MODULE$.canBuildFrom())).toSet().$plus$plus(((TraversableOnce)targetParts.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)x$15 -> (Seq)x$15._2(), Seq$.MODULE$.canBuildFrom())).toSet());
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Clearing broker-level throttles on broker%s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{brokers.size() == 1 ? "" : "s", brokers.mkString(",")})));
        this.clearBrokerLevelThrottles(adminClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set<String> topics = ((TraversableOnce)targetParts.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$16 -> ((TopicPartition)x$16._1()).topic(), Seq$.MODULE$.canBuildFrom())).toSet();
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Clearing topic-level throttles on topic%s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topics.size() == 1 ? "" : "s", topics.mkString(",")})));
        this.clearTopicLevelThrottles(adminClient, topics);
    }

    public void clearAllThrottles(KafkaZkClient zkClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)((TraversableOnce)zkClient.getAllBrokersInCluster().map((Function1<Broker, Object> & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger(x$17.id()), Seq$.MODULE$.canBuildFrom())).toSet().$plus$plus(((TraversableOnce)targetParts.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)x$18 -> (Seq)x$18._2(), Seq$.MODULE$.canBuildFrom())).toSet());
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Clearing broker-level throttles on broker%s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{brokers.size() == 1 ? "" : "s", brokers.mkString(",")})));
        this.clearBrokerLevelThrottles(zkClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set<String> topics = ((TraversableOnce)targetParts.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$19 -> ((TopicPartition)x$19._1()).topic(), Seq$.MODULE$.canBuildFrom())).toSet();
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Clearing topic-level throttles on topic%s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topics.size() == 1 ? "" : "s", topics.mkString(",")})));
        this.clearTopicLevelThrottles(zkClient, topics);
    }

    public void clearBrokerLevelThrottles(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        HashMap<ConfigResource, Collection<AlterConfigOp>> configOps = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
        brokers.foreach((Function1<Object, Collection> & Serializable & scala.Serializable)brokerId -> configOps.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(BoxesRunTime.unboxToInt(brokerId))), CollectionConverters$.MODULE$.seqAsJavaListConverter(ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1<String, AlterConfigOp> & Serializable & scala.Serializable)throttle -> new AlterConfigOp(new ConfigEntry((String)throttle, null), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom())).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearBrokerLevelThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<Object> brokers) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        brokers.foreach((JFunction1$mcVI$sp & scala.Serializable)brokerId -> {
            Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId));
            if (((TraversableOnce)MODULE$.brokerLevelThrottles().flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)throttle -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(configs.remove(throttle))), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
                adminZkClient.changeBrokerConfig((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), configs);
            }
        });
    }

    public void clearTopicLevelThrottles(Admin adminClient, scala.collection.immutable.Set<String> topics) {
        HashMap<ConfigResource, Collection<AlterConfigOp>> configOps = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
        topics.foreach((Function1<String, Collection> & Serializable & scala.Serializable)topicName -> configOps.put(new ConfigResource(ConfigResource.Type.TOPIC, (String)topicName), CollectionConverters$.MODULE$.seqAsJavaListConverter(MODULE$.topicLevelThrottles().map((Function1<String, AlterConfigOp> & Serializable & scala.Serializable)throttle -> new AlterConfigOp(new ConfigEntry((String)throttle, null), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom())).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearTopicLevelThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<String> topics) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1<String, Object> & Serializable & scala.Serializable)topic -> {
            ReassignPartitionsCommand$.$anonfun$clearTopicLevelThrottles$3(adminZkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(Admin adminClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void var7_7;
        void var6_6;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Object> brokersToReassign = tuple2._1();
        Seq<String> topicsToReassign = tuple2._2();
        void brokersToReassign2 = var6_6;
        void topicsToReassign2 = var7_7;
        Map<TopicPartition, Seq<Object>> currentAssignments = this.getReplicaAssignmentForTopics(adminClient, (Seq<String>)topicsToReassign2);
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(adminClient, (Seq<Object>)brokersToReassign2, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        return new Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>>(proposedAssignments, currentAssignments);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void var7_7;
        void var6_6;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Object> brokersToReassign = tuple2._1();
        Seq<String> topicsToReassign = tuple2._2();
        void brokersToReassign2 = var6_6;
        void topicsToReassign2 = var7_7;
        Map<TopicPartition, Seq<Object>> currentAssignments = zkClient.getReplicaAssignmentForTopics(topicsToReassign2.toSet());
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(zkClient, (Seq<Object>)brokersToReassign2, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        return new Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>>(proposedAssignments, currentAssignments);
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, Seq<Object>> calculateAssignment(Map<TopicPartition, Seq<Object>> currentAssignment, Seq<BrokerMetadata> brokerMetadatas) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String string = ((TopicPartition)x0$1._1()).topic();
            return string;
        });
        scala.collection.mutable.Map proposedAssignments = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        Function2<String, Map, scala.collection.mutable.Map> & Serializable & scala.Serializable intersect = (Function2<String, Map, scala.collection.mutable.Map> & Serializable & scala.Serializable)(topic, assignment) -> {
            void var5_5;
            Tuple2 tuple2 = (Tuple2)assignment.head();
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            Seq replicas = (Seq)tuple2._2();
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), var5_5.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            return (scala.collection.mutable.Map)proposedAssignments.$plus$plus$eq(assignedReplicas.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError((Object)null);
                }
                int partition = x0$2._1$mcI$sp();
                Seq replicas = (Seq)x0$2._2();
                Tuple2<TopicPartition, Seq> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition((String)topic, partition)), replicas);
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom()));
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(groupedByTopic);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods(forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return proposedAssignments;
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForTopics(Admin adminClient, Seq<String> topics) {
        return ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeTopics((Collection<String>)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get()).asScala()).flatMap((Function1<Tuple2, Buffer> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topicName = (String)x0$1._1();
            TopicDescription topicDescription = (TopicDescription)x0$1._2();
            Buffer buffer = ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1<TopicPartitionInfo, Tuple2> & Serializable & scala.Serializable)info -> new Tuple2(new TopicPartition(topicName, info.partition()), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(info.replicas()).asScala()).map((Function1<Node, Object> & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger(x$22.id()), Buffer$.MODULE$.canBuildFrom())), Buffer$.MODULE$.canBuildFrom());
            return buffer;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForPartitions(Admin adminClient, scala.collection.immutable.Set<TopicPartition> partitions) {
        return ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeTopics(CollectionConverters$.MODULE$.setAsJavaSetConverter(partitions.map((Function1<TopicPartition, String> & Serializable & scala.Serializable)x$23 -> x$23.topic(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).asJava()).all().get()).asScala()).flatMap((Function1<Tuple2, Buffer> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topicName = (String)x0$1._1();
            TopicDescription topicDescription = (TopicDescription)x0$1._2();
            Buffer buffer = ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).flatMap((Function1<TopicPartitionInfo, Iterable> & Serializable & scala.Serializable)info -> {
                if (partitions.contains(new TopicPartition(topicName, info.partition()))) {
                    return Option$.MODULE$.option2Iterable(new Some(new Tuple2(new TopicPartition(topicName, info.partition()), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(info.replicas()).asScala()).map((Function1<Node, Object> & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger(x$24.id()), Buffer$.MODULE$.canBuildFrom()))));
                }
                return Option$.MODULE$.option2Iterable(None$.MODULE$);
            }, Buffer$.MODULE$.canBuildFrom());
            return buffer;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Seq<BrokerMetadata> getBrokerMetadata(Admin adminClient, Seq<Object> brokers, boolean enableRackAwareness) {
        scala.collection.immutable.Set brokerSet = brokers.toSet();
        Seq<BrokerMetadata> results = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).filter((Function1<Node, Object> & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean(brokerSet.contains(BoxesRunTime.boxToInteger(node.id()))))).map((Function1<Node, BrokerMetadata> & Serializable & scala.Serializable)node -> {
            if (enableRackAwareness && node.rack() != null) {
                return new BrokerMetadata(node.id(), new Some<String>(node.rack()));
            }
            return new BrokerMetadata(node.id(), None$.MODULE$);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        int numRackless = results.count((Function1<BrokerMetadata, Object> & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$getBrokerMetadata$3(x$25)));
        if (enableRackAwareness && numRackless != 0 && numRackless != results.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return results;
    }

    public Seq<BrokerMetadata> getBrokerMetadata(KafkaZkClient zkClient, Seq<Object> brokers, boolean enableRackAwareness) {
        return new AdminZkClient(zkClient).getBrokerMetadatas((RackAwareMode)((Object)(enableRackAwareness ? RackAwareMode$Enforced$.MODULE$ : RackAwareMode$Disabled$.MODULE$)), new Some<Seq<Object>>(brokers));
    }

    public Tuple2<Seq<Object>, Seq<String>> parseGenerateAssignmentArgs(String reassignmentJson, String brokerList) {
        int[] brokerListToReassign = (int[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(brokerList)).split(','))).map((Function1<String, Object> & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$parseGenerateAssignmentArgs$1(x$26)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable<Object> duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateReassignments.mkString(",")})));
        }
        Seq<String> topicsToReassign = this.parseTopicsData(reassignmentJson);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        return new Tuple2<Seq<Object>, Seq<String>>(Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToReassign);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long logDirThrottle, long timeoutMs, Time time) {
        Map<TopicPartition, Throwable> errors;
        void var13_10;
        void var12_9;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, Seq<Object>> proposedParts = tuple2._1();
        Map<TopicPartitionReplica, String> proposedReplicas = tuple2._2();
        void proposedParts2 = var12_9;
        void proposedReplicas2 = var13_10;
        scala.collection.mutable.Map<TopicPartition, PartitionReassignment> currentReassignments = CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.listPartitionReassignments().reassignments().get()).asScala();
        if (!additional && currentReassignments.nonEmpty()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        this.verifyBrokerIds(adminClient, ((TraversableOnce)proposedParts2.values().flatten(Predef$.MODULE$.$conforms())).toSet());
        Map<TopicPartition, Seq<Object>> currentParts = this.getReplicaAssignmentForPartitions(adminClient, proposedParts2.keySet().toSet());
        Predef$.MODULE$.println(this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts));
        if (interBrokerThrottle >= 0L || logDirThrottle >= 0L) {
            Predef$.MODULE$.println(this.youMustRunVerifyPeriodicallyMessage());
            if (interBrokerThrottle >= 0L) {
                scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateProposedMoveMap(currentReassignments, (Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts);
                this.modifyReassignmentThrottle(adminClient, moveMap, interBrokerThrottle);
            }
            if (logDirThrottle >= 0L) {
                scala.collection.immutable.Set<Object> movingBrokers = this.calculateMovingBrokers(proposedReplicas2.keySet().toSet());
                this.modifyLogDirThrottle(adminClient, movingBrokers, logDirThrottle);
            }
        }
        if ((errors = this.alterPartitionReassignments(adminClient, (Map<TopicPartition, Seq<Object>>)proposedParts2)).nonEmpty()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(new StringOps(Predef$.MODULE$.augmentString("Error reassigning partition(s):%n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((TraversableOnce)((TraversableLike)errors.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1<TopicPartition, String> & Serializable & scala.Serializable)part -> new StringBuilder(2).append(part).append(": ").append(((Throwable)errors.apply((TopicPartition)part)).getMessage()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator())})));
        }
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Successfully started partition reassignment%s for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{proposedParts2.size() == 1 ? "" : "s", ((TraversableOnce)proposedParts2.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(",")})));
        if (proposedReplicas2.nonEmpty()) {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)proposedReplicas2, timeoutMs, time);
        }
    }

    public void executeMoves(Admin adminClient, Map<TopicPartitionReplica, String> proposedReplicas, long timeoutMs, Time time) {
        long startTimeMs = time.milliseconds();
        scala.collection.mutable.HashMap<TopicPartitionReplica, String> pendingReplicas = new scala.collection.mutable.HashMap<TopicPartitionReplica, String>();
        pendingReplicas.$plus$plus$eq(proposedReplicas);
        boolean done = false;
        do {
            scala.collection.immutable.Set<TopicPartitionReplica> completed;
            if ((completed = this.alterReplicaLogDirs(adminClient, pendingReplicas)).nonEmpty()) {
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Successfully started log directory move%s for: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{completed.size() == 1 ? "" : "s", ((TraversableOnce)completed.toBuffer().sortWith((Function2<TopicPartitionReplica, TopicPartitionReplica, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).mkString(",")})));
            }
            pendingReplicas.$minus$minus$eq(completed);
            if (pendingReplicas.isEmpty()) {
                done = true;
                continue;
            }
            if (time.milliseconds() >= startTimeMs + timeoutMs) {
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(new StringOps(Predef$.MODULE$.augmentString("Timed out before log directory move%s could be started for: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{pendingReplicas.size() == 1 ? "" : "s", ((TraversableOnce)pendingReplicas.keySet().toBuffer().sortWith((Function2<TopicPartitionReplica, TopicPartitionReplica, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).mkString(",")})));
            }
            time.sleep(100L);
        } while (!done);
    }

    public void listReassignments(Admin adminClient) {
        Predef$.MODULE$.println(this.curReassignmentsToString(adminClient));
    }

    public String curReassignmentsToString(Admin adminClient) {
        scala.collection.mutable.Map<TopicPartition, PartitionReassignment> currentReassignments = CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.listPartitionReassignments().reassignments().get()).asScala();
        String text = ((TraversableOnce)((TraversableLike)currentReassignments.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1<TopicPartition, String> & Serializable & scala.Serializable)part -> {
            PartitionReassignment reassignment = (PartitionReassignment)currentReassignments.apply((TopicPartition)part);
            Buffer<Integer> replicas = CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.replicas()).asScala();
            Buffer<Integer> addingReplicas = CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.addingReplicas()).asScala();
            Buffer<Integer> removingReplicas = CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.removingReplicas()).asScala();
            return new StringOps(Predef$.MODULE$.augmentString("%s: replicas: %s.%s%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{part, replicas.mkString(","), addingReplicas.isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString(" adding: %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{addingReplicas.mkString(",")})), removingReplicas.isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString(" removing: %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{removingReplicas.mkString(",")}))}));
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        if (text.isEmpty()) {
            return "No partition reassignments found.";
        }
        return new StringOps(Predef$.MODULE$.augmentString("Current partition reassignments:%n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{text}));
    }

    public void verifyBrokerIds(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        scala.collection.immutable.Set allNodeIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1<Node, Object> & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger(x$28.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
        brokers.find((JFunction1$mcZI$sp & scala.Serializable)x$29 -> !allNodeIds.contains(BoxesRunTime.boxToInteger(x$29))).map((Function1<Object, Nothing$> & Serializable & scala.Serializable)id -> ReassignPartitionsCommand$.$anonfun$verifyBrokerIds$3(BoxesRunTime.unboxToInt(id)));
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(KafkaZkClient zkClient, String reassignmentJson, long interBrokerThrottle) {
        void var7_6;
        void var6_5;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Map<TopicPartition, Seq<Object>> proposedParts = tuple2._1();
        Map<TopicPartitionReplica, String> proposedReplicas = tuple2._2();
        void proposedParts2 = var6_5;
        if (var7_6.nonEmpty()) {
            throw new AdminCommandFailedException("bootstrap-server needs to be provided when replica reassignments are present.");
        }
        this.verifyReplicasAndBrokersInAssignment(zkClient, (Map<TopicPartition, Seq<Object>>)proposedParts2);
        if (zkClient.reassignPartitionsInProgress()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        Map<TopicPartition, Seq<Object>> currentParts = zkClient.getReplicaAssignmentForTopics(((TraversableOnce)proposedParts2.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$31 -> ((TopicPartition)x$31._1()).topic(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Predef$.MODULE$.println(this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts));
        if (interBrokerThrottle >= 0L) {
            Predef$.MODULE$.println(this.youMustRunVerifyPeriodicallyMessage());
            scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateProposedMoveMap((Map<TopicPartition, PartitionReassignment>)scala.collection.Map$.MODULE$.empty(), (Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts);
            Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
            Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
            this.modifyTopicThrottles(zkClient, leaderThrottles, followerThrottles);
            scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
            this.modifyBrokerThrottles(zkClient, reassigningBrokers, interBrokerThrottle);
            Predef$.MODULE$.println(new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString());
        }
        zkClient.createPartitionReassignment((Map<TopicPartition, Seq<Object>>)proposedParts2);
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Successfully started partition reassignment%s for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{proposedParts2.size() == 1 ? "" : "s", ((TraversableOnce)proposedParts2.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(",")})));
    }

    public long executeAssignment$default$4() {
        return -1L;
    }

    public long executeAssignment$default$5() {
        return -1L;
    }

    public long executeAssignment$default$6() {
        return 10000L;
    }

    public Time executeAssignment$default$7() {
        return Time.SYSTEM;
    }

    public String currentPartitionReplicaAssignmentToString(Map<TopicPartition, Seq<Object>> proposedParts, Map<TopicPartition, Seq<Object>> currentParts) {
        return new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment%n%n%s%n%nSave this to use as the %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(((TraversableOnce)currentParts.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$currentPartitionReplicaAssignmentToString$1(proposedParts, x0$1)))).toMap(Predef$.MODULE$.$conforms()), (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty()), "--reassignment-json-file option during rollback"}));
    }

    public void verifyReplicasAndBrokersInAssignment(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> proposedParts) {
        Iterable proposedTopics = proposedParts.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String string = ((TopicPartition)x0$1._1()).topic();
            return string;
        }, Iterable$.MODULE$.canBuildFrom());
        Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics(proposedTopics.toSet());
        Iterable nonExistentPartitions = (Iterable)((TraversableLike)proposedParts.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            return var1_1;
        }, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1<TopicPartition, Object> & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean(existingAssignment.contains(key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(58).append("The proposed assignment contains non-existent partitions: ").append(nonExistentPartitions).toString());
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)proposedParts.toMap(Predef$.MODULE$.$conforms()).values().flatten(Predef$.MODULE$.$conforms())).filterNot((Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(57).append("The proposed assignment contains non-existent brokerIDs: ").append(nonExistingBrokerIDs.mkString(",")).toString());
        }
    }

    public Map<TopicPartition, Throwable> alterPartitionReassignments(Admin adminClient, Map<TopicPartition, Seq<Object>> reassignments) {
        return ((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterPartitionReassignments(CollectionConverters$.MODULE$.mapAsJavaMapConverter(reassignments.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2<TopicPartition, Optional<NewPartitionReassignment>> tuple2 = new Tuple2<TopicPartition, Optional<NewPartitionReassignment>>(part, Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.seqAsJavaListConverter(replicas.map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), Seq$.MODULE$.canBuildFrom())).asJava())));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).asJava()).values()).asScala()).flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$2 -> {
            Iterable<Serializable> iterable;
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                try {
                    ((KafkaFuture)x0$2._2()).get();
                    iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
                }
                catch (ExecutionException t) {
                    iterable = Option$.MODULE$.option2Iterable(new Some<Tuple2<TopicPartition, Throwable>>(new Tuple2<TopicPartition, Throwable>(part, t.getCause())));
                }
            } else {
                throw new MatchError((Object)null);
            }
            Iterable<Nothing$> iterable2 = iterable;
            return iterable2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicPartition, Throwable> cancelPartitionReassignments(Admin adminClient, scala.collection.immutable.Set<TopicPartition> reassignments) {
        return ((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterPartitionReassignments(CollectionConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)reassignments.map((Function1<TopicPartition, Tuple2> & Serializable & scala.Serializable)x$32 -> new Tuple2<TopicPartition, Optional<Nothing$>>((TopicPartition)x$32, OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(None$.MODULE$))), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()).values()).asScala()).flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            Iterable<Serializable> iterable;
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
                }
                catch (ExecutionException t) {
                    iterable = Option$.MODULE$.option2Iterable(new Some<Tuple2<TopicPartition, Throwable>>(new Tuple2<TopicPartition, Throwable>(part, t.getCause())));
                }
            } else {
                throw new MatchError((Object)null);
            }
            Iterable<Nothing$> iterable2 = iterable;
            return iterable2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> calculateCurrentMoveMap(Map<TopicPartition, PartitionReassignment> currentReassignments) {
        void var2_2;
        scala.collection.mutable.HashMap moveMap = new scala.collection.mutable.HashMap();
        currentReassignments.foreach((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
            Buffer allReplicas = ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.replicas()).asScala()).map((Function1<Object, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$calculateCurrentMoveMap$2(x)), Buffer$.MODULE$.canBuildFrom());
            Buffer addingReplicas = ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.addingReplicas()).asScala()).map((Function1<Object, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$calculateCurrentMoveMap$3(x)), Buffer$.MODULE$.canBuildFrom());
            Object sources = ((SetLike)Set$.MODULE$.apply(Nil$.MODULE$)).$plus$plus((GenTraversableOnce)allReplicas.diff(addingReplicas));
            Object destinations = ((SetLike)Set$.MODULE$.apply(Nil$.MODULE$)).$plus$plus(addingReplicas);
            Option<ReassignPartitionsCommand.PartitionMove> option = ((scala.collection.mutable.Map)moveMap.getOrElseUpdate(part.topic(), (Function0<scala.collection.mutable.HashMap> & Serializable & scala.Serializable)() -> new scala.collection.mutable.HashMap())).put(BoxesRunTime.boxToInteger(part.partition()), new ReassignPartitionsCommand.PartitionMove((Set<Object>)sources, (Set<Object>)destinations));
            return option;
        });
        return var2_2;
    }

    public scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> calculateProposedMoveMap(Map<TopicPartition, PartitionReassignment> currentReassignments, Map<TopicPartition, Seq<Object>> proposedParts, Map<TopicPartition, Seq<Object>> currentParts) {
        scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateCurrentMoveMap(currentReassignments);
        proposedParts.foreach((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            if (x0$1 == null) throw new MatchError((Object)null);
            TopicPartition part = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            scala.collection.mutable.Map partMoves = (scala.collection.mutable.Map)moveMap.getOrElseUpdate(part.topic(), (Function0<scala.collection.mutable.HashMap> & Serializable & scala.Serializable)() -> new scala.collection.mutable.HashMap());
            SetLike setLike = (SetLike)Set$.MODULE$.apply(Nil$.MODULE$);
            Option option = partMoves.get(BoxesRunTime.boxToInteger(part.partition()));
            if (option instanceof Some) {
                seq = ((ReassignPartitionsCommand.PartitionMove)((Some)option).value()).sources().toSeq();
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                seq = (Seq)currentParts.getOrElse(part, (Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(53).append("Trying to reassign a topic partition ").append(part).append(" with 0 replicas").toString());
                });
            }
            Object sources = setLike.$plus$plus(seq);
            Object destinations = ((SetLike)Set$.MODULE$.apply(Nil$.MODULE$)).$plus$plus((GenTraversableOnce)replicas.diff(sources.toSeq()));
            return partMoves.put(BoxesRunTime.boxToInteger(part.partition()), new ReassignPartitionsCommand.PartitionMove((Set<Object>)sources, (Set<Object>)destinations));
        });
        return moveMap;
    }

    public Map<String, String> calculateLeaderThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return moveMap.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topicName = (String)x0$1._1();
            scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
            TreeSet<String> components = new TreeSet<String>(Ordering$String$.MODULE$);
            partMoveMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
                ReassignPartitionsCommand$.$anonfun$calculateLeaderThrottles$2(components, x0$2);
                return BoxedUnit.UNIT;
            });
            Tuple2<String, String> tuple2 = new Tuple2<String, String>(topicName, components.mkString(","));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, String> calculateFollowerThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return moveMap.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topicName = (String)x0$1._1();
            scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
            TreeSet<String> components = new TreeSet<String>(Ordering$String$.MODULE$);
            partMoveMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
                ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$2(components, x0$2);
                return BoxedUnit.UNIT;
            });
            Tuple2<String, String> tuple2 = new Tuple2<String, String>(topicName, components.mkString(","));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Set<Object> calculateReassigningBrokers(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        TreeSet<Object> reassigningBrokers = new TreeSet<Object>(Ordering$Int$.MODULE$);
        moveMap.values().foreach((Function1<scala.collection.mutable.Map, Object> & Serializable & scala.Serializable)x$33 -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$1(reassigningBrokers, x$33);
            return BoxedUnit.UNIT;
        });
        return reassigningBrokers.toSet();
    }

    public scala.collection.immutable.Set<Object> calculateMovingBrokers(scala.collection.immutable.Set<TopicPartitionReplica> replicaMoves) {
        return replicaMoves.map((Function1<TopicPartitionReplica, Object> & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToInteger(x$34.brokerId()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
    }

    public void modifyTopicThrottles(Admin adminClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        HashMap<ConfigResource, Collection<AlterConfigOp>> configs = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
        leaderThrottles.keySet().$plus$plus(followerThrottles.keySet()).foreach((Function1<String, Object> & Serializable & scala.Serializable)topicName -> {
            ArrayList ops = new ArrayList();
            leaderThrottles.get((String)topicName).foreach((Function1<String, Object> & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean(ops.add(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), value), AlterConfigOp.OpType.SET))));
            followerThrottles.get((String)topicName).foreach((Function1<String, Object> & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean(ops.add(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), value), AlterConfigOp.OpType.SET))));
            if (!ops.isEmpty()) {
                return configs.put(new ConfigResource(ConfigResource.Type.TOPIC, (String)topicName), ops);
            }
            return BoxedUnit.UNIT;
        });
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    public void modifyTopicThrottles(KafkaZkClient zkClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        leaderThrottles.keySet().$plus$plus(followerThrottles.keySet()).foreach((Function1<String, Object> & Serializable & scala.Serializable)topicName -> {
            ReassignPartitionsCommand$.$anonfun$modifyTopicThrottles$4(adminZkClient, leaderThrottles, followerThrottles, topicName);
            return BoxedUnit.UNIT;
        });
    }

    private void modifyReassignmentThrottle(Admin admin, scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap, long interBrokerThrottle) {
        Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
        Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
        this.modifyTopicThrottles(admin, leaderThrottles, followerThrottles);
        scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
        this.modifyInterBrokerThrottle(admin, reassigningBrokers, interBrokerThrottle);
    }

    public void modifyInterBrokerThrottle(Admin adminClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle) {
        if (interBrokerThrottle >= 0L) {
            HashMap<ConfigResource, Collection<AlterConfigOp>> configs = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
            reassigningBrokers.foreach((Function1<Object, Collection> & Serializable & scala.Serializable)brokerId -> ReassignPartitionsCommand$.$anonfun$modifyInterBrokerThrottle$1(interBrokerThrottle, configs, BoxesRunTime.unboxToInt(brokerId)));
            adminClient.incrementalAlterConfigs(configs).all().get();
            Predef$.MODULE$.println(new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString());
        }
    }

    public void modifyLogDirThrottle(Admin admin, scala.collection.immutable.Set<Object> movingBrokers, long logDirThrottle) {
        if (logDirThrottle >= 0L) {
            HashMap<ConfigResource, Collection<AlterConfigOp>> configs = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
            movingBrokers.foreach((Function1<Object, Collection> & Serializable & scala.Serializable)brokerId -> ReassignPartitionsCommand$.$anonfun$modifyLogDirThrottle$1(logDirThrottle, configs, BoxesRunTime.unboxToInt(brokerId)));
            admin.incrementalAlterConfigs(configs).all().get();
            Predef$.MODULE$.println(new StringBuilder(52).append("The replica-alter-dir throttle limit was set to ").append(logDirThrottle).append(" B/s").toString());
        }
    }

    public void modifyBrokerThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        reassigningBrokers.foreach((JFunction1$mcVI$sp & scala.Serializable)id -> {
            Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(id));
            configs.put(MODULE$.brokerLevelLeaderThrottle(), Long.toString(interBrokerThrottle));
            configs.put(MODULE$.brokerLevelFollowerThrottle(), Long.toString(interBrokerThrottle));
            adminZkClient.changeBrokerConfig((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{id})), configs);
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> parseExecuteAssignmentArgs(String reassignmentJson) {
        void var4_4;
        void var3_3;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned = tuple2._1();
        Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        void partitionsToBeReassigned2 = var3_3;
        void replicaAssignment2 = var4_4;
        if (partitionsToBeReassigned2.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment list cannot be empty");
        }
        if (partitionsToBeReassigned2.exists((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$1(x$38)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates(partitionsToBeReassigned2.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = new Tuple2(tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$4 -> {
                if (x0$4 == null) {
                    throw new MatchError((Object)null);
                }
                TopicPartition tp = (TopicPartition)x0$4._1();
                Iterable duplicateReplicas = (Iterable)x0$4._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{tp, duplicateReplicas.mkString(",")}));
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatesMsg})));
        }
        return new Tuple2(partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()), replicaAssignment2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<scala.collection.immutable.Set<TopicPartition>, scala.collection.immutable.Set<TopicPartitionReplica>> cancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, long timeoutMs, Time time) {
        void var9_8;
        void var8_7;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts = tuple2._1();
        Map<TopicPartitionReplica, String> targetReplicas = tuple2._2();
        void targetParts2 = var8_7;
        void targetReplicas2 = var9_8;
        scala.collection.immutable.Set targetPartsSet = ((TraversableOnce)targetParts2.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x$40 -> (TopicPartition)x$40._1(), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set<TopicPartition> curReassigningParts = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.listPartitionReassignments(CollectionConverters$.MODULE$.setAsJavaSetConverter(targetPartsSet).asJava()).reassignments().get()).asScala()).flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
            Iterable<Serializable> iterable = !reassignment.addingReplicas().isEmpty() || !reassignment.removingReplicas().isEmpty() ? Option$.MODULE$.option2Iterable(new Some<TopicPartition>(part)) : Option$.MODULE$.option2Iterable(None$.MODULE$);
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
        if (curReassigningParts.nonEmpty()) {
            Map<TopicPartition, Throwable> errors = this.cancelPartitionReassignments(adminClient, curReassigningParts);
            if (errors.nonEmpty()) {
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(new StringOps(Predef$.MODULE$.augmentString("Error cancelling partition reassignment%s for:%n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{errors.size() == 1 ? "" : "s", ((TraversableOnce)((TraversableLike)errors.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1<TopicPartition, String> & Serializable & scala.Serializable)part -> new StringBuilder(2).append(part).append(": ").append(((Throwable)errors.apply((TopicPartition)part)).getMessage()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator())})));
            }
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Successfully cancelled partition reassignment%s for: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{curReassigningParts.size() == 1 ? "" : "s", String.valueOf(((TraversableOnce)curReassigningParts.toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(","))})));
        } else {
            Predef$.MODULE$.println("None of the specified partition reassignments are active.");
        }
        scala.collection.immutable.Map<TopicPartitionReplica, String> curMovingParts = ((TraversableOnce)this.findLogDirMoveStates(adminClient, (Map<TopicPartitionReplica, String>)targetReplicas2).flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$2 -> {
            Iterable<Serializable> iterable;
            if (x0$2 != null) {
                TopicPartitionReplica part = (TopicPartitionReplica)x0$2._1();
                ReassignPartitionsCommand.LogDirMoveState moveState = (ReassignPartitionsCommand.LogDirMoveState)x0$2._2();
                if (moveState instanceof ReassignPartitionsCommand.ActiveMoveState) {
                    ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)moveState;
                    iterable = Option$.MODULE$.option2Iterable(new Some<Tuple2<TopicPartitionReplica, String>>(new Tuple2<TopicPartitionReplica, String>(part, activeMoveState.currentLogDir())));
                } else {
                    iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
                }
            } else {
                throw new MatchError((Object)null);
            }
            return iterable;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (curMovingParts.isEmpty()) {
            Predef$.MODULE$.println("None of the specified partition moves are active.");
        } else {
            this.executeMoves(adminClient, curMovingParts, timeoutMs, time);
        }
        if (!preserveThrottles) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)targetParts2);
        }
        return new Tuple2<scala.collection.immutable.Set<TopicPartition>, scala.collection.immutable.Set<TopicPartitionReplica>>(curReassigningParts, curMovingParts.keySet());
    }

    public long cancelAssignment$default$4() {
        return 10000L;
    }

    public Time cancelAssignment$default$5() {
        return Time.SYSTEM;
    }

    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partitions"), CollectionConverters$.MODULE$.bufferAsJavaListConverter(((TraversableLike)partitionsToBeReassigned.keySet().toBuffer().sortWith((Function2<TopicPartition, TopicPartition, Object> & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1<TopicPartition, java.util.Map> & Serializable & scala.Serializable)tp -> {
            Seq replicas = (Seq)partitionsToBeReassigned.apply((TopicPartition)tp);
            return CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("topic"), tp.topic()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partition"), BoxesRunTime.boxToInteger(tp.partition())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("replicas"), CollectionConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("log_dirs"), CollectionConverters$.MODULE$.seqAsJavaListConverter(replicas.map((Function1<Object, String> & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$3(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt(r)), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava();
        }, Buffer$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt(((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parseTopicsData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestTopicsJsonVersion();
            }
            return this.parseTopicsData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                return Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1<JsonValue, Iterator> & Serializable & scala.Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1<JsonValue, String> & Serializable & scala.Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseFull(jsonData);
        if (either instanceof Right) {
            int n;
            JsonValue js = (JsonValue)((Right)either).value();
            Option<JsonValue> option = js.asJsonObject().get("version");
            if (option instanceof Some) {
                n = BoxesRunTime.unboxToInt(((JsonValue)((Some)option).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parsePartitionReassignmentData(n, js);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                n = this.EarliestVersion();
            }
            return this.parsePartitionReassignmentData(n, js);
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        JsonProcessingException f = (JsonProcessingException)((Left)either).value();
        throw new AdminOperationException(f);
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        switch (version) {
            case 1: {
                ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
                GenMap replicaAssignment = Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach(arg_0 -> ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1$adapted(partitionAssignment, (scala.collection.mutable.Map)replicaAssignment, arg_0));
                return new Tuple2<ListBuffer, GenMap>(partitionAssignment, replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.helpText());
        $colon$colon<Nothing$> validActions = new $colon$colon<Nothing$>((Nothing$)((Object)opts.generateOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.executeOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.verifyOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.cancelOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.listOpt()), Nil$.MODULE$)))));
        Seq allActions = (Seq)validActions.filter(arg_0 -> ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1$adapted(opts.options(), arg_0));
        if (allActions.size() != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringOps(Predef$.MODULE$.augmentString("Command must include exactly one action: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((TraversableOnce)validActions.map((Function1<OptionSpecBuilder, String> & Serializable & scala.Serializable)x$43 -> new StringBuilder(2).append("--").append(x$43.options().get(0)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        OptionSpecBuilder action = (OptionSpecBuilder)allActions.apply(false);
        if (!opts.options().has(opts.zkConnectOpt()) && !opts.options().has(opts.bootstrapServerOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Please specify --bootstrap-server");
        }
        Map requiredArgs = (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.verifyOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.reassignmentJsonFileOpt()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.generateOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.topicsToMoveJsonFileOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.brokerListOpt()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.executeOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.reassignmentJsonFileOpt()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.cancelOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.reassignmentJsonFileOpt()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.listOpt()), Nil$.MODULE$)}));
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq)requiredArgs.apply(action));
        Map permittedArgs = (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.verifyOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.bootstrapServerOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.commandConfigOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.preserveThrottlesOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.zkConnectOpt()), Nil$.MODULE$))))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.generateOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.bootstrapServerOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.brokerListOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.commandConfigOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.disableRackAware()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.zkConnectOpt()), Nil$.MODULE$)))))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.executeOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.additionalOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.bootstrapServerOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.commandConfigOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.interBrokerThrottleOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.replicaAlterLogDirsThrottleOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.timeoutOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.zkConnectOpt()), Nil$.MODULE$)))))))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.cancelOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.bootstrapServerOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.commandConfigOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.preserveThrottlesOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.timeoutOpt()), Nil$.MODULE$))))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(opts.listOpt()), new $colon$colon<Nothing$>((Nothing$)((Object)opts.bootstrapServerOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.commandConfigOpt()), Nil$.MODULE$)))}));
        opts.options().specs().forEach(opt -> {
            if (!(opt.equals(action) || ((SeqLike)requiredArgs.apply(action)).contains(opt) || ((SeqLike)permittedArgs.apply(action)).contains(opt))) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringOps(Predef$.MODULE$.augmentString("Option \"%s\" can't be used with action \"%s\"")).format(Predef$.MODULE$.genericWrapArray(new Object[]{opt, action})));
            }
        });
        if (!opts.options().has(opts.bootstrapServerOpt())) {
            new $colon$colon<Nothing$>((Nothing$)((Object)opts.additionalOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.cancelOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.commandConfigOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.replicaAlterLogDirsThrottleOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.listOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.timeoutOpt()), Nil$.MODULE$)))))).foreach((Function1<AbstractOptionSpec, Object> & Serializable & scala.Serializable)opt -> {
                ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$4(opts, opt);
                return BoxedUnit.UNIT;
            });
        }
        return var2_2;
    }

    public scala.collection.immutable.Set<TopicPartitionReplica> alterReplicaLogDirs(Admin adminClient, Map<TopicPartitionReplica, String> assignment) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterReplicaLogDirs(CollectionConverters$.MODULE$.mapAsJavaMapConverter(assignment).asJava()).values()).asScala()).flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            Iterable<Serializable> iterable;
            if (x0$1 != null) {
                TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    iterable = Option$.MODULE$.option2Iterable(new Some<TopicPartitionReplica>(replica));
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (!(throwable instanceof ReplicaNotAvailableException)) {
                        if (throwable != null) {
                            throw new AdminCommandFailedException(new StringBuilder(24).append("Failed to alter dir for ").append(replica).toString(), throwable);
                        }
                        throw new MatchError((Object)null);
                    }
                    Iterable<Nothing$> iterable2 = Option$.MODULE$.option2Iterable(None$.MODULE$);
                    iterable = iterable2;
                }
            } else {
                throw new MatchError((Object)null);
            }
            Iterable<TopicPartitionReplica> iterable3 = iterable;
            return iterable3;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ void $anonfun$partitionReassignmentStatesToString$2(Map states$1, ArrayBuffer bld$1, TopicPartition topicPartition) {
        ReassignPartitionsCommand.PartitionReassignmentState state = (ReassignPartitionsCommand.PartitionReassignmentState)states$1.apply(topicPartition);
        if (state.done()) {
            if (state.currentReplicas().equals(state.targetReplicas())) {
                bld$1.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition.toString()}))}));
                return;
            }
            bld$1.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(80).append("There is no active reassignment of partition ").append(topicPartition).append(", ").append("but replica set is ").append(state.currentReplicas().mkString(",")).append(" rather than ").append(state.targetReplicas().mkString(",")).append(".").toString()}));
            return;
        }
        bld$1.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition}))}));
    }

    public static final /* synthetic */ boolean $anonfun$findPartitionReassignmentStates$1(scala.collection.mutable.Map currentReassignments$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        TopicPartition part = (TopicPartition)x0$1._1();
        boolean bl = currentReassignments$1.contains(part);
        return bl;
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$3(Integer i) {
        return BoxesRunTime.unboxToInt(i);
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$6(Integer x$10) {
        return BoxesRunTime.unboxToInt(x$10);
    }

    public static final /* synthetic */ void $anonfun$findPartitionReassignmentStates$8(KafkaZkClient zkClient$1, scala.collection.mutable.HashMap results$1, Map partitionsBeingReassigned$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            Map partitions = (Map)x0$1._2();
            Map<TopicPartition, Seq<Object>> replicasForTopic = zkClient$1.getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
            partitions.foreach((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError((Object)null);
                }
                TopicPartition partition = (TopicPartition)x0$2._1();
                Seq targetReplicas = (Seq)x0$2._2();
                Seq currentReplicas = (Seq)replicasForTopic.getOrElse(partition, (Function0<Seq> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                Option<ReassignPartitionsCommand.PartitionReassignmentState> option = results$1.put(partition, new ReassignPartitionsCommand.PartitionReassignmentState(currentReplicas, targetReplicas, !partitionsBeingReassigned$1.contains(partition)));
                return option;
            });
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$replicaMoveStatesToString$2(Map states$2, ArrayBuffer bld$2, TopicPartitionReplica replica) {
        ReassignPartitionsCommand.LogDirMoveState state = (ReassignPartitionsCommand.LogDirMoveState)states$2.apply(replica);
        if (state instanceof ReassignPartitionsCommand.MissingLogDirMoveState) {
            bld$2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(112).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found ").append("in any live log dir on broker ").append(replica.brokerId()).append(". There is likely an ").append("offline log directory on the broker.").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.MissingReplicaMoveState) {
            bld$2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(65).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" cannot be found ").append("in any live log directory on broker ").append(replica.brokerId()).append(".").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.ActiveMoveState) {
            String futureLogDir;
            ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)state;
            String targetLogDir = activeMoveState.targetLogDir();
            if (targetLogDir.equals(futureLogDir = activeMoveState.futureLogDir())) {
                bld$2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(46).append("Reassignment of replica ").append(replica).append(" is still in progress.").toString()}));
                return;
            }
            bld$2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(62).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" is being moved to log dir ").append(futureLogDir).append(" ").append("instead of ").append(targetLogDir).append(".").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.CancelledMoveState) {
            ReassignPartitionsCommand.CancelledMoveState cancelledMoveState = (ReassignPartitionsCommand.CancelledMoveState)state;
            String currentLogDir = cancelledMoveState.currentLogDir();
            String targetLogDir = cancelledMoveState.targetLogDir();
            bld$2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(60).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" is not being moved from log dir ").append(currentLogDir).append(" to ").append(targetLogDir).append(".").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.CompletedMoveState) {
            bld$2.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(48).append("Reassignment of replica ").append(replica).append(" completed successfully.").toString()}));
            return;
        }
        throw new MatchError(state);
    }

    public static final /* synthetic */ void $anonfun$clearTopicLevelThrottles$3(AdminZkClient adminZkClient$2, String topic) {
        Properties configs = adminZkClient$2.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        if (((TraversableOnce)MODULE$.topicLevelThrottles().flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)throttle -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(configs.remove(throttle))), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            adminZkClient$2.changeTopicConfig(topic, configs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadata$3(BrokerMetadata x$25) {
        return x$25.rack().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$parseGenerateAssignmentArgs$1(String x$26) {
        return new StringOps(Predef$.MODULE$.augmentString(x$26)).toInt();
    }

    public static final /* synthetic */ Nothing$ $anonfun$verifyBrokerIds$3(int id) {
        throw new AdminCommandFailedException(new StringBuilder(18).append("Unknown broker id ").append(id).toString());
    }

    public static final /* synthetic */ boolean $anonfun$currentPartitionReplicaAssignmentToString$1(Map proposedParts$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        TopicPartition k = (TopicPartition)x0$1._1();
        boolean bl = proposedParts$1.contains(k);
        return bl;
    }

    public static final /* synthetic */ int $anonfun$calculateCurrentMoveMap$2(Object x) {
        return BoxesRunTime.unboxToInt(x);
    }

    public static final /* synthetic */ int $anonfun$calculateCurrentMoveMap$3(Object x) {
        return BoxesRunTime.unboxToInt(x);
    }

    public static final /* synthetic */ void $anonfun$calculateLeaderThrottles$2(TreeSet components$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int partId = x0$2._1$mcI$sp();
            ((ReassignPartitionsCommand.PartitionMove)x0$2._2()).sources().foreach((JFunction1$mcZI$sp & scala.Serializable)source -> components$1.add(new StringOps(Predef$.MODULE$.augmentString("%d:%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partId), BoxesRunTime.boxToInteger(source)}))));
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ Object $anonfun$calculateFollowerThrottles$3(ReassignPartitionsCommand.PartitionMove move$1, TreeSet components$2, int partId$2, int destination) {
        if (!move$1.sources().contains(BoxesRunTime.boxToInteger(destination))) {
            return BoxesRunTime.boxToBoolean(components$2.add(new StringOps(Predef$.MODULE$.augmentString("%d:%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partId$2), BoxesRunTime.boxToInteger(destination)}))));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$calculateFollowerThrottles$2(TreeSet components$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            int partId = x0$2._1$mcI$sp();
            ReassignPartitionsCommand.PartitionMove move = (ReassignPartitionsCommand.PartitionMove)x0$2._2();
            move.destinations().foreach((Function1<Object, Object> & Serializable & scala.Serializable)destination -> ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$3(move, components$2, partId, BoxesRunTime.unboxToInt(destination)));
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$2(TreeSet reassigningBrokers$1, ReassignPartitionsCommand.PartitionMove partMove) {
        partMove.sources().foreach((JFunction1$mcZI$sp & scala.Serializable)elem -> reassigningBrokers$1.add(BoxesRunTime.boxToInteger(elem)));
        partMove.destinations().foreach((JFunction1$mcZI$sp & scala.Serializable)elem -> reassigningBrokers$1.add(BoxesRunTime.boxToInteger(elem)));
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$1(TreeSet reassigningBrokers$1, scala.collection.mutable.Map x$33) {
        x$33.values().foreach((Function1<ReassignPartitionsCommand.PartitionMove, Object> & Serializable & scala.Serializable)partMove -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$2(reassigningBrokers$1, partMove);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$modifyTopicThrottles$4(AdminZkClient adminZkClient$3, Map leaderThrottles$2, Map followerThrottles$2, String topicName) {
        Properties configs = adminZkClient$3.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topicName);
        leaderThrottles$2.get(topicName).map((Function1<String, Object> & Serializable & scala.Serializable)x$35 -> configs.put(MODULE$.topicLevelLeaderThrottle(), x$35));
        followerThrottles$2.get(topicName).map((Function1<String, Object> & Serializable & scala.Serializable)x$36 -> configs.put(MODULE$.topicLevelFollowerThrottle(), x$36));
        adminZkClient$3.changeTopicConfig(topicName, configs);
    }

    public static final /* synthetic */ Collection $anonfun$modifyInterBrokerThrottle$1(long interBrokerThrottle$1, HashMap configs$5, int brokerId) {
        ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
        ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLeaderThrottle(), Long.toString(interBrokerThrottle$1)), AlterConfigOp.OpType.SET));
        ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelFollowerThrottle(), Long.toString(interBrokerThrottle$1)), AlterConfigOp.OpType.SET));
        return configs$5.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId)), ops);
    }

    public static final /* synthetic */ Collection $anonfun$modifyLogDirThrottle$1(long logDirThrottle$1, HashMap configs$6, int brokerId) {
        ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
        ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLogDirThrottle(), Long.toString(logDirThrottle$1)), AlterConfigOp.OpType.SET));
        return configs$6.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId)), ops);
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$1(Tuple2 x$38) {
        return ((SeqLike)x$38._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = ((Iterable)x0$3._2()).nonEmpty();
        return bl;
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$3(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse(new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$42) {
        Object T2 = x$42._2();
        String string = MODULE$.AnyLogDir();
        return T2 == null ? string != null : !T2.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1<JsonValue, scala.collection.mutable.Map> & Serializable & scala.Serializable)p -> {
            Seq seq;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt(partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                seq = ((JsonValue)((Some)option).value()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            } else if (None$.MODULE$.equals(option)) {
                seq = newReplicas.map((Function1<Object, String> & Serializable & scala.Serializable)x$41 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            if (newReplicas.size() != seq.size()) {
                throw new AdminCommandFailedException(new StringBuilder(78).append("Size of replicas list ").append(newReplicas).append(" is different from ").append("size of log dirs list ").append(seq).append(" for partition ").append(new TopicPartition(topic, partition)).toString());
            }
            partitionAssignment$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(topic, partition)), newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip(seq, Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                int replica = x0$1._1$mcI$sp();
                String logDir = (String)x0$1._2();
                Tuple2<TopicPartitionReplica, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartitionReplica(topic, partition, replica)), logDir);
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$42))));
        });
    }

    public static final /* synthetic */ void $anonfun$validateAndParseArgs$4(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1, AbstractOptionSpec opt) {
        if (opts$1.options().has(opt)) {
            throw new RuntimeException(new StringBuilder(36).append("You must specify --bootstrap-server ").append(new StringOps(Predef$.MODULE$.augmentString("when using \"%s\"")).format(Predef$.MODULE$.genericWrapArray(new Object[]{opt}))).toString());
        }
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.AnyLogDir = "any";
        this.helpText = "This tool helps to move topic partitions between replicas.";
        this.EarliestVersion = 1;
        this.EarliestTopicsJsonVersion = 1;
        this.brokerLevelLeaderThrottle = DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp();
        this.brokerLevelFollowerThrottle = DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp();
        this.brokerLevelLogDirThrottle = DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp();
        this.brokerLevelThrottles = new $colon$colon<Nothing$>((Nothing$)((Object)this.brokerLevelLeaderThrottle()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.brokerLevelFollowerThrottle()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.brokerLevelLogDirThrottle()), Nil$.MODULE$)));
        this.topicLevelLeaderThrottle = LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp();
        this.topicLevelFollowerThrottle = LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp();
        this.topicLevelThrottles = new $colon$colon<Nothing$>((Nothing$)((Object)this.topicLevelLeaderThrottle()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.topicLevelFollowerThrottle()), Nil$.MODULE$));
        this.cannotExecuteBecauseOfExistingMessage = "Cannot execute because there is an existing partition assignment.  Use --additional to override this and create a new partition assignment in addition to the existing one. The --additional flag can also be used to change the throttle by resubmitting the current reassignment.";
        this.youMustRunVerifyPeriodicallyMessage = "Warning: You must run --verify periodically, until the reassignment completes, to ensure the throttle is removed.";
    }

    public static final /* synthetic */ Object $anonfun$parsePartitionReassignmentData$1$adapted(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment$1, replicaAssignment$1, partitionsSeq);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$validateAndParseArgs$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.has(x$1));
    }
}

