/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.OptionException;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$ConsumerGroupService$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.pinot.shaded.org.apache.kafka.common.ConsumerGroupState;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Map;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ConsumerGroupCommand$
implements Logging {
    public static ConsumerGroupCommand$ MODULE$;
    private final String MISSING_COLUMN_VALUE;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsumerGroupCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        try {
            opts.checkArgs();
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
            if (new $colon$colon<Nothing$>((Nothing$)((Object)opts.listOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.describeOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.deleteOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.resetOffsetsOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)opts.deleteOffsetsOpt()), Nil$.MODULE$))))).count(arg_0 -> ConsumerGroupCommand$.$anonfun$main$1$adapted(opts.options(), arg_0)) != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets");
            }
            this.run(opts);
            return;
        }
        catch (OptionException e) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), e.getMessage());
        }
    }

    public void run(ConsumerGroupCommand.ConsumerGroupCommandOptions opts) {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts, ConsumerGroupCommand$ConsumerGroupService$.MODULE$.$lessinit$greater$default$2());){
            try {
                if (opts.options().has(opts.listOpt())) {
                    consumerGroupService.listGroups();
                } else if (opts.options().has(opts.describeOpt())) {
                    consumerGroupService.describeGroups();
                } else if (opts.options().has(opts.deleteOpt())) {
                    consumerGroupService.deleteGroups();
                } else if (opts.options().has(opts.resetOffsetsOpt())) {
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options().has(opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                        Predef$.MODULE$.println(exported);
                    } else {
                        this.printOffsetsToReset(offsetsToReset);
                    }
                } else if (opts.options().has(opts.deleteOffsetsOpt())) {
                    consumerGroupService.deleteOffsets();
                }
            }
            catch (IllegalArgumentException e) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), e.getMessage());
            }
            catch (Throwable e) {
                this.printError(new StringBuilder(47).append("Executing consumer group command failed due to ").append(e.getMessage()).toString(), new Some<Throwable>(e));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Set<ConsumerGroupState> consumerGroupStatesFromString(String input) {
        void var2_2;
        GenSet parsedStates = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(input)).split(','))).map((Function1<String, ConsumerGroupState> & Serializable & scala.Serializable)s -> ConsumerGroupState.parse(s.trim()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConsumerGroupState.class))))).toSet();
        if (parsedStates.contains(ConsumerGroupState.UNKNOWN)) {
            ConsumerGroupState[] validStates = (ConsumerGroupState[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ConsumerGroupState.values())).filter((Function1<ConsumerGroupState, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ConsumerGroupCommand$.$anonfun$consumerGroupStatesFromString$2(x$1)));
            throw new IllegalArgumentException(new StringBuilder(41).append("Invalid state list '").append(input).append("'. Valid states are: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])validStates)).mkString(", ")).toString());
        }
        return var2_2;
    }

    public String MISSING_COLUMN_VALUE() {
        return this.MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        Predef$.MODULE$.println(new StringBuilder(8).append("\nError: ").append(msg).toString());
        e.foreach((Function1<Throwable, Object> & Serializable & scala.Serializable)x$2 -> {
            x$2.printStackTrace();
            return BoxedUnit.UNIT;
        });
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        if (groupAssignmentsToReset.nonEmpty()) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("\n%-30s %-30s %-10s %-15s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"GROUP", "TOPIC", "PARTITION", "NEW-OFFSET"})));
        }
        groupAssignmentsToReset.withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$1 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$consumerGroupStatesFromString$2(ConsumerGroupState x$1) {
        ConsumerGroupState consumerGroupState = x$1;
        ConsumerGroupState consumerGroupState2 = ConsumerGroupState.UNKNOWN;
        return consumerGroupState == null ? consumerGroupState2 != null : !((Object)((Object)consumerGroupState)).equals((Object)consumerGroupState2);
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$4(String groupId$1, Tuple2 x$3) {
        if (x$3 != null) {
            TopicPartition consumerAssignment = (TopicPartition)x$3._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)x$3._2();
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%-30s %-30s %-10s %-15s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{groupId$1, consumerAssignment.topic(), BoxesRunTime.boxToInteger(consumerAssignment.partition()), BoxesRunTime.boxToLong(offsetAndMetadata.offset())})));
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$2(Tuple2 x$4) {
        if (x$4 != null) {
            String groupId = (String)x$4._1();
            ((Map)x$4._2()).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$2 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$3 -> {
                ConsumerGroupCommand$.$anonfun$printOffsetsToReset$4(groupId, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)null);
    }

    private ConsumerGroupCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MISSING_COLUMN_VALUE = "-";
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.has(x$1));
    }
}

