/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.json;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;

public class JSONRecordExtractor
extends BaseRecordExtractor<Map<String, Object>> {
    private Set<String> _fields;
    private boolean _extractAll = false;

    public void init(Set<String> fields, @Nullable RecordExtractorConfig recordExtractorConfig) {
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Collections.emptySet();
        } else {
            this._fields = ImmutableSet.copyOf(fields);
        }
    }

    public GenericRow extract(Map<String, Object> from, GenericRow to) {
        if (this._extractAll) {
            for (Map.Entry<String, Object> fieldToVal : from.entrySet()) {
                Object value = fieldToVal.getValue();
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(fieldToVal.getKey(), value);
            }
        } else {
            for (String fieldName : this._fields) {
                Object value = from.get(fieldName);
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(fieldName, value);
            }
        }
        return to;
    }
}

