/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.pinot.shaded.org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.UpdateFeaturesResponse;

public class UpdateFeaturesRequest
extends AbstractRequest {
    private final UpdateFeaturesRequestData data;

    public UpdateFeaturesRequest(UpdateFeaturesRequestData data, short version) {
        super(ApiKeys.UPDATE_FEATURES, version);
        this.data = data;
    }

    @Override
    public UpdateFeaturesResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return UpdateFeaturesResponse.createWithErrors(ApiError.fromThrowable(e), Collections.emptyMap(), throttleTimeMs);
    }

    @Override
    public UpdateFeaturesRequestData data() {
        return this.data;
    }

    public static UpdateFeaturesRequest parse(ByteBuffer buffer, short version) {
        return new UpdateFeaturesRequest(new UpdateFeaturesRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static boolean isDeleteRequest(UpdateFeaturesRequestData.FeatureUpdateKey update) {
        return update.maxVersionLevel() < 1 && update.allowDowngrade();
    }

    public static class Builder
    extends AbstractRequest.Builder<UpdateFeaturesRequest> {
        private final UpdateFeaturesRequestData data;

        public Builder(UpdateFeaturesRequestData data) {
            super(ApiKeys.UPDATE_FEATURES);
            this.data = data;
        }

        @Override
        public UpdateFeaturesRequest build(short version) {
            return new UpdateFeaturesRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

