/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.LeaveGroupResponse;

public class LeaveGroupRequest
extends AbstractRequest {
    private final LeaveGroupRequestData data;

    private LeaveGroupRequest(LeaveGroupRequestData data, short version) {
        super(ApiKeys.LEAVE_GROUP, version);
        this.data = data;
    }

    @Override
    public LeaveGroupRequestData data() {
        return this.data;
    }

    public List<LeaveGroupRequestData.MemberIdentity> members() {
        return this.version() <= 2 ? Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId(this.data.memberId())) : this.data.members();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        LeaveGroupResponseData responseData = new LeaveGroupResponseData().setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            responseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new LeaveGroupResponse(responseData);
    }

    public static LeaveGroupRequest parse(ByteBuffer buffer, short version) {
        return new LeaveGroupRequest(new LeaveGroupRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<LeaveGroupRequest> {
        private final String groupId;
        private final List<LeaveGroupRequestData.MemberIdentity> members;

        public Builder(String groupId, List<LeaveGroupRequestData.MemberIdentity> members) {
            this(groupId, members, ApiKeys.LEAVE_GROUP.oldestVersion(), ApiKeys.LEAVE_GROUP.latestVersion());
        }

        Builder(String groupId, List<LeaveGroupRequestData.MemberIdentity> members, short oldestVersion, short latestVersion) {
            super(ApiKeys.LEAVE_GROUP, oldestVersion, latestVersion);
            this.groupId = groupId;
            this.members = members;
            if (members.isEmpty()) {
                throw new IllegalArgumentException("leaving members should not be empty");
            }
        }

        @Override
        public LeaveGroupRequest build(short version) {
            LeaveGroupRequestData data;
            if (version >= 3) {
                data = new LeaveGroupRequestData().setGroupId(this.groupId).setMembers(this.members);
            } else {
                if (this.members.size() != 1) {
                    throw new UnsupportedVersionException("Version " + version + " leave group request only supports single member instance than " + this.members.size() + " members");
                }
                data = new LeaveGroupRequestData().setGroupId(this.groupId).setMemberId(this.members.get(0).memberId());
            }
            return new LeaveGroupRequest(data, version);
        }

        public String toString() {
            return "(type=LeaveGroupRequest, groupId=" + this.groupId + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
        }
    }
}

