/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ControlledShutdownResponse;

public class ControlledShutdownRequest
extends AbstractRequest {
    private final ControlledShutdownRequestData data;

    private ControlledShutdownRequest(ControlledShutdownRequestData data, short version) {
        super(ApiKeys.CONTROLLED_SHUTDOWN, version);
        this.data = data;
    }

    @Override
    public ControlledShutdownResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ControlledShutdownResponseData data = new ControlledShutdownResponseData().setErrorCode(Errors.forException(e).code());
        return new ControlledShutdownResponse(data);
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownRequest(new ControlledShutdownRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public ControlledShutdownRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<ControlledShutdownRequest> {
        private final ControlledShutdownRequestData data;

        public Builder(ControlledShutdownRequestData data, short desiredVersion) {
            super(ApiKeys.CONTROLLED_SHUTDOWN, desiredVersion);
            this.data = data;
        }

        @Override
        public ControlledShutdownRequest build(short version) {
            return new ControlledShutdownRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

