/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.network;

import java.util.Locale;
import java.util.Objects;
import org.apache.pinot.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;

public final class ListenerName {
    private static final String CONFIG_STATIC_PREFIX = "listener.name";
    private final String value;

    public static ListenerName forSecurityProtocol(SecurityProtocol securityProtocol) {
        return new ListenerName(securityProtocol.name);
    }

    public static ListenerName normalised(String value) {
        return new ListenerName(value.toUpperCase(Locale.ROOT));
    }

    public ListenerName(String value) {
        Objects.requireNonNull(value, "value should not be null");
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ListenerName)) {
            return false;
        }
        ListenerName that = (ListenerName)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ListenerName(" + this.value + ")";
    }

    public String configPrefix() {
        return "listener.name." + this.value.toLowerCase(Locale.ROOT) + ".";
    }

    public String saslMechanismConfigPrefix(String saslMechanism) {
        return this.configPrefix() + ListenerName.saslMechanismPrefix(saslMechanism);
    }

    public static String saslMechanismPrefix(String saslMechanism) {
        return saslMechanism.toLowerCase(Locale.ROOT) + ".";
    }
}

