/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.shaded.org.apache.kafka.common.Uuid;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DeleteTopicsResponseData
implements ApiMessage {
    int throttleTimeMs;
    DeletableTopicResultCollection responses;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("responses", new ArrayOf(DeletableTopicResult.SCHEMA_0), "The results for each topic we tried to delete."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public DeleteTopicsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteTopicsResponseData() {
        this.throttleTimeMs = 0;
        this.responses = new DeletableTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 20;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        DeletableTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            newCollection = new DeletableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeletableTopicResult(_readable, _version));
            }
            this.responses = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            newCollection = new DeletableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeletableTopicResult(_readable, _version));
            }
            this.responses = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.responses.size() + 1);
            for (DeletableTopicResult responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.responses.size());
            for (DeletableTopicResult responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.responses.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (DeletableTopicResult responsesElement : this.responses) {
            responsesElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteTopicsResponseData)) {
            return false;
        }
        DeleteTopicsResponseData other = (DeleteTopicsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        return hashCode;
    }

    @Override
    public DeleteTopicsResponseData duplicate() {
        DeleteTopicsResponseData _duplicate = new DeleteTopicsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        DeletableTopicResultCollection newResponses = new DeletableTopicResultCollection(this.responses.size());
        for (DeletableTopicResult _element : this.responses) {
            newResponses.add(_element.duplicate());
        }
        _duplicate.responses = newResponses;
        return _duplicate;
    }

    public String toString() {
        return "DeleteTopicsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", responses=" + MessageUtil.deepToString(this.responses.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DeletableTopicResultCollection responses() {
        return this.responses;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteTopicsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteTopicsResponseData setResponses(DeletableTopicResultCollection v) {
        this.responses = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new ArrayOf(DeletableTopicResult.SCHEMA_0), "The results for each topic we tried to delete.")));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new CompactArrayOf(DeletableTopicResult.SCHEMA_4), "The results for each topic we tried to delete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new CompactArrayOf(DeletableTopicResult.SCHEMA_5), "The results for each topic we tried to delete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_6 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new CompactArrayOf(DeletableTopicResult.SCHEMA_6), "The results for each topic we tried to delete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }

    public static class DeletableTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<DeletableTopicResult> {
        public DeletableTopicResultCollection() {
        }

        public DeletableTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeletableTopicResultCollection(Iterator<DeletableTopicResult> iterator2) {
            super(iterator2);
        }

        @Override
        public DeletableTopicResult find(String name) {
            DeletableTopicResult _key = new DeletableTopicResult();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<DeletableTopicResult> findAll(String name) {
            DeletableTopicResult _key = new DeletableTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public DeletableTopicResultCollection duplicate() {
            DeletableTopicResultCollection _duplicate = new DeletableTopicResultCollection(this.size());
            for (DeletableTopicResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class DeletableTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        Uuid topicId;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public DeletableTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeletableTopicResult() {
            this.name = "";
            this.topicId = Uuid.ZERO_UUID;
            this.errorCode = 0;
            this.errorMessage = null;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeletableTopicResult");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                if (_version < 6) throw new RuntimeException("non-nullable field name was serialized as null");
                this.name = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field name had invalid length " + length);
                }
                this.name = _readable.readString(length);
            }
            this.topicId = _version >= 6 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.errorCode = _readable.readShort();
            if (_version >= 5) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _readable.readString(length);
                }
            } else {
                this.errorMessage = null;
            }
            this._unknownTaggedFields = null;
            if (_version < 4) return;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (this.name == null) {
                if (_version < 6) throw new NullPointerException();
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.name);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 6) {
                _writable.writeUuid(this.topicId);
            }
            _writable.writeShort(this.errorCode);
            if (_version >= 5) {
                if (this.errorMessage == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.errorMessage);
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    _writable.writeByteArray(_stringBytes);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
                return;
            } else {
                if (_numTaggedFields <= 0) return;
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeletableTopicResult");
            }
            if (this.name == null) {
                if (_version >= 4) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'name' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.name, _stringBytes);
                if (_version >= 4) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 6) {
                _size.addBytes(16);
            }
            _size.addBytes(2);
            if (_version >= 5) {
                if (this.errorMessage == null) {
                    _size.addBytes(1);
                } else {
                    _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DeletableTopicResult)) {
                return false;
            }
            DeletableTopicResult other = (DeletableTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeletableTopicResult)) {
                return false;
            }
            DeletableTopicResult other = (DeletableTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public DeletableTopicResult duplicate() {
            DeletableTopicResult _duplicate = new DeletableTopicResult();
            _duplicate.name = this.name == null ? null : this.name;
            _duplicate.topicId = this.topicId;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "DeletableTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", topicId=" + this.topicId.toString() + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeletableTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public DeletableTopicResult setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public DeletableTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeletableTopicResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."))));
            SCHEMA_4 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_NULLABLE_STRING, "The topic name"), new Field("topic_id", Type.UUID, "the unique topic ID"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }
}

