/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.feature;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;

class BaseVersionRange {
    private final String minKeyLabel;
    private final short minValue;
    private final String maxKeyLabel;
    private final short maxValue;

    protected BaseVersionRange(String minKeyLabel, short minValue, String maxKeyLabel, short maxValue) {
        if (minValue < 1 || maxValue < 1 || maxValue < minValue) {
            throw new IllegalArgumentException(String.format("Expected minValue >= 1, maxValue >= 1 and maxValue >= minValue, but received minValue: %d, maxValue: %d", minValue, maxValue));
        }
        if (minKeyLabel.isEmpty()) {
            throw new IllegalArgumentException("Expected minKeyLabel to be non-empty.");
        }
        if (maxKeyLabel.isEmpty()) {
            throw new IllegalArgumentException("Expected maxKeyLabel to be non-empty.");
        }
        this.minKeyLabel = minKeyLabel;
        this.minValue = minValue;
        this.maxKeyLabel = maxKeyLabel;
        this.maxValue = maxValue;
    }

    public short min() {
        return this.minValue;
    }

    public short max() {
        return this.maxValue;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), BaseVersionRange.mapToString(this.toMap()));
    }

    public Map<String, Short> toMap() {
        return Utils.mkMap(Utils.mkEntry(this.minKeyLabel, this.min()), Utils.mkEntry(this.maxKeyLabel, this.max()));
    }

    private static String mapToString(Map<String, Short> map) {
        return map.entrySet().stream().map(entry -> String.format("%s:%d", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BaseVersionRange that = (BaseVersionRange)other;
        return Objects.equals(this.minKeyLabel, that.minKeyLabel) && this.minValue == that.minValue && Objects.equals(this.maxKeyLabel, that.maxKeyLabel) && this.maxValue == that.maxValue;
    }

    public int hashCode() {
        return Objects.hash(this.minKeyLabel, this.minValue, this.maxKeyLabel, this.maxValue);
    }

    public static short valueOrThrow(String key, Map<String, Short> versionRangeMap) {
        Short value = versionRangeMap.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("%s absent in [%s]", key, BaseVersionRange.mapToString(versionRangeMap)));
        }
        return value;
    }
}

