/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoBufUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoBufUtils.class);
    public static final String TMP_DIR_PREFIX = "pinot-protobuf";

    private ProtoBufUtils() {
    }

    public static InputStream getDescriptorFileInputStream(String descriptorFilePath) throws Exception {
        URI descriptorFileURI = URI.create(descriptorFilePath);
        String scheme = descriptorFileURI.getScheme();
        if (scheme == null) {
            scheme = "file";
        }
        if (PinotFSFactory.isSchemeSupported((String)scheme)) {
            PinotFS pinotFS = PinotFSFactory.create((String)scheme);
            Path localTmpDir = Files.createTempDirectory(TMP_DIR_PREFIX + System.currentTimeMillis(), new FileAttribute[0]);
            File protoDescriptorLocalFile = ProtoBufUtils.createLocalFile(descriptorFileURI, localTmpDir.toFile());
            LOGGER.info("Copying protocol buffer descriptor file from source: {} to dst: {}", (Object)descriptorFilePath, (Object)protoDescriptorLocalFile.getAbsolutePath());
            pinotFS.copyToLocalFile(descriptorFileURI, protoDescriptorLocalFile);
            return new FileInputStream(protoDescriptorLocalFile);
        }
        throw new RuntimeException(String.format("Scheme: %s not supported in PinotFSFactory for protocol buffer descriptor file: %s.", scheme, descriptorFilePath));
    }

    public static File createLocalFile(URI srcURI, File dstDir) {
        String sourceURIPath = srcURI.getPath();
        File dstFile = new File(dstDir, new File(sourceURIPath).getName());
        LOGGER.debug("Created empty local temporary file {} to copy protocol buffer descriptor {}", (Object)dstFile.getAbsolutePath(), (Object)srcURI);
        return dstFile;
    }
}

