/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufFieldInfo;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;

public class ProtoBufRecordExtractor
extends BaseRecordExtractor<Message> {
    private Set<String> _fields;
    private boolean _extractAll = false;

    public void init(@Nullable Set<String> fields, RecordExtractorConfig recordExtractorConfig) {
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Collections.emptySet();
        } else {
            this._fields = ImmutableSet.copyOf(fields);
        }
    }

    public GenericRow extract(Message from, GenericRow to) {
        Descriptors.Descriptor descriptor = from.getDescriptorForType();
        if (this._extractAll) {
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                Object fieldValue = from.getField(fieldDescriptor);
                if (fieldValue != null) {
                    fieldValue = this.convert(new ProtoBufFieldInfo(fieldValue, fieldDescriptor));
                }
                to.putValue(fieldDescriptor.getName(), fieldValue);
            }
        } else {
            for (String fieldName : this._fields) {
                Object fieldValue;
                Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(fieldName);
                Object object = fieldValue = fieldDescriptor != null ? from.getField(fieldDescriptor) : null;
                if (fieldValue != null) {
                    fieldValue = this.convert(new ProtoBufFieldInfo(fieldValue, descriptor.findFieldByName(fieldName)));
                }
                to.putValue(fieldName, fieldValue);
            }
        }
        return to;
    }

    protected boolean isRecord(Object value) {
        return ((ProtoBufFieldInfo)value).getFieldValue() instanceof Message;
    }

    protected boolean isMultiValue(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        return protoBufFieldInfo.getFieldValue() instanceof Collection && !protoBufFieldInfo.getFieldDescriptor().isMapField();
    }

    protected boolean isMap(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        return protoBufFieldInfo.getFieldValue() instanceof Collection && protoBufFieldInfo.getFieldDescriptor().isMapField();
    }

    @Nullable
    protected Object convertMap(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        Collection messages = (Collection)protoBufFieldInfo.getFieldValue();
        if (messages.isEmpty()) {
            return null;
        }
        List<Descriptors.FieldDescriptor> fieldDescriptors = protoBufFieldInfo.getFieldDescriptor().getMessageType().getFields();
        Descriptors.FieldDescriptor keyFieldDescriptor = fieldDescriptors.get(0);
        Descriptors.FieldDescriptor valueFieldDescriptor = fieldDescriptors.get(1);
        HashMap<Object, Object> convertedMap = new HashMap<Object, Object>();
        for (Message message : messages) {
            Object fieldKey = message.getField(keyFieldDescriptor);
            Object fieldValue = message.getField(valueFieldDescriptor);
            if (fieldKey == null) continue;
            Object convertedFieldValue = null;
            if (fieldValue != null) {
                convertedFieldValue = this.convert(new ProtoBufFieldInfo(fieldValue, valueFieldDescriptor));
            }
            if (convertedFieldValue == null) continue;
            convertedMap.put(this.convertSingleValue(new ProtoBufFieldInfo(fieldKey, keyFieldDescriptor)), convertedFieldValue);
        }
        return convertedMap;
    }

    @Nullable
    protected Object convertMultiValue(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        Collection fieldValues = (Collection)protoBufFieldInfo.getFieldValue();
        if (fieldValues.isEmpty()) {
            return null;
        }
        int numValues = fieldValues.size();
        Object[] array = new Object[numValues];
        int index = 0;
        for (Object fieldValue : fieldValues) {
            Object convertedValue = null;
            if (fieldValue != null) {
                convertedValue = this.convert(new ProtoBufFieldInfo(fieldValue, protoBufFieldInfo.getFieldDescriptor()));
            }
            if (convertedValue == null) continue;
            array[index++] = convertedValue;
        }
        if (index == numValues) {
            return array;
        }
        if (index == 0) {
            return null;
        }
        return Arrays.copyOf(array, index);
    }

    protected Object convertSingleValue(Object value) {
        Object fieldValue = ((ProtoBufFieldInfo)value).getFieldValue();
        if (fieldValue instanceof ByteString) {
            return ((ByteString)fieldValue).toByteArray();
        }
        if (fieldValue instanceof Number) {
            return fieldValue;
        }
        return fieldValue.toString();
    }

    @Nullable
    protected Object convertRecord(Object value) {
        ProtoBufFieldInfo record = (ProtoBufFieldInfo)value;
        Map<Descriptors.FieldDescriptor, Object> fields = ((Message)record.getFieldValue()).getAllFields();
        if (fields.isEmpty()) {
            return null;
        }
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object fieldValue = entry.getValue();
            if (fieldValue != null) {
                fieldValue = this.convert(new ProtoBufFieldInfo(fieldValue, fieldDescriptor));
            }
            convertedMap.put(fieldDescriptor.getName(), fieldValue);
        }
        return convertedMap;
    }
}

