/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import java.util.Map;
import org.apache.pinot.shaded.org.apache.kafka.common.cache.Cache;
import org.apache.pinot.shaded.org.apache.kafka.common.cache.LRUCache;
import org.apache.pinot.shaded.org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.Serializer;

public class KafkaProtobufSerializer<T extends Message>
extends AbstractKafkaProtobufSerializer<T>
implements Serializer<T> {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private boolean isKey;
    private Cache<Descriptors.Descriptor, ProtobufSchema> schemaCache;

    public KafkaProtobufSerializer() {
        this.schemaCache = new SynchronizedCache<Descriptors.Descriptor, ProtobufSchema>(new LRUCache(DEFAULT_CACHE_CAPACITY));
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.schemaCache = new SynchronizedCache<Descriptors.Descriptor, ProtobufSchema>(new LRUCache(DEFAULT_CACHE_CAPACITY));
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props, int cacheCapacity) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
        this.schemaCache = new SynchronizedCache<Descriptors.Descriptor, ProtobufSchema>(new LRUCache(cacheCapacity));
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaProtobufSerializerConfig(configs));
    }

    @Override
    public byte[] serialize(String topic, T record) {
        if (record == null) {
            return null;
        }
        ProtobufSchema schema = this.schemaCache.get(record.getDescriptorForType());
        if (schema == null) {
            schema = ProtobufSchemaUtils.getSchema(record);
            this.schemaCache.put(record.getDescriptorForType(), schema);
        }
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, schema), topic, this.isKey, record, schema);
    }

    @Override
    public void close() {
    }
}

