/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.pinot.shaded.org.apache.kafka.common.cache.Cache;
import org.apache.pinot.shaded.org.apache.kafka.common.config.ConfigException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaProtobufSerializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    protected boolean autoRegisterSchema;
    protected boolean useLatestVersion;
    protected ReferenceSubjectNameStrategy referenceSubjectNameStrategy;

    protected void configure(KafkaProtobufSerializerConfig config) {
        this.configureClientProperties(config, new ProtobufSchemaProvider());
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.useLatestVersion = config.useLatestVersion();
        this.referenceSubjectNameStrategy = config.referenceSubjectNameStrategyInstance();
    }

    protected KafkaProtobufSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufSerializerConfig(props);
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, String topic, boolean isKey, T object, ProtobufSchema schema) throws SerializationException {
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            schema = AbstractKafkaProtobufSerializer.resolveDependencies(this.schemaRegistry, this.autoRegisterSchema, this.useLatestVersion, this.latestVersions, this.referenceSubjectNameStrategy, topic, isKey, schema);
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Protobuf schema: ";
                id = this.schemaRegistry.register(subject, schema);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version: ";
                schema = (ProtobufSchema)this.lookupLatestVersion(subject, schema);
                id = this.schemaRegistry.getId(subject, schema);
            } else {
                restClientErrorMsg = "Error retrieving Protobuf schema: ";
                id = this.schemaRegistry.getId(subject, schema);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            MessageIndexes indexes = schema.toMessageIndexes(object.getDescriptorForType().getFullName());
            out.write(indexes.toByteArray());
            object.writeTo(out);
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Protobuf message", e);
        }
        catch (RestClientException e) {
            throw new SerializationException(restClientErrorMsg + schema, e);
        }
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, Cache<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        if (schema.dependencies().isEmpty() || !schema.references().isEmpty()) {
            return schema;
        }
        Schema s = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestVersions, strategy, topic, isKey, null, schema.rawSchema(), schema.dependencies());
        return schema.copy(s.getReferences());
    }

    private static Schema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, Cache<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, String name, ProtoFileElement protoFileElement, Map<String, ProtoFileElement> dependencies) throws IOException, RestClientException {
        String subject;
        Schema subschema;
        ArrayList<SchemaReference> references = new ArrayList<SchemaReference>();
        for (String dep : protoFileElement.getImports()) {
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestVersions, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        for (String dep : protoFileElement.getPublicImports()) {
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestVersions, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        ProtobufSchema schema = new ProtobufSchema(protoFileElement, references, dependencies);
        Integer id = null;
        Integer version = null;
        String string = subject = name != null ? strategy.subjectName(name, topic, isKey, schema) : null;
        if (subject != null) {
            if (autoRegisterSchema) {
                id = schemaRegistry.register(subject, schema);
            } else if (useLatestVersion) {
                schema = (ProtobufSchema)AbstractKafkaProtobufSerializer.lookupLatestVersion(schemaRegistry, subject, schema, latestVersions);
                id = schemaRegistry.getId(subject, schema);
            } else {
                id = schemaRegistry.getId(subject, schema);
            }
            version = schemaRegistry.getVersion(subject, schema);
        }
        return new Schema(subject, version, id, schema.schemaType(), schema.references(), schema.canonicalString());
    }
}

