/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(ProtobufSchemaProvider.class);

    @Override
    public String schemaType() {
        return "PROTOBUF";
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references) {
        try {
            return Optional.of(new ProtobufSchema(schemaString, references, this.resolveReferences(references), null, null));
        }
        catch (Exception e) {
            log.error("Could not parse Protobuf schema", e);
            return Optional.empty();
        }
    }
}

