/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ProtocolStringList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.MessageDefinition;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.ranges.IntRange;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.CaseFormat;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(ProtobufSchema.class);
    public static final String TYPE = "PROTOBUF";
    public static final String SERIALIZED_FORMAT = "serialized";
    public static final String PROTO2 = "proto2";
    public static final String PROTO3 = "proto3";
    public static final String DEFAULT_NAME = "default";
    public static final String MAP_ENTRY_SUFFIX = "Entry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final Location DEFAULT_LOCATION = Location.get("");
    private final ProtoFileElement schemaObj;
    private final Integer version;
    private final String name;
    private final List<SchemaReference> references;
    private final Map<String, ProtoFileElement> dependencies;
    private transient String canonicalString;
    private transient DynamicSchema dynamicSchema;
    private transient Descriptors.Descriptor descriptor;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();

    public ProtobufSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null, null);
    }

    public ProtobufSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, String name) {
        try {
            this.schemaObj = this.toProtoFile(schemaString);
            this.version = version;
            this.name = name;
            this.references = Collections.unmodifiableList(references);
            this.dependencies = Collections.unmodifiableMap(resolvedReferences.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toProtoFile((String)e.getValue()))));
        }
        catch (IllegalStateException e2) {
            log.error("Could not parse Protobuf schema " + schemaString + " with references " + references, e2);
            throw e2;
        }
    }

    public ProtobufSchema(ProtoFileElement protoFileElement, List<SchemaReference> references, Map<String, ProtoFileElement> dependencies) {
        this.schemaObj = protoFileElement;
        this.version = null;
        this.name = null;
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
    }

    public ProtobufSchema(Descriptors.Descriptor descriptor) {
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>();
        this.schemaObj = this.toProtoFile(descriptor.getFile(), dependencies);
        this.version = null;
        this.name = descriptor.getFullName();
        this.references = Collections.emptyList();
        this.dependencies = dependencies;
        this.descriptor = descriptor;
    }

    private ProtobufSchema(ProtoFileElement schemaObj, Integer version, String name, List<SchemaReference> references, Map<String, ProtoFileElement> dependencies, String canonicalString, DynamicSchema dynamicSchema, Descriptors.Descriptor descriptor) {
        this.schemaObj = schemaObj;
        this.version = version;
        this.name = name;
        this.references = references;
        this.dependencies = dependencies;
        this.canonicalString = canonicalString;
        this.dynamicSchema = dynamicSchema;
        this.descriptor = descriptor;
    }

    public ProtobufSchema copy() {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, this.references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    public ProtobufSchema copy(Integer version) {
        return new ProtobufSchema(this.schemaObj, version, this.name, this.references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    public ProtobufSchema copy(String name) {
        return new ProtobufSchema(this.schemaObj, this.version, name, this.references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    public ProtobufSchema copy(List<SchemaReference> references) {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    private ProtoFileElement toProtoFile(String schema) {
        try {
            return ProtoParser.Companion.parse(DEFAULT_LOCATION, schema);
        }
        catch (Exception e) {
            try {
                byte[] bytes = base64Decoder.decode(schema);
                return this.toProtoFile(DescriptorProtos.FileDescriptorProto.parseFrom(bytes));
            }
            catch (Exception pe) {
                throw new IllegalArgumentException("Could not parse Protobuf", e);
            }
        }
    }

    private ProtoFileElement toProtoFile(Descriptors.FileDescriptor file, Map<String, ProtoFileElement> dependencies) {
        for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
            String depName = dependency.getName();
            dependencies.put(depName, this.toProtoFile(dependency, dependencies));
        }
        return this.toProtoFile(file.toProto());
    }

    private ProtoFileElement toProtoFile(DescriptorProtos.FileDescriptorProto file) {
        OptionElement option;
        OptionElement.Kind kind;
        String packageName = file.getPackage();
        if ("".equals(packageName)) {
            packageName = null;
        }
        ProtoFile.Syntax syntax = null;
        switch (file.getSyntax()) {
            case "proto2": {
                syntax = ProtoFile.Syntax.PROTO_2;
                break;
            }
            case "proto3": {
                syntax = ProtoFile.Syntax.PROTO_3;
                break;
            }
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (DescriptorProtos.DescriptorProto md : file.getMessageTypeList()) {
            MessageElement message = this.toMessage(file, md);
            types.add(message);
        }
        for (DescriptorProtos.EnumDescriptorProto ed : file.getEnumTypeList()) {
            EnumElement enumer = this.toEnum(ed);
            types.add(enumer);
        }
        ImmutableList.Builder imports = ImmutableList.builder();
        ImmutableList.Builder publicImports = ImmutableList.builder();
        ProtocolStringList dependencyList = file.getDependencyList();
        HashSet<Integer> publicDependencyList = new HashSet<Integer>(file.getPublicDependencyList());
        for (int i = 0; i < dependencyList.size(); ++i) {
            String depName = (String)dependencyList.get(i);
            if (publicDependencyList.contains(i)) {
                publicImports.add(depName);
                continue;
            }
            imports.add(depName);
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (file.getOptions().hasJavaPackage()) {
            kind = OptionElement.Kind.STRING;
            option = new OptionElement("java_package", kind, file.getOptions().getJavaPackage(), false);
            options.add(option);
        }
        if (file.getOptions().hasJavaOuterClassname()) {
            kind = OptionElement.Kind.STRING;
            option = new OptionElement("java_outer_classname", kind, file.getOptions().getJavaOuterClassname(), false);
            options.add(option);
        }
        if (file.getOptions().hasJavaMultipleFiles()) {
            kind = OptionElement.Kind.BOOLEAN;
            option = new OptionElement("java_multiple_files", kind, file.getOptions().getJavaMultipleFiles(), false);
            options.add(option);
        }
        return new ProtoFileElement(DEFAULT_LOCATION, packageName, syntax, (List<String>)((Object)imports.build()), (List<String>)((Object)publicImports.build()), (List<? extends TypeElement>)((Object)types.build()), Collections.emptyList(), Collections.emptyList(), (List<OptionElement>)((Object)options.build()));
    }

    private MessageElement toMessage(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.DescriptorProto descriptor) {
        ReservedElement reservedElem;
        String name = descriptor.getName();
        log.trace("*** msg name: {}", (Object)name);
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder nested = ImmutableList.builder();
        ImmutableList.Builder reserved = ImmutableList.builder();
        LinkedHashMap oneofsMap = new LinkedHashMap();
        for (DescriptorProtos.OneofDescriptorProto oneofDescriptorProto : descriptor.getOneofDeclList()) {
            oneofsMap.put(oneofDescriptorProto.getName(), ImmutableList.builder());
        }
        ArrayList oneofs = new ArrayList(oneofsMap.entrySet());
        for (DescriptorProtos.FieldDescriptorProto fieldDescriptorProto : descriptor.getFieldList()) {
            FieldElement field;
            if (fieldDescriptorProto.hasOneofIndex()) {
                field = this.toField(file, fieldDescriptorProto, true);
                ((ImmutableList.Builder)((Map.Entry)oneofs.get(fieldDescriptorProto.getOneofIndex())).getValue()).add(field);
                continue;
            }
            field = this.toField(file, fieldDescriptorProto, false);
            fields.add(field);
        }
        for (DescriptorProtos.DescriptorProto descriptorProto : descriptor.getNestedTypeList()) {
            MessageElement nestedMessage = this.toMessage(file, descriptorProto);
            nested.add(nestedMessage);
        }
        for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : descriptor.getEnumTypeList()) {
            EnumElement nestedEnum = this.toEnum(enumDescriptorProto);
            nested.add(nestedEnum);
        }
        for (DescriptorProtos.DescriptorProto.ReservedRange reservedRange : descriptor.getReservedRangeList()) {
            reservedElem = this.toReserved(reservedRange);
            reserved.add(reservedElem);
        }
        for (String string : descriptor.getReservedNameList()) {
            reservedElem = new ReservedElement(DEFAULT_LOCATION, "", Collections.singletonList(string));
            reserved.add(reservedElem);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (descriptor.getOptions().hasMapEntry()) {
            OptionElement.Kind kind = OptionElement.Kind.BOOLEAN;
            OptionElement option = new OptionElement("map_entry", kind, descriptor.getOptions().getMapEntry(), false);
            builder.add(option);
        }
        return new MessageElement(DEFAULT_LOCATION, name, "", (List<? extends TypeElement>)((Object)nested.build()), (List<OptionElement>)((Object)builder.build()), (List<ReservedElement>)((Object)reserved.build()), (List<FieldElement>)((Object)fields.build()), oneofs.stream().map(e -> this.toOneof((String)e.getKey(), (ImmutableList.Builder)e.getValue())).collect(Collectors.toList()), Collections.emptyList(), Collections.emptyList());
    }

    private ReservedElement toReserved(DescriptorProtos.DescriptorProto.ReservedRange range) {
        int end;
        ArrayList<Object> values2 = new ArrayList<Object>();
        int start = range.getStart();
        values2.add(start == (end = range.getEnd()) ? Integer.valueOf(start) : new IntRange(start, end));
        return new ReservedElement(DEFAULT_LOCATION, "", values2);
    }

    private OneOfElement toOneof(String name, ImmutableList.Builder<FieldElement> fields) {
        log.trace("*** oneof name: {}", (Object)name);
        return new OneOfElement(name, "", (List<FieldElement>)((Object)fields.build()), Collections.emptyList());
    }

    private EnumElement toEnum(DescriptorProtos.EnumDescriptorProto ed) {
        String name = ed.getName();
        log.trace("*** enum name: {}", (Object)name);
        ImmutableList.Builder constants = ImmutableList.builder();
        for (DescriptorProtos.EnumValueDescriptorProto ev : ed.getValueList()) {
            constants.add(new EnumConstantElement(DEFAULT_LOCATION, ev.getName(), ev.getNumber(), "", Collections.emptyList()));
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (ed.getOptions().hasAllowAlias()) {
            OptionElement.Kind kind = OptionElement.Kind.BOOLEAN;
            OptionElement option = new OptionElement("allow_alias", kind, ed.getOptions().getAllowAlias(), false);
            options.add(option);
        }
        return new EnumElement(DEFAULT_LOCATION, name, "", (List<OptionElement>)((Object)options.build()), (List<EnumConstantElement>)((Object)constants.build()));
    }

    private FieldElement toField(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.FieldDescriptorProto fd, boolean inOneof) {
        OptionElement option;
        OptionElement.Kind kind;
        String name = fd.getName();
        log.trace("*** field name: {}", (Object)name);
        ImmutableList.Builder options = ImmutableList.builder();
        if (fd.getOptions().hasPacked()) {
            kind = OptionElement.Kind.BOOLEAN;
            option = new OptionElement("packed", kind, fd.getOptions().getPacked(), false);
            options.add(option);
        }
        if (fd.hasJsonName()) {
            kind = OptionElement.Kind.STRING;
            option = new OptionElement("json_name", kind, fd.getJsonName(), false);
            options.add(option);
        }
        String defaultValue = fd.hasDefaultValue() && fd.getDefaultValue() != null ? fd.getDefaultValue() : null;
        return new FieldElement(DEFAULT_LOCATION, inOneof ? null : this.label(file, fd), this.dataType(fd), name, defaultValue, fd.getNumber(), "", (List<OptionElement>)((Object)options.build()));
    }

    private Field.Label label(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.FieldDescriptorProto fd) {
        boolean isProto3 = file.getSyntax().equals(PROTO3);
        switch (fd.getLabel()) {
            case LABEL_REQUIRED: {
                return isProto3 ? null : Field.Label.REQUIRED;
            }
            case LABEL_OPTIONAL: {
                return isProto3 ? null : Field.Label.OPTIONAL;
            }
            case LABEL_REPEATED: {
                return Field.Label.REPEATED;
            }
        }
        throw new IllegalArgumentException("Unsupported label");
    }

    private String dataType(DescriptorProtos.FieldDescriptorProto field) {
        if (field.hasTypeName()) {
            return field.getTypeName();
        }
        DescriptorProtos.FieldDescriptorProto.Type type = field.getType();
        return Descriptors.FieldDescriptor.Type.valueOf(type).name().toLowerCase();
    }

    public Descriptors.Descriptor toDescriptor() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.descriptor == null) {
            this.descriptor = this.toDescriptor(this.name());
        }
        return this.descriptor;
    }

    public Descriptors.Descriptor toDescriptor(String name) {
        return this.toDynamicSchema().getMessageDescriptor(name);
    }

    public DynamicMessage.Builder newMessageBuilder() {
        return this.newMessageBuilder(this.name());
    }

    public DynamicMessage.Builder newMessageBuilder(String name) {
        return this.toDynamicSchema().newMessageBuilder(name);
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, int enumNumber) {
        return this.toDynamicSchema().getEnumValue(enumTypeName, enumNumber);
    }

    private MessageElement firstMessage() {
        for (TypeElement typeElement : this.schemaObj.getTypes()) {
            if (!(typeElement instanceof MessageElement)) continue;
            return (MessageElement)typeElement;
        }
        throw new IllegalArgumentException("Protobuf schema definition contains no message type definitions");
    }

    @VisibleForTesting
    protected DynamicSchema toDynamicSchema() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.dynamicSchema == null) {
            this.dynamicSchema = ProtobufSchema.toDynamicSchema(DEFAULT_NAME, this.schemaObj, this.dependencies);
        }
        return this.dynamicSchema;
    }

    private static DynamicSchema toDynamicSchema(String name, ProtoFileElement rootElem, Map<String, ProtoFileElement> dependencies) {
        log.trace("*** toDynamicSchema: {}", (Object)rootElem.toSchema());
        DynamicSchema.Builder schema = DynamicSchema.newBuilder();
        try {
            Boolean javaMultipleFiles;
            String javaOuterClassname;
            ProtoFileElement dep;
            ProtoFile.Syntax syntax = rootElem.getSyntax();
            if (syntax != null) {
                schema.setSyntax(syntax.toString());
            }
            if (rootElem.getPackageName() != null) {
                schema.setPackage(rootElem.getPackageName());
            }
            for (TypeElement typeElem : rootElem.getTypes()) {
                if (typeElem instanceof MessageElement) {
                    MessageDefinition message = ProtobufSchema.toDynamicMessage((MessageElement)typeElem);
                    schema.addMessageDefinition(message);
                    continue;
                }
                if (!(typeElem instanceof EnumElement)) continue;
                EnumDefinition enumer = ProtobufSchema.toDynamicEnum((EnumElement)typeElem);
                schema.addEnumDefinition(enumer);
            }
            for (String ref : rootElem.getImports()) {
                dep = dependencies.get(ref);
                if (dep == null) continue;
                schema.addDependency(ref);
                schema.addSchema(ProtobufSchema.toDynamicSchema(ref, dep, dependencies));
            }
            for (String ref : rootElem.getPublicImports()) {
                dep = dependencies.get(ref);
                if (dep == null) continue;
                schema.addPublicDependency(ref);
                schema.addSchema(ProtobufSchema.toDynamicSchema(ref, dep, dependencies));
            }
            String javaPackageName = ProtobufSchema.findOption("java_package", rootElem.getOptions()).map(o -> o.getValue().toString()).orElse(null);
            if (javaPackageName != null) {
                schema.setJavaPackage(javaPackageName);
            }
            if ((javaOuterClassname = (String)ProtobufSchema.findOption("java_outer_classname", rootElem.getOptions()).map(o -> o.getValue().toString()).orElse(null)) != null) {
                schema.setJavaOuterClassname(javaOuterClassname);
            }
            if ((javaMultipleFiles = (Boolean)ProtobufSchema.findOption("java_multiple_files", rootElem.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null)) != null) {
                schema.setJavaMultipleFiles(javaMultipleFiles);
            }
            schema.setName(name);
            return schema.build();
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MessageDefinition toDynamicMessage(MessageElement messageElem) {
        String jsonName;
        String defaultVal;
        log.trace("*** message: {}", (Object)messageElem.getName());
        MessageDefinition.Builder message = MessageDefinition.newBuilder(messageElem.getName());
        for (TypeElement typeElement : messageElem.getNestedTypes()) {
            if (typeElement instanceof MessageElement) {
                message.addMessageDefinition(ProtobufSchema.toDynamicMessage((MessageElement)typeElement));
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            message.addEnumDefinition(ProtobufSchema.toDynamicEnum((EnumElement)typeElement));
        }
        HashSet<String> added = new HashSet<String>();
        for (OneOfElement oneof : messageElem.getOneOfs()) {
            MessageDefinition.OneofBuilder oneofBuilder = message.addOneof(oneof.getName());
            for (FieldElement field : oneof.getFields()) {
                defaultVal = field.getDefaultValue();
                jsonName = ProtobufSchema.findOption("json_name", field.getOptions()).map(o -> o.getValue().toString()).orElse(null);
                oneofBuilder.addField(field.getType(), field.getName(), field.getTag(), defaultVal, jsonName);
                added.add(field.getName());
            }
        }
        for (FieldElement field : messageElem.getFields()) {
            if (added.contains(field.getName())) continue;
            Field.Label fieldLabel = field.getLabel();
            String label = fieldLabel != null ? fieldLabel.toString().toLowerCase() : null;
            String fieldType = field.getType();
            defaultVal = field.getDefaultValue();
            jsonName = ProtobufSchema.findOption("json_name", field.getOptions()).map(o -> o.getValue().toString()).orElse(null);
            Boolean isPacked = ProtobufSchema.findOption("packed", field.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
            ProtoType protoType = ProtoType.get(fieldType);
            ProtoType keyType = protoType.getKeyType();
            ProtoType valueType = protoType.getValueType();
            if (protoType.isMap() && keyType != null && valueType != null) {
                label = "repeated";
                fieldType = ProtobufSchema.toMapEntry(field.getName());
                MessageDefinition.Builder mapMessage = MessageDefinition.newBuilder(fieldType);
                mapMessage.setMapEntry(true);
                mapMessage.addField(null, keyType.getSimpleName(), KEY_FIELD, 1, null);
                mapMessage.addField(null, valueType.getSimpleName(), VALUE_FIELD, 2, null);
                message.addMessageDefinition(mapMessage.build());
            }
            message.addField(label, fieldType, field.getName(), field.getTag(), defaultVal, jsonName, isPacked);
        }
        for (ReservedElement reserved : messageElem.getReserveds()) {
            for (Object elem : reserved.getValues()) {
                if (elem instanceof String) {
                    message.addReservedName((String)elem);
                    continue;
                }
                if (elem instanceof Integer) {
                    int tag = (Integer)elem;
                    message.addReservedRange(tag, tag);
                    continue;
                }
                if (elem instanceof IntRange) {
                    IntRange range = (IntRange)elem;
                    message.addReservedRange(range.getStart(), range.getEndInclusive());
                    continue;
                }
                throw new IllegalStateException("Unsupported reserved type: " + elem.getClass().getName());
            }
        }
        Boolean bl = ProtobufSchema.findOption("map_entry", messageElem.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
        if (bl != null) {
            message.setMapEntry(bl);
        }
        return message.build();
    }

    public static Optional<OptionElement> findOption(String name, List<OptionElement> options) {
        return options.stream().filter(o -> o.getName().equals(name)).findFirst();
    }

    private static EnumDefinition toDynamicEnum(EnumElement enumElem) {
        Boolean allowAlias = ProtobufSchema.findOption("allow_alias", enumElem.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
        EnumDefinition.Builder enumer = EnumDefinition.newBuilder(enumElem.getName(), allowAlias);
        for (EnumConstantElement constant : enumElem.getConstants()) {
            enumer.addValue(constant.getName(), constant.getTag());
        }
        return enumer.build();
    }

    @Override
    public ProtoFileElement rawSchema() {
        return this.schemaObj;
    }

    @Override
    public String schemaType() {
        return TYPE;
    }

    @Override
    public String name() {
        return this.name != null ? this.name : this.firstMessage().getName();
    }

    @Override
    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            this.canonicalString = this.schemaObj.toSchema().replaceAll("//.*?\\n", "");
        }
        return this.canonicalString;
    }

    @Override
    public String formattedString(String format) {
        if (SERIALIZED_FORMAT.equals(format)) {
            DescriptorProtos.FileDescriptorProto file = this.toDynamicSchema().getFileDescriptorProto();
            return base64Encoder.encodeToString(file.toByteArray());
        }
        throw new IllegalArgumentException("Unsupported format " + format);
    }

    public Integer version() {
        return this.version;
    }

    @Override
    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.dependencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ProtoFileElement)e.getValue()).toSchema()));
    }

    public Map<String, ProtoFileElement> dependencies() {
        return this.dependencies;
    }

    @Override
    public void validate() {
        this.toDynamicSchema();
    }

    @Override
    public boolean isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return false;
        }
        List<Difference> differences = SchemaDiff.compare((ProtobufSchema)previousSchema, this);
        List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains((Object)diff.getType())).collect(Collectors.toList());
        boolean isCompatible = incompatibleDiffs.isEmpty();
        if (!isCompatible) {
            boolean first = true;
            for (Difference incompatibleDiff : incompatibleDiffs) {
                if (first) {
                    log.warn("Found incompatible change: {}", (Object)incompatibleDiff);
                    first = false;
                    continue;
                }
                log.debug("Found incompatible change: {}", (Object)incompatibleDiff);
            }
        }
        return isCompatible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtobufSchema that = (ProtobufSchema)o;
        return Objects.equals(this.canonicalString(), that.canonicalString()) && Objects.equals(this.references, that.references) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.canonicalString(), this.references, this.version);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }

    public String fullName() {
        Descriptors.Descriptor descriptor = this.toDescriptor();
        Descriptors.FileDescriptor fd = descriptor.getFile();
        DescriptorProtos.FileOptions o = fd.getOptions();
        String p = o.hasJavaPackage() ? o.getJavaPackage() : fd.getPackage();
        String outer = "";
        if (!o.getJavaMultipleFiles()) {
            if (o.hasJavaOuterClassname()) {
                outer = o.getJavaOuterClassname();
            } else {
                return null;
            }
        }
        StringBuilder inner = new StringBuilder();
        while (descriptor != null) {
            if (inner.length() == 0) {
                inner.insert(0, descriptor.getName());
            } else {
                inner.insert(0, descriptor.getName() + "$");
            }
            descriptor = descriptor.getContainingType();
        }
        String d1 = !outer.isEmpty() || inner.length() != 0 ? "." : "";
        String d2 = !outer.isEmpty() && inner.length() != 0 ? "$" : "";
        return p + d1 + outer + d2 + inner;
    }

    public MessageIndexes toMessageIndexes(String name) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        String[] parts = name.split("\\.");
        List<TypeElement> types = this.schemaObj.getTypes();
        block0: for (String part : parts) {
            int i = 0;
            for (TypeElement type : types) {
                if (!(type instanceof MessageElement)) continue;
                if (type.getName().equals(part)) {
                    indexes.add(i);
                    types = type.getNestedTypes();
                    continue block0;
                }
                ++i;
            }
        }
        return new MessageIndexes(indexes);
    }

    public String toMessageName(MessageIndexes indexes) {
        StringBuilder sb = new StringBuilder();
        List<TypeElement> types = this.schemaObj.getTypes();
        boolean first = true;
        for (Integer index : indexes.indexes()) {
            if (!first) {
                sb.append(".");
            } else {
                first = false;
            }
            MessageElement message = this.getMessageAtIndex(types, index);
            if (message == null) {
                throw new IllegalArgumentException("Invalid message indexes: " + indexes);
            }
            sb.append(message.getName());
            types = message.getNestedTypes();
        }
        String messageName = sb.toString();
        String packageName = this.schemaObj.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + '.' + messageName : messageName;
    }

    private MessageElement getMessageAtIndex(List<TypeElement> types, int index) {
        int i = 0;
        for (TypeElement type : types) {
            if (!(type instanceof MessageElement)) continue;
            if (index == i) {
                return (MessageElement)type;
            }
            ++i;
        }
        return null;
    }

    public static String toMapEntry(String s) {
        if (s.contains("_")) {
            s = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s);
        }
        return s + MAP_ENTRY_SUFFIX;
    }

    public static String toMapField(String s) {
        if (s.endsWith(MAP_ENTRY_SUFFIX)) {
            s = s.substring(0, s.length() - MAP_ENTRY_SUFFIX.length());
            s = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, s);
        }
        return s;
    }
}

