/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import java.io.BufferedReader;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.Serializer;

public class ProtobufMessageReader
extends SchemaMessageReader<Message> {
    public ProtobufMessageReader() {
    }

    ProtobufMessageReader(SchemaRegistryClient schemaRegistryClient, ProtobufSchema keySchema, ProtobufSchema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean autoRegister, boolean useLatest) {
        super(schemaRegistryClient, keySchema, valueSchema, topic, parseKey, reader, autoRegister, useLatest);
    }

    @Override
    protected SchemaMessageSerializer<Message> createSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
        return new ProtobufMessageSerializer(schemaRegistryClient, autoRegister, useLatest, keySerializer);
    }

    @Override
    protected SchemaProvider getProvider() {
        return new ProtobufSchemaProvider();
    }

    @Override
    protected Message readFrom(String jsonString, ParsedSchema schema) {
        try {
            return (Message)ProtobufSchemaUtils.toObject(jsonString, (ProtobufSchema)schema);
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Protobuf of schema %s", jsonString, schema), e);
        }
    }

    static class ProtobufMessageSerializer
    extends AbstractKafkaProtobufSerializer
    implements SchemaMessageSerializer<Message> {
        protected final Serializer keySerializer;

        ProtobufMessageSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.autoRegisterSchema = autoRegister;
            this.useLatestVersion = useLatest;
            this.keySerializer = keySerializer;
        }

        @Override
        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        @Override
        public byte[] serializeKey(String topic, Object payload) {
            return this.keySerializer.serialize(topic, payload);
        }

        @Override
        public byte[] serialize(String subject, String topic, boolean isKey, Message object, ParsedSchema schema) {
            return super.serializeImpl(subject, topic, isKey, object, (ProtobufSchema)schema);
        }
    }
}

