/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.pinot.shaded.com.google.common.io.Closer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0007\u00a2\u0006\u0002\b\u0017J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0007\u00a2\u0006\u0002\b\u0018R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/squareup/wire/schema/SchemaLoader;", "", "()V", "protos", "", "", "()Ljava/util/List;", "sources", "Ljava/nio/file/Path;", "addProto", "proto", "addSource", "file", "Ljava/io/File;", "path", "load", "Lcom/squareup/wire/schema/Schema;", "loadFromDirectories", "directories", "", "loadSpecialProto", "Lcom/squareup/wire/schema/ProtoFile;", "", "-deprecated_protos", "-deprecated_sources", "Companion", "wire-schema"})
public final class SchemaLoader {
    @NotNull
    private final List<Path> sources;
    @NotNull
    private final List<String> protos;
    private static final String ANY_PROTO = "google/protobuf/any.proto";
    private static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    public static final Companion Companion = new Companion(null);

    @JvmName(name="sources")
    @NotNull
    public final List<Path> sources() {
        return this.sources;
    }

    @JvmName(name="protos")
    @NotNull
    public final List<String> protos() {
        return this.protos;
    }

    @NotNull
    public final SchemaLoader addSource(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        SchemaLoader schemaLoader = this;
        boolean bl = false;
        boolean bl2 = false;
        SchemaLoader $this$apply = schemaLoader;
        boolean bl3 = false;
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull(path, "file.toPath()");
        $this$apply.addSource(path);
        return schemaLoader;
    }

    @NotNull
    public final SchemaLoader addSource(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        SchemaLoader schemaLoader = this;
        boolean bl = false;
        boolean bl2 = false;
        SchemaLoader $this$apply = schemaLoader;
        boolean bl3 = false;
        $this$apply.sources.add(path);
        return schemaLoader;
    }

    @Deprecated(message="Moved to property", replaceWith=@ReplaceWith(imports={}, expression="this.sources"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_sources")
    @NotNull
    public final List<Path> -deprecated_sources() {
        return this.sources;
    }

    @NotNull
    public final SchemaLoader addProto(@NotNull String proto) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        SchemaLoader schemaLoader = this;
        boolean bl = false;
        boolean bl2 = false;
        SchemaLoader $this$apply = schemaLoader;
        boolean bl3 = false;
        $this$apply.protos.add(proto);
        return schemaLoader;
    }

    @Deprecated(message="Moved to property", replaceWith=@ReplaceWith(imports={}, expression="this.protos"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protos")
    @NotNull
    public final List<String> -deprecated_protos() {
        return this.protos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Schema load() throws IOException {
        Collection collection = this.sources;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "No sources added.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Closeable closeable = Closer.create();
        bl = false;
        Throwable throwable = null;
        try {
            Closer closer = (Closer)closeable;
            boolean bl5 = false;
            boolean bl6 = false;
            Map directories = new LinkedHashMap();
            for (Path source : this.sources) {
                Path path;
                Map map = directories;
                Path path2 = source;
                if (Files.isRegularFile(source, new LinkOption[0])) {
                    FileSystem sourceFs;
                    FileSystem fileSystem = FileSystems.newFileSystem(source, this.getClass().getClassLoader());
                    Path path3 = path2;
                    Map map2 = map;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FileSystem it = fileSystem;
                    boolean bl9 = false;
                    closer.register((Closeable)it);
                    FileSystem fileSystem2 = fileSystem;
                    map = map2;
                    path2 = path3;
                    FileSystem fileSystem3 = sourceFs = fileSystem2;
                    Intrinsics.checkExpressionValueIsNotNull(fileSystem3, "sourceFs");
                    Iterable<Path> iterable = fileSystem3.getRootDirectories();
                    Intrinsics.checkExpressionValueIsNotNull(iterable, "sourceFs.rootDirectories");
                    path = CollectionsKt.single(iterable);
                } else {
                    path = source;
                }
                Intrinsics.checkExpressionValueIsNotNull(path, "when {\n          Files.i\u2026rce\n          }\n        }");
                map.put(path2, path);
            }
            Schema schema = this.loadFromDirectories(directories);
            return schema;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Schema loadFromDirectories(Map<Path, ? extends Path> directories) throws IOException {
        ArrayDeque<String> protos = new ArrayDeque<String>((Collection)this.protos);
        if (protos.isEmpty()) {
            for (Path path : directories.values()) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(protos, path){
                    final /* synthetic */ ArrayDeque $protos;
                    final /* synthetic */ Path $value;

                    @NotNull
                    public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                        Intrinsics.checkParameterIsNotNull(file, "file");
                        Intrinsics.checkParameterIsNotNull(attrs, "attrs");
                        if (StringsKt.endsWith$default(((Object)file.getFileName()).toString(), ".proto", false, 2, null)) {
                            String string = ((Object)this.$value.relativize(file)).toString();
                            String string2 = File.separator;
                            Intrinsics.checkExpressionValueIsNotNull(string2, "File.separator");
                            this.$protos.add(StringsKt.replace$default(string, string2, "/", false, 4, null));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        this.$protos = $captured_local_variable$0;
                        this.$value = $captured_local_variable$1;
                    }
                });
            }
        }
        boolean bl = false;
        Map map = new LinkedHashMap();
        map.put(DESCRIPTOR_PROTO, this.loadSpecialProto(DESCRIPTOR_PROTO));
        map.put(ANY_PROTO, this.loadSpecialProto(ANY_PROTO));
        while (!protos.isEmpty()) {
            String proto = (String)protos.removeFirst();
            if (map.containsKey(proto)) continue;
            ProtoFileElement element = null;
            Object object = directories;
            boolean bl2 = false;
            Iterator<Object> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                Source source;
                void base;
                Map.Entry<Path, ? extends Path> entry;
                Map.Entry<Path, ? extends Path> entry2 = entry = iterator2.next();
                boolean bl3 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl3 = false;
                Path value = entry2.getValue();
                String string = proto;
                Intrinsics.checkExpressionValueIsNotNull(string, "proto");
                if (SchemaLoader.Companion.source(value, string) == null) {
                    continue;
                }
                try {
                    Location location = Location.Companion.get(base.toString(), proto);
                    String data = Okio.buffer((Source)source).readUtf8();
                    element = ProtoParser.Companion.parse(location, data);
                    break;
                }
                catch (IOException e) {
                    throw (Throwable)new IOException("Failed to load " + proto + " from " + base, e);
                }
                finally {
                    source.close();
                }
            }
            if (element == null) {
                throw (Throwable)new FileNotFoundException("Failed to locate " + proto + " in " + this.sources);
            }
            String string = proto;
            Intrinsics.checkExpressionValueIsNotNull(string, "proto");
            map.put(string, ProtoFile.Companion.get(element));
            for (String importPath : element.getImports()) {
                protos.addLast(importPath);
            }
        }
        return new Linker(CoreLoader.INSTANCE).link(map.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProtoFile loadSpecialProto(String path) throws IOException {
        InputStream inputStream = SchemaLoader.class.getResourceAsStream('/' + path);
        Intrinsics.checkExpressionValueIsNotNull(inputStream, "SchemaLoader::class.java\u2026esourceAsStream(\"/$path\")");
        Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((InputStream)inputStream));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl2 = false;
            String data = it.readUtf8();
            Location location = Location.Companion.get("", path);
            ProtoFileElement element = ProtoParser.Companion.parse(location, data);
            ProtoFile protoFile = ProtoFile.Companion.get(element);
            return protoFile;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public SchemaLoader() {
        List list;
        SchemaLoader schemaLoader = this;
        boolean bl = false;
        schemaLoader.sources = list = (List)new ArrayList();
        schemaLoader = this;
        bl = false;
        schemaLoader.protos = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/squareup/wire/schema/SchemaLoader$Companion;", "", "()V", "ANY_PROTO", "", "DESCRIPTOR_PROTO", "source", "Lokio/Source;", "base", "Ljava/nio/file/Path;", "path", "wire-schema"})
    public static final class Companion {
        private final Source source(Path base, String path) throws IOException {
            Source source;
            Path resolvedPath = base.resolve(path);
            if (Files.exists(resolvedPath, new LinkOption[0])) {
                Path path2 = resolvedPath;
                Intrinsics.checkExpressionValueIsNotNull(path2, "resolvedPath");
                source = Okio.source((Path)path2, (OpenOption[])new OpenOption[0]);
            } else {
                source = null;
            }
            return source;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

