/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.SchemaProtoAdapterFactory;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001cJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\rJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/squareup/wire/schema/Schema;", "", "protoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "(Ljava/lang/Iterable;)V", "", "getProtoFiles", "()Ljava/util/List;", "protoFilesIndex", "", "Lcom/squareup/wire/schema/ProtoType;", "servicesIndex", "", "Lcom/squareup/wire/schema/Service;", "typesIndex", "Lcom/squareup/wire/schema/Type;", "getField", "Lcom/squareup/wire/schema/Field;", "protoMember", "Lcom/squareup/wire/schema/ProtoMember;", "protoType", "memberName", "typeName", "getService", "name", "getType", "isExtensionField", "", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "includeUnknown", "protoFile", "path", "prune", "pruningRules", "Lcom/squareup/wire/schema/PruningRules;", "Companion", "wire-schema"})
public final class Schema {
    @NotNull
    private final List<ProtoFile> protoFiles;
    private final Map<ProtoType, ProtoFile> protoFilesIndex;
    private final Map<String, Type> typesIndex;
    private final Map<String, Service> servicesIndex;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<ProtoFile> getProtoFiles() {
        return this.protoFiles;
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull String path) {
        Object element$iv2;
        block1: {
            Intrinsics.checkParameterIsNotNull(path, "path");
            Iterable $this$first$iv = this.protoFiles;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                ProtoFile it = (ProtoFile)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getLocation().getPath(), path)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (ProtoFile)element$iv2;
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull ProtoType protoType) {
        Intrinsics.checkParameterIsNotNull(protoType, "protoType");
        return this.protoFilesIndex.get(protoType);
    }

    @NotNull
    public final Schema prune(@NotNull PruningRules pruningRules) {
        Intrinsics.checkParameterIsNotNull(pruningRules, "pruningRules");
        return new Pruner(this, pruningRules).prune();
    }

    @Nullable
    public final Service getService(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.servicesIndex.get(name);
    }

    @Nullable
    public final Service getService(@NotNull ProtoType protoType) {
        Intrinsics.checkParameterIsNotNull(protoType, "protoType");
        return this.getService(protoType.toString());
    }

    @Nullable
    public final Type getType(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.typesIndex.get(name);
    }

    @Nullable
    public final Type getType(@NotNull ProtoType protoType) {
        Intrinsics.checkParameterIsNotNull(protoType, "protoType");
        return this.getType(protoType.toString());
    }

    @Nullable
    public final Field getField(@NotNull ProtoMember protoMember) {
        Intrinsics.checkParameterIsNotNull(protoMember, "protoMember");
        Type type = this.getType(protoMember.getType());
        if (!(type instanceof MessageType)) {
            type = null;
        }
        MessageType messageType = (MessageType)type;
        if (messageType == null) {
            return null;
        }
        MessageType type2 = messageType;
        Field field = type2.field(protoMember.getMember());
        if (field == null) {
            field = type2.extensionField(protoMember.getMember());
        }
        return field;
    }

    @Nullable
    public final Field getField(@NotNull String typeName, @NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull(typeName, "typeName");
        Intrinsics.checkParameterIsNotNull(memberName, "memberName");
        return this.getField(ProtoType.Companion.get(typeName), memberName);
    }

    @Nullable
    public final Field getField(@NotNull ProtoType protoType, @NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull(protoType, "protoType");
        Intrinsics.checkParameterIsNotNull(memberName, "memberName");
        return this.getField(ProtoMember.Companion.get(protoType, memberName));
    }

    @NotNull
    public final ProtoAdapter<Object> protoAdapter(@NotNull String typeName, boolean includeUnknown) {
        Intrinsics.checkParameterIsNotNull(typeName, "typeName");
        Type type = this.getType(typeName);
        boolean bl = false;
        boolean bl2 = false;
        if (type == null) {
            boolean bl3 = false;
            String string = "unexpected type " + typeName;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Type type2 = type;
        return new SchemaProtoAdapterFactory(this, includeUnknown).get(type2.getType());
    }

    public final boolean isExtensionField(@NotNull ProtoMember protoMember) {
        Intrinsics.checkParameterIsNotNull(protoMember, "protoMember");
        Type type = this.getType(protoMember.getType());
        return type instanceof MessageType && ((MessageType)type).extensionField(protoMember.getMember()) != null;
    }

    /*
     * WARNING - void declaration
     */
    public Schema(@NotNull Iterable<ProtoFile> protoFiles) {
        void $this$sortedBy$iv;
        Intrinsics.checkParameterIsNotNull(protoFiles, "protoFiles");
        Iterable<ProtoFile> iterable = protoFiles;
        Schema schema = this;
        boolean $i$f$sortedBy = false;
        void var4_5 = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ProtoFile it = (ProtoFile)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getLocation().getPath());
                it = (ProtoFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getLocation().getPath();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
            }
        };
        List list = CollectionsKt.sortedWith(var4_5, comparator);
        schema.protoFiles = list;
        boolean bl2 = false;
        Map index = new LinkedHashMap();
        this.typesIndex = Schema.Companion.buildTypesIndex(protoFiles, index);
        this.servicesIndex = Schema.Companion.buildServicesIndex(protoFiles, index);
        this.protoFilesIndex = index;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0002J:\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0002J \u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/squareup/wire/schema/Schema$Companion;", "", "()V", "buildServicesIndex", "", "", "Lcom/squareup/wire/schema/Service;", "protoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "protoFilesIndex", "", "Lcom/squareup/wire/schema/ProtoType;", "buildTypesIndex", "Lcom/squareup/wire/schema/Type;", "fromFiles", "Lcom/squareup/wire/schema/Schema;", "sourceProtoFiles", "pathFilesLoader", "Lcom/squareup/wire/schema/Loader;", "wire-schema"})
    public static final class Companion {
        @JvmOverloads
        @NotNull
        public final Schema fromFiles(@NotNull Iterable<ProtoFile> sourceProtoFiles, @NotNull Loader pathFilesLoader) {
            Intrinsics.checkParameterIsNotNull(sourceProtoFiles, "sourceProtoFiles");
            Intrinsics.checkParameterIsNotNull(pathFilesLoader, "pathFilesLoader");
            return new Linker(pathFilesLoader).link(sourceProtoFiles);
        }

        public static /* synthetic */ Schema fromFiles$default(Companion companion, Iterable iterable, Loader loader, int n, Object object) {
            if ((n & 2) != 0) {
                loader = CoreLoader.INSTANCE;
            }
            return companion.fromFiles(iterable, loader);
        }

        @JvmOverloads
        @NotNull
        public final Schema fromFiles(@NotNull Iterable<ProtoFile> sourceProtoFiles) {
            return com.squareup.wire.schema.Schema$Companion.fromFiles$default(this, sourceProtoFiles, null, 2, null);
        }

        private final Map<String, Type> buildTypesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
            boolean bl = false;
            Map typesByName = new LinkedHashMap();
            Function2<Type, ProtoFile, Unit> $fun$index$1 = new Function2<Type, ProtoFile, Unit>(protoFilesIndex, typesByName){
                final /* synthetic */ Map $protoFilesIndex;
                final /* synthetic */ Map $typesByName;

                public final void invoke(@NotNull Type type, @NotNull ProtoFile protoFile) {
                    Intrinsics.checkParameterIsNotNull(type, "type");
                    Intrinsics.checkParameterIsNotNull(protoFile, "protoFile");
                    ProtoType protoType = type.getType();
                    Map map = this.$protoFilesIndex;
                    boolean bl = false;
                    Map map2 = map;
                    boolean bl2 = false;
                    if (!map2.containsKey(protoType)) {
                        this.$protoFilesIndex.put(protoType, protoFile);
                    }
                    this.$typesByName.put(protoType.toString(), type);
                    for (Type nested : type.getNestedTypes()) {
                        this.invoke(nested, protoFile);
                    }
                }
                {
                    this.$protoFilesIndex = map;
                    this.$typesByName = map2;
                    super(2);
                }
            };
            for (ProtoFile protoFile : protoFiles) {
                for (Type type : protoFile.getTypes()) {
                    $fun$index$1.invoke(type, protoFile);
                }
            }
            return typesByName;
        }

        private final Map<String, Service> buildServicesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
            boolean bl = false;
            Map result = new LinkedHashMap();
            for (ProtoFile protoFile : protoFiles) {
                for (Service service : protoFile.getServices()) {
                    result.put(service.type().toString(), service);
                    protoFilesIndex.put(service.type(), protoFile);
                }
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

